/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.datamanager.v1;

import com.google.ads.datamanager.v1.DestinationProto;
import com.google.ads.datamanager.v1.Product;
import com.google.ads.datamanager.v1.ProductAccountOrBuilder;
import com.google.protobuf.AbstractMessage;
import com.google.protobuf.AbstractParser;
import com.google.protobuf.ByteString;
import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import com.google.protobuf.Descriptors;
import com.google.protobuf.ExtensionRegistryLite;
import com.google.protobuf.GeneratedMessage;
import com.google.protobuf.Internal;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import com.google.protobuf.MessageLite;
import com.google.protobuf.Parser;
import com.google.protobuf.ProtocolMessageEnum;
import com.google.protobuf.RuntimeVersion;
import com.google.protobuf.UninitializedMessageException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;

public final class ProductAccount
extends GeneratedMessage
implements ProductAccountOrBuilder {
    private static final long serialVersionUID = 0L;
    public static final int PRODUCT_FIELD_NUMBER = 1;
    private int product_ = 0;
    public static final int ACCOUNT_ID_FIELD_NUMBER = 2;
    private volatile Object accountId_ = "";
    public static final int ACCOUNT_TYPE_FIELD_NUMBER = 3;
    private int accountType_ = 0;
    private byte memoizedIsInitialized = (byte)-1;
    private static final ProductAccount DEFAULT_INSTANCE;
    private static final Parser<ProductAccount> PARSER;

    private ProductAccount(GeneratedMessage.Builder<?> builder) {
        super(builder);
    }

    private ProductAccount() {
        this.product_ = 0;
        this.accountId_ = "";
        this.accountType_ = 0;
    }

    public static final Descriptors.Descriptor getDescriptor() {
        return DestinationProto.internal_static_google_ads_datamanager_v1_ProductAccount_descriptor;
    }

    protected GeneratedMessage.FieldAccessorTable internalGetFieldAccessorTable() {
        return DestinationProto.internal_static_google_ads_datamanager_v1_ProductAccount_fieldAccessorTable.ensureFieldAccessorsInitialized(ProductAccount.class, Builder.class);
    }

    @Override
    @Deprecated
    public int getProductValue() {
        return this.product_;
    }

    @Override
    @Deprecated
    public Product getProduct() {
        Product result = Product.forNumber(this.product_);
        return result == null ? Product.UNRECOGNIZED : result;
    }

    @Override
    public String getAccountId() {
        Object ref = this.accountId_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.accountId_ = s;
        return s;
    }

    @Override
    public ByteString getAccountIdBytes() {
        Object ref = this.accountId_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)((String)ref));
            this.accountId_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    @Override
    public int getAccountTypeValue() {
        return this.accountType_;
    }

    @Override
    public AccountType getAccountType() {
        AccountType result = AccountType.forNumber(this.accountType_);
        return result == null ? AccountType.UNRECOGNIZED : result;
    }

    public final boolean isInitialized() {
        byte isInitialized = this.memoizedIsInitialized;
        if (isInitialized == 1) {
            return true;
        }
        if (isInitialized == 0) {
            return false;
        }
        this.memoizedIsInitialized = 1;
        return true;
    }

    public void writeTo(CodedOutputStream output) throws IOException {
        if (this.product_ != Product.PRODUCT_UNSPECIFIED.getNumber()) {
            output.writeEnum(1, this.product_);
        }
        if (!GeneratedMessage.isStringEmpty((Object)this.accountId_)) {
            GeneratedMessage.writeString((CodedOutputStream)output, (int)2, (Object)this.accountId_);
        }
        if (this.accountType_ != AccountType.ACCOUNT_TYPE_UNSPECIFIED.getNumber()) {
            output.writeEnum(3, this.accountType_);
        }
        this.getUnknownFields().writeTo(output);
    }

    public int getSerializedSize() {
        int size = this.memoizedSize;
        if (size != -1) {
            return size;
        }
        size = 0;
        if (this.product_ != Product.PRODUCT_UNSPECIFIED.getNumber()) {
            size += CodedOutputStream.computeEnumSize((int)1, (int)this.product_);
        }
        if (!GeneratedMessage.isStringEmpty((Object)this.accountId_)) {
            size += GeneratedMessage.computeStringSize((int)2, (Object)this.accountId_);
        }
        if (this.accountType_ != AccountType.ACCOUNT_TYPE_UNSPECIFIED.getNumber()) {
            size += CodedOutputStream.computeEnumSize((int)3, (int)this.accountType_);
        }
        this.memoizedSize = size += this.getUnknownFields().getSerializedSize();
        return size;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ProductAccount)) {
            return super.equals(obj);
        }
        ProductAccount other = (ProductAccount)obj;
        if (this.product_ != other.product_) {
            return false;
        }
        if (!this.getAccountId().equals(other.getAccountId())) {
            return false;
        }
        if (this.accountType_ != other.accountType_) {
            return false;
        }
        return this.getUnknownFields().equals((Object)other.getUnknownFields());
    }

    public int hashCode() {
        if (this.memoizedHashCode != 0) {
            return this.memoizedHashCode;
        }
        int hash = 41;
        hash = 19 * hash + ProductAccount.getDescriptor().hashCode();
        hash = 37 * hash + 1;
        hash = 53 * hash + this.product_;
        hash = 37 * hash + 2;
        hash = 53 * hash + this.getAccountId().hashCode();
        hash = 37 * hash + 3;
        hash = 53 * hash + this.accountType_;
        this.memoizedHashCode = hash = 29 * hash + this.getUnknownFields().hashCode();
        return hash;
    }

    public static ProductAccount parseFrom(ByteBuffer data) throws InvalidProtocolBufferException {
        return (ProductAccount)PARSER.parseFrom(data);
    }

    public static ProductAccount parseFrom(ByteBuffer data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (ProductAccount)PARSER.parseFrom(data, extensionRegistry);
    }

    public static ProductAccount parseFrom(ByteString data) throws InvalidProtocolBufferException {
        return (ProductAccount)PARSER.parseFrom(data);
    }

    public static ProductAccount parseFrom(ByteString data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (ProductAccount)PARSER.parseFrom(data, extensionRegistry);
    }

    public static ProductAccount parseFrom(byte[] data) throws InvalidProtocolBufferException {
        return (ProductAccount)PARSER.parseFrom(data);
    }

    public static ProductAccount parseFrom(byte[] data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (ProductAccount)PARSER.parseFrom(data, extensionRegistry);
    }

    public static ProductAccount parseFrom(InputStream input) throws IOException {
        return (ProductAccount)GeneratedMessage.parseWithIOException(PARSER, (InputStream)input);
    }

    public static ProductAccount parseFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (ProductAccount)GeneratedMessage.parseWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public static ProductAccount parseDelimitedFrom(InputStream input) throws IOException {
        return (ProductAccount)GeneratedMessage.parseDelimitedWithIOException(PARSER, (InputStream)input);
    }

    public static ProductAccount parseDelimitedFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (ProductAccount)GeneratedMessage.parseDelimitedWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public static ProductAccount parseFrom(CodedInputStream input) throws IOException {
        return (ProductAccount)GeneratedMessage.parseWithIOException(PARSER, (CodedInputStream)input);
    }

    public static ProductAccount parseFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (ProductAccount)GeneratedMessage.parseWithIOException(PARSER, (CodedInputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public Builder newBuilderForType() {
        return ProductAccount.newBuilder();
    }

    public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(ProductAccount prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    protected Builder newBuilderForType(AbstractMessage.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
    }

    public static ProductAccount getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public static Parser<ProductAccount> parser() {
        return PARSER;
    }

    public Parser<ProductAccount> getParserForType() {
        return PARSER;
    }

    public ProductAccount getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
    }

    static {
        RuntimeVersion.validateProtobufGencodeVersion((RuntimeVersion.RuntimeDomain)RuntimeVersion.RuntimeDomain.PUBLIC, (int)4, (int)33, (int)0, (String)"", (String)"ProductAccount");
        DEFAULT_INSTANCE = new ProductAccount();
        PARSER = new AbstractParser<ProductAccount>(){

            public ProductAccount parsePartialFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
                Builder builder = ProductAccount.newBuilder();
                try {
                    builder.mergeFrom(input, extensionRegistry);
                }
                catch (InvalidProtocolBufferException e) {
                    throw e.setUnfinishedMessage((MessageLite)builder.buildPartial());
                }
                catch (UninitializedMessageException e) {
                    throw e.asInvalidProtocolBufferException().setUnfinishedMessage((MessageLite)builder.buildPartial());
                }
                catch (IOException e) {
                    throw new InvalidProtocolBufferException(e).setUnfinishedMessage((MessageLite)builder.buildPartial());
                }
                return builder.buildPartial();
            }
        };
    }

    public static final class Builder
    extends GeneratedMessage.Builder<Builder>
    implements ProductAccountOrBuilder {
        private int bitField0_;
        private int product_ = 0;
        private Object accountId_ = "";
        private int accountType_ = 0;

        public static final Descriptors.Descriptor getDescriptor() {
            return DestinationProto.internal_static_google_ads_datamanager_v1_ProductAccount_descriptor;
        }

        protected GeneratedMessage.FieldAccessorTable internalGetFieldAccessorTable() {
            return DestinationProto.internal_static_google_ads_datamanager_v1_ProductAccount_fieldAccessorTable.ensureFieldAccessorsInitialized(ProductAccount.class, Builder.class);
        }

        private Builder() {
        }

        private Builder(AbstractMessage.BuilderParent parent) {
            super(parent);
        }

        public Builder clear() {
            super.clear();
            this.bitField0_ = 0;
            this.product_ = 0;
            this.accountId_ = "";
            this.accountType_ = 0;
            return this;
        }

        public Descriptors.Descriptor getDescriptorForType() {
            return DestinationProto.internal_static_google_ads_datamanager_v1_ProductAccount_descriptor;
        }

        public ProductAccount getDefaultInstanceForType() {
            return ProductAccount.getDefaultInstance();
        }

        public ProductAccount build() {
            ProductAccount result = this.buildPartial();
            if (!result.isInitialized()) {
                throw Builder.newUninitializedMessageException((Message)result);
            }
            return result;
        }

        public ProductAccount buildPartial() {
            ProductAccount result = new ProductAccount(this);
            if (this.bitField0_ != 0) {
                this.buildPartial0(result);
            }
            this.onBuilt();
            return result;
        }

        private void buildPartial0(ProductAccount result) {
            int from_bitField0_ = this.bitField0_;
            if ((from_bitField0_ & 1) != 0) {
                result.product_ = this.product_;
            }
            if ((from_bitField0_ & 2) != 0) {
                result.accountId_ = this.accountId_;
            }
            if ((from_bitField0_ & 4) != 0) {
                result.accountType_ = this.accountType_;
            }
        }

        public Builder mergeFrom(Message other) {
            if (other instanceof ProductAccount) {
                return this.mergeFrom((ProductAccount)other);
            }
            super.mergeFrom(other);
            return this;
        }

        public Builder mergeFrom(ProductAccount other) {
            if (other == ProductAccount.getDefaultInstance()) {
                return this;
            }
            if (other.product_ != 0) {
                this.setProductValue(other.getProductValue());
            }
            if (!other.getAccountId().isEmpty()) {
                this.accountId_ = other.accountId_;
                this.bitField0_ |= 2;
                this.onChanged();
            }
            if (other.accountType_ != 0) {
                this.setAccountTypeValue(other.getAccountTypeValue());
            }
            this.mergeUnknownFields(other.getUnknownFields());
            this.onChanged();
            return this;
        }

        public final boolean isInitialized() {
            return true;
        }

        public Builder mergeFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            if (extensionRegistry == null) {
                throw new NullPointerException();
            }
            try {
                boolean done = false;
                block11: while (!done) {
                    int tag = input.readTag();
                    switch (tag) {
                        case 0: {
                            done = true;
                            continue block11;
                        }
                        case 8: {
                            this.product_ = input.readEnum();
                            this.bitField0_ |= 1;
                            continue block11;
                        }
                        case 18: {
                            this.accountId_ = input.readStringRequireUtf8();
                            this.bitField0_ |= 2;
                            continue block11;
                        }
                        case 24: {
                            this.accountType_ = input.readEnum();
                            this.bitField0_ |= 4;
                            continue block11;
                        }
                    }
                    if (super.parseUnknownField(input, extensionRegistry, tag)) continue;
                    done = true;
                }
            }
            catch (InvalidProtocolBufferException e) {
                throw e.unwrapIOException();
            }
            finally {
                this.onChanged();
            }
            return this;
        }

        @Override
        @Deprecated
        public int getProductValue() {
            return this.product_;
        }

        @Deprecated
        public Builder setProductValue(int value) {
            this.product_ = value;
            this.bitField0_ |= 1;
            this.onChanged();
            return this;
        }

        @Override
        @Deprecated
        public Product getProduct() {
            Product result = Product.forNumber(this.product_);
            return result == null ? Product.UNRECOGNIZED : result;
        }

        @Deprecated
        public Builder setProduct(Product value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.bitField0_ |= 1;
            this.product_ = value.getNumber();
            this.onChanged();
            return this;
        }

        @Deprecated
        public Builder clearProduct() {
            this.bitField0_ &= 0xFFFFFFFE;
            this.product_ = 0;
            this.onChanged();
            return this;
        }

        @Override
        public String getAccountId() {
            Object ref = this.accountId_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.accountId_ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getAccountIdBytes() {
            Object ref = this.accountId_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.accountId_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setAccountId(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.accountId_ = value;
            this.bitField0_ |= 2;
            this.onChanged();
            return this;
        }

        public Builder clearAccountId() {
            this.accountId_ = ProductAccount.getDefaultInstance().getAccountId();
            this.bitField0_ &= 0xFFFFFFFD;
            this.onChanged();
            return this;
        }

        public Builder setAccountIdBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            ProductAccount.checkByteStringIsUtf8((ByteString)value);
            this.accountId_ = value;
            this.bitField0_ |= 2;
            this.onChanged();
            return this;
        }

        @Override
        public int getAccountTypeValue() {
            return this.accountType_;
        }

        public Builder setAccountTypeValue(int value) {
            this.accountType_ = value;
            this.bitField0_ |= 4;
            this.onChanged();
            return this;
        }

        @Override
        public AccountType getAccountType() {
            AccountType result = AccountType.forNumber(this.accountType_);
            return result == null ? AccountType.UNRECOGNIZED : result;
        }

        public Builder setAccountType(AccountType value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.bitField0_ |= 4;
            this.accountType_ = value.getNumber();
            this.onChanged();
            return this;
        }

        public Builder clearAccountType() {
            this.bitField0_ &= 0xFFFFFFFB;
            this.accountType_ = 0;
            this.onChanged();
            return this;
        }
    }

    public static enum AccountType implements ProtocolMessageEnum
    {
        ACCOUNT_TYPE_UNSPECIFIED(0),
        GOOGLE_ADS(1),
        DISPLAY_VIDEO_PARTNER(2),
        DISPLAY_VIDEO_ADVERTISER(3),
        DATA_PARTNER(4),
        GOOGLE_ANALYTICS_PROPERTY(5),
        UNRECOGNIZED(-1);

        public static final int ACCOUNT_TYPE_UNSPECIFIED_VALUE = 0;
        public static final int GOOGLE_ADS_VALUE = 1;
        public static final int DISPLAY_VIDEO_PARTNER_VALUE = 2;
        public static final int DISPLAY_VIDEO_ADVERTISER_VALUE = 3;
        public static final int DATA_PARTNER_VALUE = 4;
        public static final int GOOGLE_ANALYTICS_PROPERTY_VALUE = 5;
        private static final Internal.EnumLiteMap<AccountType> internalValueMap;
        private static final AccountType[] VALUES;
        private final int value;

        public final int getNumber() {
            if (this == UNRECOGNIZED) {
                throw new IllegalArgumentException("Can't get the number of an unknown enum value.");
            }
            return this.value;
        }

        @Deprecated
        public static AccountType valueOf(int value) {
            return AccountType.forNumber(value);
        }

        public static AccountType forNumber(int value) {
            switch (value) {
                case 0: {
                    return ACCOUNT_TYPE_UNSPECIFIED;
                }
                case 1: {
                    return GOOGLE_ADS;
                }
                case 2: {
                    return DISPLAY_VIDEO_PARTNER;
                }
                case 3: {
                    return DISPLAY_VIDEO_ADVERTISER;
                }
                case 4: {
                    return DATA_PARTNER;
                }
                case 5: {
                    return GOOGLE_ANALYTICS_PROPERTY;
                }
            }
            return null;
        }

        public static Internal.EnumLiteMap<AccountType> internalGetValueMap() {
            return internalValueMap;
        }

        public final Descriptors.EnumValueDescriptor getValueDescriptor() {
            if (this == UNRECOGNIZED) {
                throw new IllegalStateException("Can't get the descriptor of an unrecognized enum value.");
            }
            return (Descriptors.EnumValueDescriptor)AccountType.getDescriptor().getValues().get(this.ordinal());
        }

        public final Descriptors.EnumDescriptor getDescriptorForType() {
            return AccountType.getDescriptor();
        }

        public static Descriptors.EnumDescriptor getDescriptor() {
            return (Descriptors.EnumDescriptor)ProductAccount.getDescriptor().getEnumTypes().get(0);
        }

        public static AccountType valueOf(Descriptors.EnumValueDescriptor desc) {
            if (desc.getType() != AccountType.getDescriptor()) {
                throw new IllegalArgumentException("EnumValueDescriptor is not for this type.");
            }
            if (desc.getIndex() == -1) {
                return UNRECOGNIZED;
            }
            return VALUES[desc.getIndex()];
        }

        private AccountType(int value) {
            this.value = value;
        }

        static {
            RuntimeVersion.validateProtobufGencodeVersion((RuntimeVersion.RuntimeDomain)RuntimeVersion.RuntimeDomain.PUBLIC, (int)4, (int)33, (int)0, (String)"", (String)"AccountType");
            internalValueMap = new Internal.EnumLiteMap<AccountType>(){

                public AccountType findValueByNumber(int number) {
                    return AccountType.forNumber(number);
                }
            };
            VALUES = AccountType.values();
        }
    }
}

