/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.datamanager.v1;

import com.google.ads.datamanager.v1.AdIdentifiers;
import com.google.ads.datamanager.v1.AdIdentifiersOrBuilder;
import com.google.ads.datamanager.v1.CartData;
import com.google.ads.datamanager.v1.CartDataOrBuilder;
import com.google.ads.datamanager.v1.Consent;
import com.google.ads.datamanager.v1.ConsentOrBuilder;
import com.google.ads.datamanager.v1.CustomVariable;
import com.google.ads.datamanager.v1.CustomVariableOrBuilder;
import com.google.ads.datamanager.v1.DeviceInfo;
import com.google.ads.datamanager.v1.DeviceInfoOrBuilder;
import com.google.ads.datamanager.v1.EventOrBuilder;
import com.google.ads.datamanager.v1.EventParameter;
import com.google.ads.datamanager.v1.EventParameterOrBuilder;
import com.google.ads.datamanager.v1.EventProto;
import com.google.ads.datamanager.v1.EventSource;
import com.google.ads.datamanager.v1.ExperimentalField;
import com.google.ads.datamanager.v1.ExperimentalFieldOrBuilder;
import com.google.ads.datamanager.v1.UserData;
import com.google.ads.datamanager.v1.UserDataOrBuilder;
import com.google.ads.datamanager.v1.UserProperties;
import com.google.ads.datamanager.v1.UserPropertiesOrBuilder;
import com.google.protobuf.AbstractMessage;
import com.google.protobuf.AbstractMessageLite;
import com.google.protobuf.AbstractParser;
import com.google.protobuf.ByteString;
import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import com.google.protobuf.Descriptors;
import com.google.protobuf.ExtensionRegistryLite;
import com.google.protobuf.GeneratedMessageV3;
import com.google.protobuf.Internal;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.LazyStringArrayList;
import com.google.protobuf.LazyStringList;
import com.google.protobuf.Message;
import com.google.protobuf.MessageLite;
import com.google.protobuf.Parser;
import com.google.protobuf.ProtocolStringList;
import com.google.protobuf.RepeatedFieldBuilderV3;
import com.google.protobuf.SingleFieldBuilderV3;
import com.google.protobuf.Timestamp;
import com.google.protobuf.TimestampOrBuilder;
import com.google.protobuf.UninitializedMessageException;
import com.google.protobuf.UnknownFieldSet;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public final class Event
extends GeneratedMessageV3
implements EventOrBuilder {
    private static final long serialVersionUID = 0L;
    private int bitField0_;
    public static final int DESTINATION_REFERENCES_FIELD_NUMBER = 1;
    private LazyStringArrayList destinationReferences_ = LazyStringArrayList.emptyList();
    public static final int TRANSACTION_ID_FIELD_NUMBER = 2;
    private volatile Object transactionId_ = "";
    public static final int EVENT_TIMESTAMP_FIELD_NUMBER = 3;
    private Timestamp eventTimestamp_;
    public static final int LAST_UPDATED_TIMESTAMP_FIELD_NUMBER = 4;
    private Timestamp lastUpdatedTimestamp_;
    public static final int USER_DATA_FIELD_NUMBER = 5;
    private UserData userData_;
    public static final int CONSENT_FIELD_NUMBER = 6;
    private Consent consent_;
    public static final int AD_IDENTIFIERS_FIELD_NUMBER = 7;
    private AdIdentifiers adIdentifiers_;
    public static final int CURRENCY_FIELD_NUMBER = 8;
    private volatile Object currency_ = "";
    public static final int CONVERSION_VALUE_FIELD_NUMBER = 9;
    private double conversionValue_ = 0.0;
    public static final int EVENT_SOURCE_FIELD_NUMBER = 10;
    private int eventSource_ = 0;
    public static final int EVENT_DEVICE_INFO_FIELD_NUMBER = 11;
    private DeviceInfo eventDeviceInfo_;
    public static final int CART_DATA_FIELD_NUMBER = 12;
    private CartData cartData_;
    public static final int CUSTOM_VARIABLES_FIELD_NUMBER = 13;
    private List<CustomVariable> customVariables_;
    public static final int EXPERIMENTAL_FIELDS_FIELD_NUMBER = 14;
    private List<ExperimentalField> experimentalFields_;
    public static final int USER_PROPERTIES_FIELD_NUMBER = 15;
    private UserProperties userProperties_;
    public static final int EVENT_NAME_FIELD_NUMBER = 16;
    private volatile Object eventName_ = "";
    public static final int CLIENT_ID_FIELD_NUMBER = 17;
    private volatile Object clientId_ = "";
    public static final int USER_ID_FIELD_NUMBER = 18;
    private volatile Object userId_ = "";
    public static final int ADDITIONAL_EVENT_PARAMETERS_FIELD_NUMBER = 19;
    private List<EventParameter> additionalEventParameters_;
    private byte memoizedIsInitialized = (byte)-1;
    private static final Event DEFAULT_INSTANCE = new Event();
    private static final Parser<Event> PARSER = new AbstractParser<Event>(){

        public Event parsePartialFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            Builder builder = Event.newBuilder();
            try {
                builder.mergeFrom(input, extensionRegistry);
            }
            catch (InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage((MessageLite)builder.buildPartial());
            }
            catch (UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException().setUnfinishedMessage((MessageLite)builder.buildPartial());
            }
            catch (IOException e) {
                throw new InvalidProtocolBufferException(e).setUnfinishedMessage((MessageLite)builder.buildPartial());
            }
            return builder.buildPartial();
        }
    };

    private Event(GeneratedMessageV3.Builder<?> builder) {
        super(builder);
    }

    private Event() {
        this.destinationReferences_ = LazyStringArrayList.emptyList();
        this.transactionId_ = "";
        this.currency_ = "";
        this.eventSource_ = 0;
        this.customVariables_ = Collections.emptyList();
        this.experimentalFields_ = Collections.emptyList();
        this.eventName_ = "";
        this.clientId_ = "";
        this.userId_ = "";
        this.additionalEventParameters_ = Collections.emptyList();
    }

    protected Object newInstance(GeneratedMessageV3.UnusedPrivateParameter unused) {
        return new Event();
    }

    public static final Descriptors.Descriptor getDescriptor() {
        return EventProto.internal_static_google_ads_datamanager_v1_Event_descriptor;
    }

    protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
        return EventProto.internal_static_google_ads_datamanager_v1_Event_fieldAccessorTable.ensureFieldAccessorsInitialized(Event.class, Builder.class);
    }

    public ProtocolStringList getDestinationReferencesList() {
        return this.destinationReferences_;
    }

    @Override
    public int getDestinationReferencesCount() {
        return this.destinationReferences_.size();
    }

    @Override
    public String getDestinationReferences(int index) {
        return this.destinationReferences_.get(index);
    }

    @Override
    public ByteString getDestinationReferencesBytes(int index) {
        return this.destinationReferences_.getByteString(index);
    }

    @Override
    public String getTransactionId() {
        Object ref = this.transactionId_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.transactionId_ = s;
        return s;
    }

    @Override
    public ByteString getTransactionIdBytes() {
        Object ref = this.transactionId_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)((String)ref));
            this.transactionId_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    @Override
    public boolean hasEventTimestamp() {
        return (this.bitField0_ & 1) != 0;
    }

    @Override
    public Timestamp getEventTimestamp() {
        return this.eventTimestamp_ == null ? Timestamp.getDefaultInstance() : this.eventTimestamp_;
    }

    @Override
    public TimestampOrBuilder getEventTimestampOrBuilder() {
        return this.eventTimestamp_ == null ? Timestamp.getDefaultInstance() : this.eventTimestamp_;
    }

    @Override
    public boolean hasLastUpdatedTimestamp() {
        return (this.bitField0_ & 2) != 0;
    }

    @Override
    public Timestamp getLastUpdatedTimestamp() {
        return this.lastUpdatedTimestamp_ == null ? Timestamp.getDefaultInstance() : this.lastUpdatedTimestamp_;
    }

    @Override
    public TimestampOrBuilder getLastUpdatedTimestampOrBuilder() {
        return this.lastUpdatedTimestamp_ == null ? Timestamp.getDefaultInstance() : this.lastUpdatedTimestamp_;
    }

    @Override
    public boolean hasUserData() {
        return (this.bitField0_ & 4) != 0;
    }

    @Override
    public UserData getUserData() {
        return this.userData_ == null ? UserData.getDefaultInstance() : this.userData_;
    }

    @Override
    public UserDataOrBuilder getUserDataOrBuilder() {
        return this.userData_ == null ? UserData.getDefaultInstance() : this.userData_;
    }

    @Override
    public boolean hasConsent() {
        return (this.bitField0_ & 8) != 0;
    }

    @Override
    public Consent getConsent() {
        return this.consent_ == null ? Consent.getDefaultInstance() : this.consent_;
    }

    @Override
    public ConsentOrBuilder getConsentOrBuilder() {
        return this.consent_ == null ? Consent.getDefaultInstance() : this.consent_;
    }

    @Override
    public boolean hasAdIdentifiers() {
        return (this.bitField0_ & 0x10) != 0;
    }

    @Override
    public AdIdentifiers getAdIdentifiers() {
        return this.adIdentifiers_ == null ? AdIdentifiers.getDefaultInstance() : this.adIdentifiers_;
    }

    @Override
    public AdIdentifiersOrBuilder getAdIdentifiersOrBuilder() {
        return this.adIdentifiers_ == null ? AdIdentifiers.getDefaultInstance() : this.adIdentifiers_;
    }

    @Override
    public String getCurrency() {
        Object ref = this.currency_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.currency_ = s;
        return s;
    }

    @Override
    public ByteString getCurrencyBytes() {
        Object ref = this.currency_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)((String)ref));
            this.currency_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    @Override
    public double getConversionValue() {
        return this.conversionValue_;
    }

    @Override
    public int getEventSourceValue() {
        return this.eventSource_;
    }

    @Override
    public EventSource getEventSource() {
        EventSource result = EventSource.forNumber(this.eventSource_);
        return result == null ? EventSource.UNRECOGNIZED : result;
    }

    @Override
    public boolean hasEventDeviceInfo() {
        return (this.bitField0_ & 0x20) != 0;
    }

    @Override
    public DeviceInfo getEventDeviceInfo() {
        return this.eventDeviceInfo_ == null ? DeviceInfo.getDefaultInstance() : this.eventDeviceInfo_;
    }

    @Override
    public DeviceInfoOrBuilder getEventDeviceInfoOrBuilder() {
        return this.eventDeviceInfo_ == null ? DeviceInfo.getDefaultInstance() : this.eventDeviceInfo_;
    }

    @Override
    public boolean hasCartData() {
        return (this.bitField0_ & 0x40) != 0;
    }

    @Override
    public CartData getCartData() {
        return this.cartData_ == null ? CartData.getDefaultInstance() : this.cartData_;
    }

    @Override
    public CartDataOrBuilder getCartDataOrBuilder() {
        return this.cartData_ == null ? CartData.getDefaultInstance() : this.cartData_;
    }

    @Override
    public List<CustomVariable> getCustomVariablesList() {
        return this.customVariables_;
    }

    @Override
    public List<? extends CustomVariableOrBuilder> getCustomVariablesOrBuilderList() {
        return this.customVariables_;
    }

    @Override
    public int getCustomVariablesCount() {
        return this.customVariables_.size();
    }

    @Override
    public CustomVariable getCustomVariables(int index) {
        return this.customVariables_.get(index);
    }

    @Override
    public CustomVariableOrBuilder getCustomVariablesOrBuilder(int index) {
        return this.customVariables_.get(index);
    }

    @Override
    public List<ExperimentalField> getExperimentalFieldsList() {
        return this.experimentalFields_;
    }

    @Override
    public List<? extends ExperimentalFieldOrBuilder> getExperimentalFieldsOrBuilderList() {
        return this.experimentalFields_;
    }

    @Override
    public int getExperimentalFieldsCount() {
        return this.experimentalFields_.size();
    }

    @Override
    public ExperimentalField getExperimentalFields(int index) {
        return this.experimentalFields_.get(index);
    }

    @Override
    public ExperimentalFieldOrBuilder getExperimentalFieldsOrBuilder(int index) {
        return this.experimentalFields_.get(index);
    }

    @Override
    public boolean hasUserProperties() {
        return (this.bitField0_ & 0x80) != 0;
    }

    @Override
    public UserProperties getUserProperties() {
        return this.userProperties_ == null ? UserProperties.getDefaultInstance() : this.userProperties_;
    }

    @Override
    public UserPropertiesOrBuilder getUserPropertiesOrBuilder() {
        return this.userProperties_ == null ? UserProperties.getDefaultInstance() : this.userProperties_;
    }

    @Override
    public String getEventName() {
        Object ref = this.eventName_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.eventName_ = s;
        return s;
    }

    @Override
    public ByteString getEventNameBytes() {
        Object ref = this.eventName_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)((String)ref));
            this.eventName_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    @Override
    public String getClientId() {
        Object ref = this.clientId_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.clientId_ = s;
        return s;
    }

    @Override
    public ByteString getClientIdBytes() {
        Object ref = this.clientId_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)((String)ref));
            this.clientId_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    @Override
    public String getUserId() {
        Object ref = this.userId_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.userId_ = s;
        return s;
    }

    @Override
    public ByteString getUserIdBytes() {
        Object ref = this.userId_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)((String)ref));
            this.userId_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    @Override
    public List<EventParameter> getAdditionalEventParametersList() {
        return this.additionalEventParameters_;
    }

    @Override
    public List<? extends EventParameterOrBuilder> getAdditionalEventParametersOrBuilderList() {
        return this.additionalEventParameters_;
    }

    @Override
    public int getAdditionalEventParametersCount() {
        return this.additionalEventParameters_.size();
    }

    @Override
    public EventParameter getAdditionalEventParameters(int index) {
        return this.additionalEventParameters_.get(index);
    }

    @Override
    public EventParameterOrBuilder getAdditionalEventParametersOrBuilder(int index) {
        return this.additionalEventParameters_.get(index);
    }

    public final boolean isInitialized() {
        byte isInitialized = this.memoizedIsInitialized;
        if (isInitialized == 1) {
            return true;
        }
        if (isInitialized == 0) {
            return false;
        }
        this.memoizedIsInitialized = 1;
        return true;
    }

    public void writeTo(CodedOutputStream output) throws IOException {
        int i;
        for (i = 0; i < this.destinationReferences_.size(); ++i) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)1, (Object)this.destinationReferences_.getRaw(i));
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.transactionId_)) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)2, (Object)this.transactionId_);
        }
        if ((this.bitField0_ & 1) != 0) {
            output.writeMessage(3, (MessageLite)this.getEventTimestamp());
        }
        if ((this.bitField0_ & 2) != 0) {
            output.writeMessage(4, (MessageLite)this.getLastUpdatedTimestamp());
        }
        if ((this.bitField0_ & 4) != 0) {
            output.writeMessage(5, (MessageLite)this.getUserData());
        }
        if ((this.bitField0_ & 8) != 0) {
            output.writeMessage(6, (MessageLite)this.getConsent());
        }
        if ((this.bitField0_ & 0x10) != 0) {
            output.writeMessage(7, (MessageLite)this.getAdIdentifiers());
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.currency_)) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)8, (Object)this.currency_);
        }
        if (Double.doubleToRawLongBits(this.conversionValue_) != 0L) {
            output.writeDouble(9, this.conversionValue_);
        }
        if (this.eventSource_ != EventSource.EVENT_SOURCE_UNSPECIFIED.getNumber()) {
            output.writeEnum(10, this.eventSource_);
        }
        if ((this.bitField0_ & 0x20) != 0) {
            output.writeMessage(11, (MessageLite)this.getEventDeviceInfo());
        }
        if ((this.bitField0_ & 0x40) != 0) {
            output.writeMessage(12, (MessageLite)this.getCartData());
        }
        for (i = 0; i < this.customVariables_.size(); ++i) {
            output.writeMessage(13, (MessageLite)this.customVariables_.get(i));
        }
        for (i = 0; i < this.experimentalFields_.size(); ++i) {
            output.writeMessage(14, (MessageLite)this.experimentalFields_.get(i));
        }
        if ((this.bitField0_ & 0x80) != 0) {
            output.writeMessage(15, (MessageLite)this.getUserProperties());
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.eventName_)) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)16, (Object)this.eventName_);
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.clientId_)) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)17, (Object)this.clientId_);
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.userId_)) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)18, (Object)this.userId_);
        }
        for (i = 0; i < this.additionalEventParameters_.size(); ++i) {
            output.writeMessage(19, (MessageLite)this.additionalEventParameters_.get(i));
        }
        this.getUnknownFields().writeTo(output);
    }

    public int getSerializedSize() {
        int i;
        int size = this.memoizedSize;
        if (size != -1) {
            return size;
        }
        size = 0;
        int dataSize = 0;
        for (int i2 = 0; i2 < this.destinationReferences_.size(); ++i2) {
            dataSize += Event.computeStringSizeNoTag((Object)this.destinationReferences_.getRaw(i2));
        }
        size += dataSize;
        size += 1 * this.getDestinationReferencesList().size();
        if (!GeneratedMessageV3.isStringEmpty((Object)this.transactionId_)) {
            size += GeneratedMessageV3.computeStringSize((int)2, (Object)this.transactionId_);
        }
        if ((this.bitField0_ & 1) != 0) {
            size += CodedOutputStream.computeMessageSize((int)3, (MessageLite)this.getEventTimestamp());
        }
        if ((this.bitField0_ & 2) != 0) {
            size += CodedOutputStream.computeMessageSize((int)4, (MessageLite)this.getLastUpdatedTimestamp());
        }
        if ((this.bitField0_ & 4) != 0) {
            size += CodedOutputStream.computeMessageSize((int)5, (MessageLite)this.getUserData());
        }
        if ((this.bitField0_ & 8) != 0) {
            size += CodedOutputStream.computeMessageSize((int)6, (MessageLite)this.getConsent());
        }
        if ((this.bitField0_ & 0x10) != 0) {
            size += CodedOutputStream.computeMessageSize((int)7, (MessageLite)this.getAdIdentifiers());
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.currency_)) {
            size += GeneratedMessageV3.computeStringSize((int)8, (Object)this.currency_);
        }
        if (Double.doubleToRawLongBits(this.conversionValue_) != 0L) {
            size += CodedOutputStream.computeDoubleSize((int)9, (double)this.conversionValue_);
        }
        if (this.eventSource_ != EventSource.EVENT_SOURCE_UNSPECIFIED.getNumber()) {
            size += CodedOutputStream.computeEnumSize((int)10, (int)this.eventSource_);
        }
        if ((this.bitField0_ & 0x20) != 0) {
            size += CodedOutputStream.computeMessageSize((int)11, (MessageLite)this.getEventDeviceInfo());
        }
        if ((this.bitField0_ & 0x40) != 0) {
            size += CodedOutputStream.computeMessageSize((int)12, (MessageLite)this.getCartData());
        }
        for (i = 0; i < this.customVariables_.size(); ++i) {
            size += CodedOutputStream.computeMessageSize((int)13, (MessageLite)((MessageLite)this.customVariables_.get(i)));
        }
        for (i = 0; i < this.experimentalFields_.size(); ++i) {
            size += CodedOutputStream.computeMessageSize((int)14, (MessageLite)((MessageLite)this.experimentalFields_.get(i)));
        }
        if ((this.bitField0_ & 0x80) != 0) {
            size += CodedOutputStream.computeMessageSize((int)15, (MessageLite)this.getUserProperties());
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.eventName_)) {
            size += GeneratedMessageV3.computeStringSize((int)16, (Object)this.eventName_);
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.clientId_)) {
            size += GeneratedMessageV3.computeStringSize((int)17, (Object)this.clientId_);
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.userId_)) {
            size += GeneratedMessageV3.computeStringSize((int)18, (Object)this.userId_);
        }
        for (i = 0; i < this.additionalEventParameters_.size(); ++i) {
            size += CodedOutputStream.computeMessageSize((int)19, (MessageLite)((MessageLite)this.additionalEventParameters_.get(i)));
        }
        this.memoizedSize = size += this.getUnknownFields().getSerializedSize();
        return size;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Event)) {
            return super.equals(obj);
        }
        Event other = (Event)obj;
        if (!this.getDestinationReferencesList().equals(other.getDestinationReferencesList())) {
            return false;
        }
        if (!this.getTransactionId().equals(other.getTransactionId())) {
            return false;
        }
        if (this.hasEventTimestamp() != other.hasEventTimestamp()) {
            return false;
        }
        if (this.hasEventTimestamp() && !this.getEventTimestamp().equals((Object)other.getEventTimestamp())) {
            return false;
        }
        if (this.hasLastUpdatedTimestamp() != other.hasLastUpdatedTimestamp()) {
            return false;
        }
        if (this.hasLastUpdatedTimestamp() && !this.getLastUpdatedTimestamp().equals((Object)other.getLastUpdatedTimestamp())) {
            return false;
        }
        if (this.hasUserData() != other.hasUserData()) {
            return false;
        }
        if (this.hasUserData() && !this.getUserData().equals(other.getUserData())) {
            return false;
        }
        if (this.hasConsent() != other.hasConsent()) {
            return false;
        }
        if (this.hasConsent() && !this.getConsent().equals(other.getConsent())) {
            return false;
        }
        if (this.hasAdIdentifiers() != other.hasAdIdentifiers()) {
            return false;
        }
        if (this.hasAdIdentifiers() && !this.getAdIdentifiers().equals(other.getAdIdentifiers())) {
            return false;
        }
        if (!this.getCurrency().equals(other.getCurrency())) {
            return false;
        }
        if (Double.doubleToLongBits(this.getConversionValue()) != Double.doubleToLongBits(other.getConversionValue())) {
            return false;
        }
        if (this.eventSource_ != other.eventSource_) {
            return false;
        }
        if (this.hasEventDeviceInfo() != other.hasEventDeviceInfo()) {
            return false;
        }
        if (this.hasEventDeviceInfo() && !this.getEventDeviceInfo().equals(other.getEventDeviceInfo())) {
            return false;
        }
        if (this.hasCartData() != other.hasCartData()) {
            return false;
        }
        if (this.hasCartData() && !this.getCartData().equals(other.getCartData())) {
            return false;
        }
        if (!this.getCustomVariablesList().equals(other.getCustomVariablesList())) {
            return false;
        }
        if (!this.getExperimentalFieldsList().equals(other.getExperimentalFieldsList())) {
            return false;
        }
        if (this.hasUserProperties() != other.hasUserProperties()) {
            return false;
        }
        if (this.hasUserProperties() && !this.getUserProperties().equals(other.getUserProperties())) {
            return false;
        }
        if (!this.getEventName().equals(other.getEventName())) {
            return false;
        }
        if (!this.getClientId().equals(other.getClientId())) {
            return false;
        }
        if (!this.getUserId().equals(other.getUserId())) {
            return false;
        }
        if (!this.getAdditionalEventParametersList().equals(other.getAdditionalEventParametersList())) {
            return false;
        }
        return this.getUnknownFields().equals((Object)other.getUnknownFields());
    }

    public int hashCode() {
        if (this.memoizedHashCode != 0) {
            return this.memoizedHashCode;
        }
        int hash = 41;
        hash = 19 * hash + Event.getDescriptor().hashCode();
        if (this.getDestinationReferencesCount() > 0) {
            hash = 37 * hash + 1;
            hash = 53 * hash + this.getDestinationReferencesList().hashCode();
        }
        hash = 37 * hash + 2;
        hash = 53 * hash + this.getTransactionId().hashCode();
        if (this.hasEventTimestamp()) {
            hash = 37 * hash + 3;
            hash = 53 * hash + this.getEventTimestamp().hashCode();
        }
        if (this.hasLastUpdatedTimestamp()) {
            hash = 37 * hash + 4;
            hash = 53 * hash + this.getLastUpdatedTimestamp().hashCode();
        }
        if (this.hasUserData()) {
            hash = 37 * hash + 5;
            hash = 53 * hash + this.getUserData().hashCode();
        }
        if (this.hasConsent()) {
            hash = 37 * hash + 6;
            hash = 53 * hash + this.getConsent().hashCode();
        }
        if (this.hasAdIdentifiers()) {
            hash = 37 * hash + 7;
            hash = 53 * hash + this.getAdIdentifiers().hashCode();
        }
        hash = 37 * hash + 8;
        hash = 53 * hash + this.getCurrency().hashCode();
        hash = 37 * hash + 9;
        hash = 53 * hash + Internal.hashLong((long)Double.doubleToLongBits(this.getConversionValue()));
        hash = 37 * hash + 10;
        hash = 53 * hash + this.eventSource_;
        if (this.hasEventDeviceInfo()) {
            hash = 37 * hash + 11;
            hash = 53 * hash + this.getEventDeviceInfo().hashCode();
        }
        if (this.hasCartData()) {
            hash = 37 * hash + 12;
            hash = 53 * hash + this.getCartData().hashCode();
        }
        if (this.getCustomVariablesCount() > 0) {
            hash = 37 * hash + 13;
            hash = 53 * hash + this.getCustomVariablesList().hashCode();
        }
        if (this.getExperimentalFieldsCount() > 0) {
            hash = 37 * hash + 14;
            hash = 53 * hash + this.getExperimentalFieldsList().hashCode();
        }
        if (this.hasUserProperties()) {
            hash = 37 * hash + 15;
            hash = 53 * hash + this.getUserProperties().hashCode();
        }
        hash = 37 * hash + 16;
        hash = 53 * hash + this.getEventName().hashCode();
        hash = 37 * hash + 17;
        hash = 53 * hash + this.getClientId().hashCode();
        hash = 37 * hash + 18;
        hash = 53 * hash + this.getUserId().hashCode();
        if (this.getAdditionalEventParametersCount() > 0) {
            hash = 37 * hash + 19;
            hash = 53 * hash + this.getAdditionalEventParametersList().hashCode();
        }
        this.memoizedHashCode = hash = 29 * hash + this.getUnknownFields().hashCode();
        return hash;
    }

    public static Event parseFrom(ByteBuffer data) throws InvalidProtocolBufferException {
        return (Event)PARSER.parseFrom(data);
    }

    public static Event parseFrom(ByteBuffer data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (Event)PARSER.parseFrom(data, extensionRegistry);
    }

    public static Event parseFrom(ByteString data) throws InvalidProtocolBufferException {
        return (Event)PARSER.parseFrom(data);
    }

    public static Event parseFrom(ByteString data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (Event)PARSER.parseFrom(data, extensionRegistry);
    }

    public static Event parseFrom(byte[] data) throws InvalidProtocolBufferException {
        return (Event)PARSER.parseFrom(data);
    }

    public static Event parseFrom(byte[] data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (Event)PARSER.parseFrom(data, extensionRegistry);
    }

    public static Event parseFrom(InputStream input) throws IOException {
        return (Event)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input);
    }

    public static Event parseFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (Event)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public static Event parseDelimitedFrom(InputStream input) throws IOException {
        return (Event)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input);
    }

    public static Event parseDelimitedFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (Event)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public static Event parseFrom(CodedInputStream input) throws IOException {
        return (Event)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input);
    }

    public static Event parseFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (Event)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public Builder newBuilderForType() {
        return Event.newBuilder();
    }

    public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(Event prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    protected Builder newBuilderForType(GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
    }

    public static Event getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public static Parser<Event> parser() {
        return PARSER;
    }

    public Parser<Event> getParserForType() {
        return PARSER;
    }

    public Event getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
    }

    public static final class Builder
    extends GeneratedMessageV3.Builder<Builder>
    implements EventOrBuilder {
        private int bitField0_;
        private LazyStringArrayList destinationReferences_ = LazyStringArrayList.emptyList();
        private Object transactionId_ = "";
        private Timestamp eventTimestamp_;
        private SingleFieldBuilderV3<Timestamp, Timestamp.Builder, TimestampOrBuilder> eventTimestampBuilder_;
        private Timestamp lastUpdatedTimestamp_;
        private SingleFieldBuilderV3<Timestamp, Timestamp.Builder, TimestampOrBuilder> lastUpdatedTimestampBuilder_;
        private UserData userData_;
        private SingleFieldBuilderV3<UserData, UserData.Builder, UserDataOrBuilder> userDataBuilder_;
        private Consent consent_;
        private SingleFieldBuilderV3<Consent, Consent.Builder, ConsentOrBuilder> consentBuilder_;
        private AdIdentifiers adIdentifiers_;
        private SingleFieldBuilderV3<AdIdentifiers, AdIdentifiers.Builder, AdIdentifiersOrBuilder> adIdentifiersBuilder_;
        private Object currency_ = "";
        private double conversionValue_;
        private int eventSource_ = 0;
        private DeviceInfo eventDeviceInfo_;
        private SingleFieldBuilderV3<DeviceInfo, DeviceInfo.Builder, DeviceInfoOrBuilder> eventDeviceInfoBuilder_;
        private CartData cartData_;
        private SingleFieldBuilderV3<CartData, CartData.Builder, CartDataOrBuilder> cartDataBuilder_;
        private List<CustomVariable> customVariables_ = Collections.emptyList();
        private RepeatedFieldBuilderV3<CustomVariable, CustomVariable.Builder, CustomVariableOrBuilder> customVariablesBuilder_;
        private List<ExperimentalField> experimentalFields_ = Collections.emptyList();
        private RepeatedFieldBuilderV3<ExperimentalField, ExperimentalField.Builder, ExperimentalFieldOrBuilder> experimentalFieldsBuilder_;
        private UserProperties userProperties_;
        private SingleFieldBuilderV3<UserProperties, UserProperties.Builder, UserPropertiesOrBuilder> userPropertiesBuilder_;
        private Object eventName_ = "";
        private Object clientId_ = "";
        private Object userId_ = "";
        private List<EventParameter> additionalEventParameters_ = Collections.emptyList();
        private RepeatedFieldBuilderV3<EventParameter, EventParameter.Builder, EventParameterOrBuilder> additionalEventParametersBuilder_;

        public static final Descriptors.Descriptor getDescriptor() {
            return EventProto.internal_static_google_ads_datamanager_v1_Event_descriptor;
        }

        protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
            return EventProto.internal_static_google_ads_datamanager_v1_Event_fieldAccessorTable.ensureFieldAccessorsInitialized(Event.class, Builder.class);
        }

        private Builder() {
            this.maybeForceBuilderInitialization();
        }

        private Builder(GeneratedMessageV3.BuilderParent parent) {
            super(parent);
            this.maybeForceBuilderInitialization();
        }

        private void maybeForceBuilderInitialization() {
            if (alwaysUseFieldBuilders) {
                this.getEventTimestampFieldBuilder();
                this.getLastUpdatedTimestampFieldBuilder();
                this.getUserDataFieldBuilder();
                this.getConsentFieldBuilder();
                this.getAdIdentifiersFieldBuilder();
                this.getEventDeviceInfoFieldBuilder();
                this.getCartDataFieldBuilder();
                this.getCustomVariablesFieldBuilder();
                this.getExperimentalFieldsFieldBuilder();
                this.getUserPropertiesFieldBuilder();
                this.getAdditionalEventParametersFieldBuilder();
            }
        }

        public Builder clear() {
            super.clear();
            this.bitField0_ = 0;
            this.destinationReferences_ = LazyStringArrayList.emptyList();
            this.transactionId_ = "";
            this.eventTimestamp_ = null;
            if (this.eventTimestampBuilder_ != null) {
                this.eventTimestampBuilder_.dispose();
                this.eventTimestampBuilder_ = null;
            }
            this.lastUpdatedTimestamp_ = null;
            if (this.lastUpdatedTimestampBuilder_ != null) {
                this.lastUpdatedTimestampBuilder_.dispose();
                this.lastUpdatedTimestampBuilder_ = null;
            }
            this.userData_ = null;
            if (this.userDataBuilder_ != null) {
                this.userDataBuilder_.dispose();
                this.userDataBuilder_ = null;
            }
            this.consent_ = null;
            if (this.consentBuilder_ != null) {
                this.consentBuilder_.dispose();
                this.consentBuilder_ = null;
            }
            this.adIdentifiers_ = null;
            if (this.adIdentifiersBuilder_ != null) {
                this.adIdentifiersBuilder_.dispose();
                this.adIdentifiersBuilder_ = null;
            }
            this.currency_ = "";
            this.conversionValue_ = 0.0;
            this.eventSource_ = 0;
            this.eventDeviceInfo_ = null;
            if (this.eventDeviceInfoBuilder_ != null) {
                this.eventDeviceInfoBuilder_.dispose();
                this.eventDeviceInfoBuilder_ = null;
            }
            this.cartData_ = null;
            if (this.cartDataBuilder_ != null) {
                this.cartDataBuilder_.dispose();
                this.cartDataBuilder_ = null;
            }
            if (this.customVariablesBuilder_ == null) {
                this.customVariables_ = Collections.emptyList();
            } else {
                this.customVariables_ = null;
                this.customVariablesBuilder_.clear();
            }
            this.bitField0_ &= 0xFFFFEFFF;
            if (this.experimentalFieldsBuilder_ == null) {
                this.experimentalFields_ = Collections.emptyList();
            } else {
                this.experimentalFields_ = null;
                this.experimentalFieldsBuilder_.clear();
            }
            this.bitField0_ &= 0xFFFFDFFF;
            this.userProperties_ = null;
            if (this.userPropertiesBuilder_ != null) {
                this.userPropertiesBuilder_.dispose();
                this.userPropertiesBuilder_ = null;
            }
            this.eventName_ = "";
            this.clientId_ = "";
            this.userId_ = "";
            if (this.additionalEventParametersBuilder_ == null) {
                this.additionalEventParameters_ = Collections.emptyList();
            } else {
                this.additionalEventParameters_ = null;
                this.additionalEventParametersBuilder_.clear();
            }
            this.bitField0_ &= 0xFFFBFFFF;
            return this;
        }

        public Descriptors.Descriptor getDescriptorForType() {
            return EventProto.internal_static_google_ads_datamanager_v1_Event_descriptor;
        }

        public Event getDefaultInstanceForType() {
            return Event.getDefaultInstance();
        }

        public Event build() {
            Event result = this.buildPartial();
            if (!result.isInitialized()) {
                throw Builder.newUninitializedMessageException((Message)result);
            }
            return result;
        }

        public Event buildPartial() {
            Event result = new Event(this);
            this.buildPartialRepeatedFields(result);
            if (this.bitField0_ != 0) {
                this.buildPartial0(result);
            }
            this.onBuilt();
            return result;
        }

        private void buildPartialRepeatedFields(Event result) {
            if (this.customVariablesBuilder_ == null) {
                if ((this.bitField0_ & 0x1000) != 0) {
                    this.customVariables_ = Collections.unmodifiableList(this.customVariables_);
                    this.bitField0_ &= 0xFFFFEFFF;
                }
                result.customVariables_ = this.customVariables_;
            } else {
                result.customVariables_ = this.customVariablesBuilder_.build();
            }
            if (this.experimentalFieldsBuilder_ == null) {
                if ((this.bitField0_ & 0x2000) != 0) {
                    this.experimentalFields_ = Collections.unmodifiableList(this.experimentalFields_);
                    this.bitField0_ &= 0xFFFFDFFF;
                }
                result.experimentalFields_ = this.experimentalFields_;
            } else {
                result.experimentalFields_ = this.experimentalFieldsBuilder_.build();
            }
            if (this.additionalEventParametersBuilder_ == null) {
                if ((this.bitField0_ & 0x40000) != 0) {
                    this.additionalEventParameters_ = Collections.unmodifiableList(this.additionalEventParameters_);
                    this.bitField0_ &= 0xFFFBFFFF;
                }
                result.additionalEventParameters_ = this.additionalEventParameters_;
            } else {
                result.additionalEventParameters_ = this.additionalEventParametersBuilder_.build();
            }
        }

        private void buildPartial0(Event result) {
            int from_bitField0_ = this.bitField0_;
            if ((from_bitField0_ & 1) != 0) {
                this.destinationReferences_.makeImmutable();
                result.destinationReferences_ = this.destinationReferences_;
            }
            if ((from_bitField0_ & 2) != 0) {
                result.transactionId_ = this.transactionId_;
            }
            int to_bitField0_ = 0;
            if ((from_bitField0_ & 4) != 0) {
                result.eventTimestamp_ = this.eventTimestampBuilder_ == null ? this.eventTimestamp_ : (Timestamp)this.eventTimestampBuilder_.build();
                to_bitField0_ |= 1;
            }
            if ((from_bitField0_ & 8) != 0) {
                result.lastUpdatedTimestamp_ = this.lastUpdatedTimestampBuilder_ == null ? this.lastUpdatedTimestamp_ : (Timestamp)this.lastUpdatedTimestampBuilder_.build();
                to_bitField0_ |= 2;
            }
            if ((from_bitField0_ & 0x10) != 0) {
                result.userData_ = this.userDataBuilder_ == null ? this.userData_ : (UserData)this.userDataBuilder_.build();
                to_bitField0_ |= 4;
            }
            if ((from_bitField0_ & 0x20) != 0) {
                result.consent_ = this.consentBuilder_ == null ? this.consent_ : (Consent)this.consentBuilder_.build();
                to_bitField0_ |= 8;
            }
            if ((from_bitField0_ & 0x40) != 0) {
                result.adIdentifiers_ = this.adIdentifiersBuilder_ == null ? this.adIdentifiers_ : (AdIdentifiers)this.adIdentifiersBuilder_.build();
                to_bitField0_ |= 0x10;
            }
            if ((from_bitField0_ & 0x80) != 0) {
                result.currency_ = this.currency_;
            }
            if ((from_bitField0_ & 0x100) != 0) {
                result.conversionValue_ = this.conversionValue_;
            }
            if ((from_bitField0_ & 0x200) != 0) {
                result.eventSource_ = this.eventSource_;
            }
            if ((from_bitField0_ & 0x400) != 0) {
                result.eventDeviceInfo_ = this.eventDeviceInfoBuilder_ == null ? this.eventDeviceInfo_ : (DeviceInfo)this.eventDeviceInfoBuilder_.build();
                to_bitField0_ |= 0x20;
            }
            if ((from_bitField0_ & 0x800) != 0) {
                result.cartData_ = this.cartDataBuilder_ == null ? this.cartData_ : (CartData)this.cartDataBuilder_.build();
                to_bitField0_ |= 0x40;
            }
            if ((from_bitField0_ & 0x4000) != 0) {
                result.userProperties_ = this.userPropertiesBuilder_ == null ? this.userProperties_ : (UserProperties)this.userPropertiesBuilder_.build();
                to_bitField0_ |= 0x80;
            }
            if ((from_bitField0_ & 0x8000) != 0) {
                result.eventName_ = this.eventName_;
            }
            if ((from_bitField0_ & 0x10000) != 0) {
                result.clientId_ = this.clientId_;
            }
            if ((from_bitField0_ & 0x20000) != 0) {
                result.userId_ = this.userId_;
            }
            Event event = result;
            event.bitField0_ = event.bitField0_ | to_bitField0_;
        }

        public Builder clone() {
            return (Builder)super.clone();
        }

        public Builder setField(Descriptors.FieldDescriptor field, Object value) {
            return (Builder)super.setField(field, value);
        }

        public Builder clearField(Descriptors.FieldDescriptor field) {
            return (Builder)super.clearField(field);
        }

        public Builder clearOneof(Descriptors.OneofDescriptor oneof) {
            return (Builder)super.clearOneof(oneof);
        }

        public Builder setRepeatedField(Descriptors.FieldDescriptor field, int index, Object value) {
            return (Builder)super.setRepeatedField(field, index, value);
        }

        public Builder addRepeatedField(Descriptors.FieldDescriptor field, Object value) {
            return (Builder)super.addRepeatedField(field, value);
        }

        public Builder mergeFrom(Message other) {
            if (other instanceof Event) {
                return this.mergeFrom((Event)other);
            }
            super.mergeFrom(other);
            return this;
        }

        public Builder mergeFrom(Event other) {
            if (other == Event.getDefaultInstance()) {
                return this;
            }
            if (!other.destinationReferences_.isEmpty()) {
                if (this.destinationReferences_.isEmpty()) {
                    this.destinationReferences_ = other.destinationReferences_;
                    this.bitField0_ |= 1;
                } else {
                    this.ensureDestinationReferencesIsMutable();
                    this.destinationReferences_.addAll((Collection)other.destinationReferences_);
                }
                this.onChanged();
            }
            if (!other.getTransactionId().isEmpty()) {
                this.transactionId_ = other.transactionId_;
                this.bitField0_ |= 2;
                this.onChanged();
            }
            if (other.hasEventTimestamp()) {
                this.mergeEventTimestamp(other.getEventTimestamp());
            }
            if (other.hasLastUpdatedTimestamp()) {
                this.mergeLastUpdatedTimestamp(other.getLastUpdatedTimestamp());
            }
            if (other.hasUserData()) {
                this.mergeUserData(other.getUserData());
            }
            if (other.hasConsent()) {
                this.mergeConsent(other.getConsent());
            }
            if (other.hasAdIdentifiers()) {
                this.mergeAdIdentifiers(other.getAdIdentifiers());
            }
            if (!other.getCurrency().isEmpty()) {
                this.currency_ = other.currency_;
                this.bitField0_ |= 0x80;
                this.onChanged();
            }
            if (other.getConversionValue() != 0.0) {
                this.setConversionValue(other.getConversionValue());
            }
            if (other.eventSource_ != 0) {
                this.setEventSourceValue(other.getEventSourceValue());
            }
            if (other.hasEventDeviceInfo()) {
                this.mergeEventDeviceInfo(other.getEventDeviceInfo());
            }
            if (other.hasCartData()) {
                this.mergeCartData(other.getCartData());
            }
            if (this.customVariablesBuilder_ == null) {
                if (!other.customVariables_.isEmpty()) {
                    if (this.customVariables_.isEmpty()) {
                        this.customVariables_ = other.customVariables_;
                        this.bitField0_ &= 0xFFFFEFFF;
                    } else {
                        this.ensureCustomVariablesIsMutable();
                        this.customVariables_.addAll(other.customVariables_);
                    }
                    this.onChanged();
                }
            } else if (!other.customVariables_.isEmpty()) {
                if (this.customVariablesBuilder_.isEmpty()) {
                    this.customVariablesBuilder_.dispose();
                    this.customVariablesBuilder_ = null;
                    this.customVariables_ = other.customVariables_;
                    this.bitField0_ &= 0xFFFFEFFF;
                    this.customVariablesBuilder_ = alwaysUseFieldBuilders ? this.getCustomVariablesFieldBuilder() : null;
                } else {
                    this.customVariablesBuilder_.addAllMessages((Iterable)other.customVariables_);
                }
            }
            if (this.experimentalFieldsBuilder_ == null) {
                if (!other.experimentalFields_.isEmpty()) {
                    if (this.experimentalFields_.isEmpty()) {
                        this.experimentalFields_ = other.experimentalFields_;
                        this.bitField0_ &= 0xFFFFDFFF;
                    } else {
                        this.ensureExperimentalFieldsIsMutable();
                        this.experimentalFields_.addAll(other.experimentalFields_);
                    }
                    this.onChanged();
                }
            } else if (!other.experimentalFields_.isEmpty()) {
                if (this.experimentalFieldsBuilder_.isEmpty()) {
                    this.experimentalFieldsBuilder_.dispose();
                    this.experimentalFieldsBuilder_ = null;
                    this.experimentalFields_ = other.experimentalFields_;
                    this.bitField0_ &= 0xFFFFDFFF;
                    this.experimentalFieldsBuilder_ = alwaysUseFieldBuilders ? this.getExperimentalFieldsFieldBuilder() : null;
                } else {
                    this.experimentalFieldsBuilder_.addAllMessages((Iterable)other.experimentalFields_);
                }
            }
            if (other.hasUserProperties()) {
                this.mergeUserProperties(other.getUserProperties());
            }
            if (!other.getEventName().isEmpty()) {
                this.eventName_ = other.eventName_;
                this.bitField0_ |= 0x8000;
                this.onChanged();
            }
            if (!other.getClientId().isEmpty()) {
                this.clientId_ = other.clientId_;
                this.bitField0_ |= 0x10000;
                this.onChanged();
            }
            if (!other.getUserId().isEmpty()) {
                this.userId_ = other.userId_;
                this.bitField0_ |= 0x20000;
                this.onChanged();
            }
            if (this.additionalEventParametersBuilder_ == null) {
                if (!other.additionalEventParameters_.isEmpty()) {
                    if (this.additionalEventParameters_.isEmpty()) {
                        this.additionalEventParameters_ = other.additionalEventParameters_;
                        this.bitField0_ &= 0xFFFBFFFF;
                    } else {
                        this.ensureAdditionalEventParametersIsMutable();
                        this.additionalEventParameters_.addAll(other.additionalEventParameters_);
                    }
                    this.onChanged();
                }
            } else if (!other.additionalEventParameters_.isEmpty()) {
                if (this.additionalEventParametersBuilder_.isEmpty()) {
                    this.additionalEventParametersBuilder_.dispose();
                    this.additionalEventParametersBuilder_ = null;
                    this.additionalEventParameters_ = other.additionalEventParameters_;
                    this.bitField0_ &= 0xFFFBFFFF;
                    this.additionalEventParametersBuilder_ = alwaysUseFieldBuilders ? this.getAdditionalEventParametersFieldBuilder() : null;
                } else {
                    this.additionalEventParametersBuilder_.addAllMessages((Iterable)other.additionalEventParameters_);
                }
            }
            this.mergeUnknownFields(other.getUnknownFields());
            this.onChanged();
            return this;
        }

        public final boolean isInitialized() {
            return true;
        }

        public Builder mergeFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            if (extensionRegistry == null) {
                throw new NullPointerException();
            }
            try {
                boolean done = false;
                block27: while (!done) {
                    int tag = input.readTag();
                    switch (tag) {
                        case 0: {
                            done = true;
                            continue block27;
                        }
                        case 10: {
                            String s = input.readStringRequireUtf8();
                            this.ensureDestinationReferencesIsMutable();
                            this.destinationReferences_.add((Object)s);
                            continue block27;
                        }
                        case 18: {
                            this.transactionId_ = input.readStringRequireUtf8();
                            this.bitField0_ |= 2;
                            continue block27;
                        }
                        case 26: {
                            input.readMessage((MessageLite.Builder)this.getEventTimestampFieldBuilder().getBuilder(), extensionRegistry);
                            this.bitField0_ |= 4;
                            continue block27;
                        }
                        case 34: {
                            input.readMessage((MessageLite.Builder)this.getLastUpdatedTimestampFieldBuilder().getBuilder(), extensionRegistry);
                            this.bitField0_ |= 8;
                            continue block27;
                        }
                        case 42: {
                            input.readMessage((MessageLite.Builder)this.getUserDataFieldBuilder().getBuilder(), extensionRegistry);
                            this.bitField0_ |= 0x10;
                            continue block27;
                        }
                        case 50: {
                            input.readMessage((MessageLite.Builder)this.getConsentFieldBuilder().getBuilder(), extensionRegistry);
                            this.bitField0_ |= 0x20;
                            continue block27;
                        }
                        case 58: {
                            input.readMessage((MessageLite.Builder)this.getAdIdentifiersFieldBuilder().getBuilder(), extensionRegistry);
                            this.bitField0_ |= 0x40;
                            continue block27;
                        }
                        case 66: {
                            this.currency_ = input.readStringRequireUtf8();
                            this.bitField0_ |= 0x80;
                            continue block27;
                        }
                        case 73: {
                            this.conversionValue_ = input.readDouble();
                            this.bitField0_ |= 0x100;
                            continue block27;
                        }
                        case 80: {
                            this.eventSource_ = input.readEnum();
                            this.bitField0_ |= 0x200;
                            continue block27;
                        }
                        case 90: {
                            input.readMessage((MessageLite.Builder)this.getEventDeviceInfoFieldBuilder().getBuilder(), extensionRegistry);
                            this.bitField0_ |= 0x400;
                            continue block27;
                        }
                        case 98: {
                            input.readMessage((MessageLite.Builder)this.getCartDataFieldBuilder().getBuilder(), extensionRegistry);
                            this.bitField0_ |= 0x800;
                            continue block27;
                        }
                        case 106: {
                            GeneratedMessageV3 m = (CustomVariable)input.readMessage(CustomVariable.parser(), extensionRegistry);
                            if (this.customVariablesBuilder_ == null) {
                                this.ensureCustomVariablesIsMutable();
                                this.customVariables_.add((CustomVariable)m);
                                continue block27;
                            }
                            this.customVariablesBuilder_.addMessage((AbstractMessage)m);
                            continue block27;
                        }
                        case 114: {
                            GeneratedMessageV3 m = (ExperimentalField)input.readMessage(ExperimentalField.parser(), extensionRegistry);
                            if (this.experimentalFieldsBuilder_ == null) {
                                this.ensureExperimentalFieldsIsMutable();
                                this.experimentalFields_.add((ExperimentalField)m);
                                continue block27;
                            }
                            this.experimentalFieldsBuilder_.addMessage((AbstractMessage)m);
                            continue block27;
                        }
                        case 122: {
                            input.readMessage((MessageLite.Builder)this.getUserPropertiesFieldBuilder().getBuilder(), extensionRegistry);
                            this.bitField0_ |= 0x4000;
                            continue block27;
                        }
                        case 130: {
                            this.eventName_ = input.readStringRequireUtf8();
                            this.bitField0_ |= 0x8000;
                            continue block27;
                        }
                        case 138: {
                            this.clientId_ = input.readStringRequireUtf8();
                            this.bitField0_ |= 0x10000;
                            continue block27;
                        }
                        case 146: {
                            this.userId_ = input.readStringRequireUtf8();
                            this.bitField0_ |= 0x20000;
                            continue block27;
                        }
                        case 154: {
                            GeneratedMessageV3 m = (EventParameter)input.readMessage(EventParameter.parser(), extensionRegistry);
                            if (this.additionalEventParametersBuilder_ == null) {
                                this.ensureAdditionalEventParametersIsMutable();
                                this.additionalEventParameters_.add((EventParameter)m);
                                continue block27;
                            }
                            this.additionalEventParametersBuilder_.addMessage((AbstractMessage)m);
                            continue block27;
                        }
                    }
                    if (super.parseUnknownField(input, extensionRegistry, tag)) continue;
                    done = true;
                }
            }
            catch (InvalidProtocolBufferException e) {
                throw e.unwrapIOException();
            }
            finally {
                this.onChanged();
            }
            return this;
        }

        private void ensureDestinationReferencesIsMutable() {
            if (!this.destinationReferences_.isModifiable()) {
                this.destinationReferences_ = new LazyStringArrayList((LazyStringList)this.destinationReferences_);
            }
            this.bitField0_ |= 1;
        }

        public ProtocolStringList getDestinationReferencesList() {
            this.destinationReferences_.makeImmutable();
            return this.destinationReferences_;
        }

        @Override
        public int getDestinationReferencesCount() {
            return this.destinationReferences_.size();
        }

        @Override
        public String getDestinationReferences(int index) {
            return this.destinationReferences_.get(index);
        }

        @Override
        public ByteString getDestinationReferencesBytes(int index) {
            return this.destinationReferences_.getByteString(index);
        }

        public Builder setDestinationReferences(int index, String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.ensureDestinationReferencesIsMutable();
            this.destinationReferences_.set(index, value);
            this.bitField0_ |= 1;
            this.onChanged();
            return this;
        }

        public Builder addDestinationReferences(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.ensureDestinationReferencesIsMutable();
            this.destinationReferences_.add((Object)value);
            this.bitField0_ |= 1;
            this.onChanged();
            return this;
        }

        public Builder addAllDestinationReferences(Iterable<String> values) {
            this.ensureDestinationReferencesIsMutable();
            AbstractMessageLite.Builder.addAll(values, (List)this.destinationReferences_);
            this.bitField0_ |= 1;
            this.onChanged();
            return this;
        }

        public Builder clearDestinationReferences() {
            this.destinationReferences_ = LazyStringArrayList.emptyList();
            this.bitField0_ &= 0xFFFFFFFE;
            this.onChanged();
            return this;
        }

        public Builder addDestinationReferencesBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            Event.checkByteStringIsUtf8((ByteString)value);
            this.ensureDestinationReferencesIsMutable();
            this.destinationReferences_.add(value);
            this.bitField0_ |= 1;
            this.onChanged();
            return this;
        }

        @Override
        public String getTransactionId() {
            Object ref = this.transactionId_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.transactionId_ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getTransactionIdBytes() {
            Object ref = this.transactionId_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.transactionId_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setTransactionId(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.transactionId_ = value;
            this.bitField0_ |= 2;
            this.onChanged();
            return this;
        }

        public Builder clearTransactionId() {
            this.transactionId_ = Event.getDefaultInstance().getTransactionId();
            this.bitField0_ &= 0xFFFFFFFD;
            this.onChanged();
            return this;
        }

        public Builder setTransactionIdBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            Event.checkByteStringIsUtf8((ByteString)value);
            this.transactionId_ = value;
            this.bitField0_ |= 2;
            this.onChanged();
            return this;
        }

        @Override
        public boolean hasEventTimestamp() {
            return (this.bitField0_ & 4) != 0;
        }

        @Override
        public Timestamp getEventTimestamp() {
            if (this.eventTimestampBuilder_ == null) {
                return this.eventTimestamp_ == null ? Timestamp.getDefaultInstance() : this.eventTimestamp_;
            }
            return (Timestamp)this.eventTimestampBuilder_.getMessage();
        }

        public Builder setEventTimestamp(Timestamp value) {
            if (this.eventTimestampBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.eventTimestamp_ = value;
            } else {
                this.eventTimestampBuilder_.setMessage((AbstractMessage)value);
            }
            this.bitField0_ |= 4;
            this.onChanged();
            return this;
        }

        public Builder setEventTimestamp(Timestamp.Builder builderForValue) {
            if (this.eventTimestampBuilder_ == null) {
                this.eventTimestamp_ = builderForValue.build();
            } else {
                this.eventTimestampBuilder_.setMessage((AbstractMessage)builderForValue.build());
            }
            this.bitField0_ |= 4;
            this.onChanged();
            return this;
        }

        public Builder mergeEventTimestamp(Timestamp value) {
            if (this.eventTimestampBuilder_ == null) {
                if ((this.bitField0_ & 4) != 0 && this.eventTimestamp_ != null && this.eventTimestamp_ != Timestamp.getDefaultInstance()) {
                    this.getEventTimestampBuilder().mergeFrom(value);
                } else {
                    this.eventTimestamp_ = value;
                }
            } else {
                this.eventTimestampBuilder_.mergeFrom((AbstractMessage)value);
            }
            if (this.eventTimestamp_ != null) {
                this.bitField0_ |= 4;
                this.onChanged();
            }
            return this;
        }

        public Builder clearEventTimestamp() {
            this.bitField0_ &= 0xFFFFFFFB;
            this.eventTimestamp_ = null;
            if (this.eventTimestampBuilder_ != null) {
                this.eventTimestampBuilder_.dispose();
                this.eventTimestampBuilder_ = null;
            }
            this.onChanged();
            return this;
        }

        public Timestamp.Builder getEventTimestampBuilder() {
            this.bitField0_ |= 4;
            this.onChanged();
            return (Timestamp.Builder)this.getEventTimestampFieldBuilder().getBuilder();
        }

        @Override
        public TimestampOrBuilder getEventTimestampOrBuilder() {
            if (this.eventTimestampBuilder_ != null) {
                return (TimestampOrBuilder)this.eventTimestampBuilder_.getMessageOrBuilder();
            }
            return this.eventTimestamp_ == null ? Timestamp.getDefaultInstance() : this.eventTimestamp_;
        }

        private SingleFieldBuilderV3<Timestamp, Timestamp.Builder, TimestampOrBuilder> getEventTimestampFieldBuilder() {
            if (this.eventTimestampBuilder_ == null) {
                this.eventTimestampBuilder_ = new SingleFieldBuilderV3((AbstractMessage)this.getEventTimestamp(), (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.eventTimestamp_ = null;
            }
            return this.eventTimestampBuilder_;
        }

        @Override
        public boolean hasLastUpdatedTimestamp() {
            return (this.bitField0_ & 8) != 0;
        }

        @Override
        public Timestamp getLastUpdatedTimestamp() {
            if (this.lastUpdatedTimestampBuilder_ == null) {
                return this.lastUpdatedTimestamp_ == null ? Timestamp.getDefaultInstance() : this.lastUpdatedTimestamp_;
            }
            return (Timestamp)this.lastUpdatedTimestampBuilder_.getMessage();
        }

        public Builder setLastUpdatedTimestamp(Timestamp value) {
            if (this.lastUpdatedTimestampBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.lastUpdatedTimestamp_ = value;
            } else {
                this.lastUpdatedTimestampBuilder_.setMessage((AbstractMessage)value);
            }
            this.bitField0_ |= 8;
            this.onChanged();
            return this;
        }

        public Builder setLastUpdatedTimestamp(Timestamp.Builder builderForValue) {
            if (this.lastUpdatedTimestampBuilder_ == null) {
                this.lastUpdatedTimestamp_ = builderForValue.build();
            } else {
                this.lastUpdatedTimestampBuilder_.setMessage((AbstractMessage)builderForValue.build());
            }
            this.bitField0_ |= 8;
            this.onChanged();
            return this;
        }

        public Builder mergeLastUpdatedTimestamp(Timestamp value) {
            if (this.lastUpdatedTimestampBuilder_ == null) {
                if ((this.bitField0_ & 8) != 0 && this.lastUpdatedTimestamp_ != null && this.lastUpdatedTimestamp_ != Timestamp.getDefaultInstance()) {
                    this.getLastUpdatedTimestampBuilder().mergeFrom(value);
                } else {
                    this.lastUpdatedTimestamp_ = value;
                }
            } else {
                this.lastUpdatedTimestampBuilder_.mergeFrom((AbstractMessage)value);
            }
            if (this.lastUpdatedTimestamp_ != null) {
                this.bitField0_ |= 8;
                this.onChanged();
            }
            return this;
        }

        public Builder clearLastUpdatedTimestamp() {
            this.bitField0_ &= 0xFFFFFFF7;
            this.lastUpdatedTimestamp_ = null;
            if (this.lastUpdatedTimestampBuilder_ != null) {
                this.lastUpdatedTimestampBuilder_.dispose();
                this.lastUpdatedTimestampBuilder_ = null;
            }
            this.onChanged();
            return this;
        }

        public Timestamp.Builder getLastUpdatedTimestampBuilder() {
            this.bitField0_ |= 8;
            this.onChanged();
            return (Timestamp.Builder)this.getLastUpdatedTimestampFieldBuilder().getBuilder();
        }

        @Override
        public TimestampOrBuilder getLastUpdatedTimestampOrBuilder() {
            if (this.lastUpdatedTimestampBuilder_ != null) {
                return (TimestampOrBuilder)this.lastUpdatedTimestampBuilder_.getMessageOrBuilder();
            }
            return this.lastUpdatedTimestamp_ == null ? Timestamp.getDefaultInstance() : this.lastUpdatedTimestamp_;
        }

        private SingleFieldBuilderV3<Timestamp, Timestamp.Builder, TimestampOrBuilder> getLastUpdatedTimestampFieldBuilder() {
            if (this.lastUpdatedTimestampBuilder_ == null) {
                this.lastUpdatedTimestampBuilder_ = new SingleFieldBuilderV3((AbstractMessage)this.getLastUpdatedTimestamp(), (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.lastUpdatedTimestamp_ = null;
            }
            return this.lastUpdatedTimestampBuilder_;
        }

        @Override
        public boolean hasUserData() {
            return (this.bitField0_ & 0x10) != 0;
        }

        @Override
        public UserData getUserData() {
            if (this.userDataBuilder_ == null) {
                return this.userData_ == null ? UserData.getDefaultInstance() : this.userData_;
            }
            return (UserData)this.userDataBuilder_.getMessage();
        }

        public Builder setUserData(UserData value) {
            if (this.userDataBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.userData_ = value;
            } else {
                this.userDataBuilder_.setMessage((AbstractMessage)value);
            }
            this.bitField0_ |= 0x10;
            this.onChanged();
            return this;
        }

        public Builder setUserData(UserData.Builder builderForValue) {
            if (this.userDataBuilder_ == null) {
                this.userData_ = builderForValue.build();
            } else {
                this.userDataBuilder_.setMessage((AbstractMessage)builderForValue.build());
            }
            this.bitField0_ |= 0x10;
            this.onChanged();
            return this;
        }

        public Builder mergeUserData(UserData value) {
            if (this.userDataBuilder_ == null) {
                if ((this.bitField0_ & 0x10) != 0 && this.userData_ != null && this.userData_ != UserData.getDefaultInstance()) {
                    this.getUserDataBuilder().mergeFrom(value);
                } else {
                    this.userData_ = value;
                }
            } else {
                this.userDataBuilder_.mergeFrom((AbstractMessage)value);
            }
            if (this.userData_ != null) {
                this.bitField0_ |= 0x10;
                this.onChanged();
            }
            return this;
        }

        public Builder clearUserData() {
            this.bitField0_ &= 0xFFFFFFEF;
            this.userData_ = null;
            if (this.userDataBuilder_ != null) {
                this.userDataBuilder_.dispose();
                this.userDataBuilder_ = null;
            }
            this.onChanged();
            return this;
        }

        public UserData.Builder getUserDataBuilder() {
            this.bitField0_ |= 0x10;
            this.onChanged();
            return (UserData.Builder)this.getUserDataFieldBuilder().getBuilder();
        }

        @Override
        public UserDataOrBuilder getUserDataOrBuilder() {
            if (this.userDataBuilder_ != null) {
                return (UserDataOrBuilder)this.userDataBuilder_.getMessageOrBuilder();
            }
            return this.userData_ == null ? UserData.getDefaultInstance() : this.userData_;
        }

        private SingleFieldBuilderV3<UserData, UserData.Builder, UserDataOrBuilder> getUserDataFieldBuilder() {
            if (this.userDataBuilder_ == null) {
                this.userDataBuilder_ = new SingleFieldBuilderV3((AbstractMessage)this.getUserData(), (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.userData_ = null;
            }
            return this.userDataBuilder_;
        }

        @Override
        public boolean hasConsent() {
            return (this.bitField0_ & 0x20) != 0;
        }

        @Override
        public Consent getConsent() {
            if (this.consentBuilder_ == null) {
                return this.consent_ == null ? Consent.getDefaultInstance() : this.consent_;
            }
            return (Consent)this.consentBuilder_.getMessage();
        }

        public Builder setConsent(Consent value) {
            if (this.consentBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.consent_ = value;
            } else {
                this.consentBuilder_.setMessage((AbstractMessage)value);
            }
            this.bitField0_ |= 0x20;
            this.onChanged();
            return this;
        }

        public Builder setConsent(Consent.Builder builderForValue) {
            if (this.consentBuilder_ == null) {
                this.consent_ = builderForValue.build();
            } else {
                this.consentBuilder_.setMessage((AbstractMessage)builderForValue.build());
            }
            this.bitField0_ |= 0x20;
            this.onChanged();
            return this;
        }

        public Builder mergeConsent(Consent value) {
            if (this.consentBuilder_ == null) {
                if ((this.bitField0_ & 0x20) != 0 && this.consent_ != null && this.consent_ != Consent.getDefaultInstance()) {
                    this.getConsentBuilder().mergeFrom(value);
                } else {
                    this.consent_ = value;
                }
            } else {
                this.consentBuilder_.mergeFrom((AbstractMessage)value);
            }
            if (this.consent_ != null) {
                this.bitField0_ |= 0x20;
                this.onChanged();
            }
            return this;
        }

        public Builder clearConsent() {
            this.bitField0_ &= 0xFFFFFFDF;
            this.consent_ = null;
            if (this.consentBuilder_ != null) {
                this.consentBuilder_.dispose();
                this.consentBuilder_ = null;
            }
            this.onChanged();
            return this;
        }

        public Consent.Builder getConsentBuilder() {
            this.bitField0_ |= 0x20;
            this.onChanged();
            return (Consent.Builder)this.getConsentFieldBuilder().getBuilder();
        }

        @Override
        public ConsentOrBuilder getConsentOrBuilder() {
            if (this.consentBuilder_ != null) {
                return (ConsentOrBuilder)this.consentBuilder_.getMessageOrBuilder();
            }
            return this.consent_ == null ? Consent.getDefaultInstance() : this.consent_;
        }

        private SingleFieldBuilderV3<Consent, Consent.Builder, ConsentOrBuilder> getConsentFieldBuilder() {
            if (this.consentBuilder_ == null) {
                this.consentBuilder_ = new SingleFieldBuilderV3((AbstractMessage)this.getConsent(), (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.consent_ = null;
            }
            return this.consentBuilder_;
        }

        @Override
        public boolean hasAdIdentifiers() {
            return (this.bitField0_ & 0x40) != 0;
        }

        @Override
        public AdIdentifiers getAdIdentifiers() {
            if (this.adIdentifiersBuilder_ == null) {
                return this.adIdentifiers_ == null ? AdIdentifiers.getDefaultInstance() : this.adIdentifiers_;
            }
            return (AdIdentifiers)this.adIdentifiersBuilder_.getMessage();
        }

        public Builder setAdIdentifiers(AdIdentifiers value) {
            if (this.adIdentifiersBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.adIdentifiers_ = value;
            } else {
                this.adIdentifiersBuilder_.setMessage((AbstractMessage)value);
            }
            this.bitField0_ |= 0x40;
            this.onChanged();
            return this;
        }

        public Builder setAdIdentifiers(AdIdentifiers.Builder builderForValue) {
            if (this.adIdentifiersBuilder_ == null) {
                this.adIdentifiers_ = builderForValue.build();
            } else {
                this.adIdentifiersBuilder_.setMessage((AbstractMessage)builderForValue.build());
            }
            this.bitField0_ |= 0x40;
            this.onChanged();
            return this;
        }

        public Builder mergeAdIdentifiers(AdIdentifiers value) {
            if (this.adIdentifiersBuilder_ == null) {
                if ((this.bitField0_ & 0x40) != 0 && this.adIdentifiers_ != null && this.adIdentifiers_ != AdIdentifiers.getDefaultInstance()) {
                    this.getAdIdentifiersBuilder().mergeFrom(value);
                } else {
                    this.adIdentifiers_ = value;
                }
            } else {
                this.adIdentifiersBuilder_.mergeFrom((AbstractMessage)value);
            }
            if (this.adIdentifiers_ != null) {
                this.bitField0_ |= 0x40;
                this.onChanged();
            }
            return this;
        }

        public Builder clearAdIdentifiers() {
            this.bitField0_ &= 0xFFFFFFBF;
            this.adIdentifiers_ = null;
            if (this.adIdentifiersBuilder_ != null) {
                this.adIdentifiersBuilder_.dispose();
                this.adIdentifiersBuilder_ = null;
            }
            this.onChanged();
            return this;
        }

        public AdIdentifiers.Builder getAdIdentifiersBuilder() {
            this.bitField0_ |= 0x40;
            this.onChanged();
            return (AdIdentifiers.Builder)this.getAdIdentifiersFieldBuilder().getBuilder();
        }

        @Override
        public AdIdentifiersOrBuilder getAdIdentifiersOrBuilder() {
            if (this.adIdentifiersBuilder_ != null) {
                return (AdIdentifiersOrBuilder)this.adIdentifiersBuilder_.getMessageOrBuilder();
            }
            return this.adIdentifiers_ == null ? AdIdentifiers.getDefaultInstance() : this.adIdentifiers_;
        }

        private SingleFieldBuilderV3<AdIdentifiers, AdIdentifiers.Builder, AdIdentifiersOrBuilder> getAdIdentifiersFieldBuilder() {
            if (this.adIdentifiersBuilder_ == null) {
                this.adIdentifiersBuilder_ = new SingleFieldBuilderV3((AbstractMessage)this.getAdIdentifiers(), (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.adIdentifiers_ = null;
            }
            return this.adIdentifiersBuilder_;
        }

        @Override
        public String getCurrency() {
            Object ref = this.currency_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.currency_ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getCurrencyBytes() {
            Object ref = this.currency_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.currency_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setCurrency(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.currency_ = value;
            this.bitField0_ |= 0x80;
            this.onChanged();
            return this;
        }

        public Builder clearCurrency() {
            this.currency_ = Event.getDefaultInstance().getCurrency();
            this.bitField0_ &= 0xFFFFFF7F;
            this.onChanged();
            return this;
        }

        public Builder setCurrencyBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            Event.checkByteStringIsUtf8((ByteString)value);
            this.currency_ = value;
            this.bitField0_ |= 0x80;
            this.onChanged();
            return this;
        }

        @Override
        public double getConversionValue() {
            return this.conversionValue_;
        }

        public Builder setConversionValue(double value) {
            this.conversionValue_ = value;
            this.bitField0_ |= 0x100;
            this.onChanged();
            return this;
        }

        public Builder clearConversionValue() {
            this.bitField0_ &= 0xFFFFFEFF;
            this.conversionValue_ = 0.0;
            this.onChanged();
            return this;
        }

        @Override
        public int getEventSourceValue() {
            return this.eventSource_;
        }

        public Builder setEventSourceValue(int value) {
            this.eventSource_ = value;
            this.bitField0_ |= 0x200;
            this.onChanged();
            return this;
        }

        @Override
        public EventSource getEventSource() {
            EventSource result = EventSource.forNumber(this.eventSource_);
            return result == null ? EventSource.UNRECOGNIZED : result;
        }

        public Builder setEventSource(EventSource value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.bitField0_ |= 0x200;
            this.eventSource_ = value.getNumber();
            this.onChanged();
            return this;
        }

        public Builder clearEventSource() {
            this.bitField0_ &= 0xFFFFFDFF;
            this.eventSource_ = 0;
            this.onChanged();
            return this;
        }

        @Override
        public boolean hasEventDeviceInfo() {
            return (this.bitField0_ & 0x400) != 0;
        }

        @Override
        public DeviceInfo getEventDeviceInfo() {
            if (this.eventDeviceInfoBuilder_ == null) {
                return this.eventDeviceInfo_ == null ? DeviceInfo.getDefaultInstance() : this.eventDeviceInfo_;
            }
            return (DeviceInfo)this.eventDeviceInfoBuilder_.getMessage();
        }

        public Builder setEventDeviceInfo(DeviceInfo value) {
            if (this.eventDeviceInfoBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.eventDeviceInfo_ = value;
            } else {
                this.eventDeviceInfoBuilder_.setMessage((AbstractMessage)value);
            }
            this.bitField0_ |= 0x400;
            this.onChanged();
            return this;
        }

        public Builder setEventDeviceInfo(DeviceInfo.Builder builderForValue) {
            if (this.eventDeviceInfoBuilder_ == null) {
                this.eventDeviceInfo_ = builderForValue.build();
            } else {
                this.eventDeviceInfoBuilder_.setMessage((AbstractMessage)builderForValue.build());
            }
            this.bitField0_ |= 0x400;
            this.onChanged();
            return this;
        }

        public Builder mergeEventDeviceInfo(DeviceInfo value) {
            if (this.eventDeviceInfoBuilder_ == null) {
                if ((this.bitField0_ & 0x400) != 0 && this.eventDeviceInfo_ != null && this.eventDeviceInfo_ != DeviceInfo.getDefaultInstance()) {
                    this.getEventDeviceInfoBuilder().mergeFrom(value);
                } else {
                    this.eventDeviceInfo_ = value;
                }
            } else {
                this.eventDeviceInfoBuilder_.mergeFrom((AbstractMessage)value);
            }
            if (this.eventDeviceInfo_ != null) {
                this.bitField0_ |= 0x400;
                this.onChanged();
            }
            return this;
        }

        public Builder clearEventDeviceInfo() {
            this.bitField0_ &= 0xFFFFFBFF;
            this.eventDeviceInfo_ = null;
            if (this.eventDeviceInfoBuilder_ != null) {
                this.eventDeviceInfoBuilder_.dispose();
                this.eventDeviceInfoBuilder_ = null;
            }
            this.onChanged();
            return this;
        }

        public DeviceInfo.Builder getEventDeviceInfoBuilder() {
            this.bitField0_ |= 0x400;
            this.onChanged();
            return (DeviceInfo.Builder)this.getEventDeviceInfoFieldBuilder().getBuilder();
        }

        @Override
        public DeviceInfoOrBuilder getEventDeviceInfoOrBuilder() {
            if (this.eventDeviceInfoBuilder_ != null) {
                return (DeviceInfoOrBuilder)this.eventDeviceInfoBuilder_.getMessageOrBuilder();
            }
            return this.eventDeviceInfo_ == null ? DeviceInfo.getDefaultInstance() : this.eventDeviceInfo_;
        }

        private SingleFieldBuilderV3<DeviceInfo, DeviceInfo.Builder, DeviceInfoOrBuilder> getEventDeviceInfoFieldBuilder() {
            if (this.eventDeviceInfoBuilder_ == null) {
                this.eventDeviceInfoBuilder_ = new SingleFieldBuilderV3((AbstractMessage)this.getEventDeviceInfo(), (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.eventDeviceInfo_ = null;
            }
            return this.eventDeviceInfoBuilder_;
        }

        @Override
        public boolean hasCartData() {
            return (this.bitField0_ & 0x800) != 0;
        }

        @Override
        public CartData getCartData() {
            if (this.cartDataBuilder_ == null) {
                return this.cartData_ == null ? CartData.getDefaultInstance() : this.cartData_;
            }
            return (CartData)this.cartDataBuilder_.getMessage();
        }

        public Builder setCartData(CartData value) {
            if (this.cartDataBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.cartData_ = value;
            } else {
                this.cartDataBuilder_.setMessage((AbstractMessage)value);
            }
            this.bitField0_ |= 0x800;
            this.onChanged();
            return this;
        }

        public Builder setCartData(CartData.Builder builderForValue) {
            if (this.cartDataBuilder_ == null) {
                this.cartData_ = builderForValue.build();
            } else {
                this.cartDataBuilder_.setMessage((AbstractMessage)builderForValue.build());
            }
            this.bitField0_ |= 0x800;
            this.onChanged();
            return this;
        }

        public Builder mergeCartData(CartData value) {
            if (this.cartDataBuilder_ == null) {
                if ((this.bitField0_ & 0x800) != 0 && this.cartData_ != null && this.cartData_ != CartData.getDefaultInstance()) {
                    this.getCartDataBuilder().mergeFrom(value);
                } else {
                    this.cartData_ = value;
                }
            } else {
                this.cartDataBuilder_.mergeFrom((AbstractMessage)value);
            }
            if (this.cartData_ != null) {
                this.bitField0_ |= 0x800;
                this.onChanged();
            }
            return this;
        }

        public Builder clearCartData() {
            this.bitField0_ &= 0xFFFFF7FF;
            this.cartData_ = null;
            if (this.cartDataBuilder_ != null) {
                this.cartDataBuilder_.dispose();
                this.cartDataBuilder_ = null;
            }
            this.onChanged();
            return this;
        }

        public CartData.Builder getCartDataBuilder() {
            this.bitField0_ |= 0x800;
            this.onChanged();
            return (CartData.Builder)this.getCartDataFieldBuilder().getBuilder();
        }

        @Override
        public CartDataOrBuilder getCartDataOrBuilder() {
            if (this.cartDataBuilder_ != null) {
                return (CartDataOrBuilder)this.cartDataBuilder_.getMessageOrBuilder();
            }
            return this.cartData_ == null ? CartData.getDefaultInstance() : this.cartData_;
        }

        private SingleFieldBuilderV3<CartData, CartData.Builder, CartDataOrBuilder> getCartDataFieldBuilder() {
            if (this.cartDataBuilder_ == null) {
                this.cartDataBuilder_ = new SingleFieldBuilderV3((AbstractMessage)this.getCartData(), (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.cartData_ = null;
            }
            return this.cartDataBuilder_;
        }

        private void ensureCustomVariablesIsMutable() {
            if ((this.bitField0_ & 0x1000) == 0) {
                this.customVariables_ = new ArrayList<CustomVariable>(this.customVariables_);
                this.bitField0_ |= 0x1000;
            }
        }

        @Override
        public List<CustomVariable> getCustomVariablesList() {
            if (this.customVariablesBuilder_ == null) {
                return Collections.unmodifiableList(this.customVariables_);
            }
            return this.customVariablesBuilder_.getMessageList();
        }

        @Override
        public int getCustomVariablesCount() {
            if (this.customVariablesBuilder_ == null) {
                return this.customVariables_.size();
            }
            return this.customVariablesBuilder_.getCount();
        }

        @Override
        public CustomVariable getCustomVariables(int index) {
            if (this.customVariablesBuilder_ == null) {
                return this.customVariables_.get(index);
            }
            return (CustomVariable)this.customVariablesBuilder_.getMessage(index);
        }

        public Builder setCustomVariables(int index, CustomVariable value) {
            if (this.customVariablesBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureCustomVariablesIsMutable();
                this.customVariables_.set(index, value);
                this.onChanged();
            } else {
                this.customVariablesBuilder_.setMessage(index, (AbstractMessage)value);
            }
            return this;
        }

        public Builder setCustomVariables(int index, CustomVariable.Builder builderForValue) {
            if (this.customVariablesBuilder_ == null) {
                this.ensureCustomVariablesIsMutable();
                this.customVariables_.set(index, builderForValue.build());
                this.onChanged();
            } else {
                this.customVariablesBuilder_.setMessage(index, (AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addCustomVariables(CustomVariable value) {
            if (this.customVariablesBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureCustomVariablesIsMutable();
                this.customVariables_.add(value);
                this.onChanged();
            } else {
                this.customVariablesBuilder_.addMessage((AbstractMessage)value);
            }
            return this;
        }

        public Builder addCustomVariables(int index, CustomVariable value) {
            if (this.customVariablesBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureCustomVariablesIsMutable();
                this.customVariables_.add(index, value);
                this.onChanged();
            } else {
                this.customVariablesBuilder_.addMessage(index, (AbstractMessage)value);
            }
            return this;
        }

        public Builder addCustomVariables(CustomVariable.Builder builderForValue) {
            if (this.customVariablesBuilder_ == null) {
                this.ensureCustomVariablesIsMutable();
                this.customVariables_.add(builderForValue.build());
                this.onChanged();
            } else {
                this.customVariablesBuilder_.addMessage((AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addCustomVariables(int index, CustomVariable.Builder builderForValue) {
            if (this.customVariablesBuilder_ == null) {
                this.ensureCustomVariablesIsMutable();
                this.customVariables_.add(index, builderForValue.build());
                this.onChanged();
            } else {
                this.customVariablesBuilder_.addMessage(index, (AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addAllCustomVariables(Iterable<? extends CustomVariable> values) {
            if (this.customVariablesBuilder_ == null) {
                this.ensureCustomVariablesIsMutable();
                AbstractMessageLite.Builder.addAll(values, this.customVariables_);
                this.onChanged();
            } else {
                this.customVariablesBuilder_.addAllMessages(values);
            }
            return this;
        }

        public Builder clearCustomVariables() {
            if (this.customVariablesBuilder_ == null) {
                this.customVariables_ = Collections.emptyList();
                this.bitField0_ &= 0xFFFFEFFF;
                this.onChanged();
            } else {
                this.customVariablesBuilder_.clear();
            }
            return this;
        }

        public Builder removeCustomVariables(int index) {
            if (this.customVariablesBuilder_ == null) {
                this.ensureCustomVariablesIsMutable();
                this.customVariables_.remove(index);
                this.onChanged();
            } else {
                this.customVariablesBuilder_.remove(index);
            }
            return this;
        }

        public CustomVariable.Builder getCustomVariablesBuilder(int index) {
            return (CustomVariable.Builder)this.getCustomVariablesFieldBuilder().getBuilder(index);
        }

        @Override
        public CustomVariableOrBuilder getCustomVariablesOrBuilder(int index) {
            if (this.customVariablesBuilder_ == null) {
                return this.customVariables_.get(index);
            }
            return (CustomVariableOrBuilder)this.customVariablesBuilder_.getMessageOrBuilder(index);
        }

        @Override
        public List<? extends CustomVariableOrBuilder> getCustomVariablesOrBuilderList() {
            if (this.customVariablesBuilder_ != null) {
                return this.customVariablesBuilder_.getMessageOrBuilderList();
            }
            return Collections.unmodifiableList(this.customVariables_);
        }

        public CustomVariable.Builder addCustomVariablesBuilder() {
            return (CustomVariable.Builder)this.getCustomVariablesFieldBuilder().addBuilder((AbstractMessage)CustomVariable.getDefaultInstance());
        }

        public CustomVariable.Builder addCustomVariablesBuilder(int index) {
            return (CustomVariable.Builder)this.getCustomVariablesFieldBuilder().addBuilder(index, (AbstractMessage)CustomVariable.getDefaultInstance());
        }

        public List<CustomVariable.Builder> getCustomVariablesBuilderList() {
            return this.getCustomVariablesFieldBuilder().getBuilderList();
        }

        private RepeatedFieldBuilderV3<CustomVariable, CustomVariable.Builder, CustomVariableOrBuilder> getCustomVariablesFieldBuilder() {
            if (this.customVariablesBuilder_ == null) {
                this.customVariablesBuilder_ = new RepeatedFieldBuilderV3(this.customVariables_, (this.bitField0_ & 0x1000) != 0, (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.customVariables_ = null;
            }
            return this.customVariablesBuilder_;
        }

        private void ensureExperimentalFieldsIsMutable() {
            if ((this.bitField0_ & 0x2000) == 0) {
                this.experimentalFields_ = new ArrayList<ExperimentalField>(this.experimentalFields_);
                this.bitField0_ |= 0x2000;
            }
        }

        @Override
        public List<ExperimentalField> getExperimentalFieldsList() {
            if (this.experimentalFieldsBuilder_ == null) {
                return Collections.unmodifiableList(this.experimentalFields_);
            }
            return this.experimentalFieldsBuilder_.getMessageList();
        }

        @Override
        public int getExperimentalFieldsCount() {
            if (this.experimentalFieldsBuilder_ == null) {
                return this.experimentalFields_.size();
            }
            return this.experimentalFieldsBuilder_.getCount();
        }

        @Override
        public ExperimentalField getExperimentalFields(int index) {
            if (this.experimentalFieldsBuilder_ == null) {
                return this.experimentalFields_.get(index);
            }
            return (ExperimentalField)this.experimentalFieldsBuilder_.getMessage(index);
        }

        public Builder setExperimentalFields(int index, ExperimentalField value) {
            if (this.experimentalFieldsBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureExperimentalFieldsIsMutable();
                this.experimentalFields_.set(index, value);
                this.onChanged();
            } else {
                this.experimentalFieldsBuilder_.setMessage(index, (AbstractMessage)value);
            }
            return this;
        }

        public Builder setExperimentalFields(int index, ExperimentalField.Builder builderForValue) {
            if (this.experimentalFieldsBuilder_ == null) {
                this.ensureExperimentalFieldsIsMutable();
                this.experimentalFields_.set(index, builderForValue.build());
                this.onChanged();
            } else {
                this.experimentalFieldsBuilder_.setMessage(index, (AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addExperimentalFields(ExperimentalField value) {
            if (this.experimentalFieldsBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureExperimentalFieldsIsMutable();
                this.experimentalFields_.add(value);
                this.onChanged();
            } else {
                this.experimentalFieldsBuilder_.addMessage((AbstractMessage)value);
            }
            return this;
        }

        public Builder addExperimentalFields(int index, ExperimentalField value) {
            if (this.experimentalFieldsBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureExperimentalFieldsIsMutable();
                this.experimentalFields_.add(index, value);
                this.onChanged();
            } else {
                this.experimentalFieldsBuilder_.addMessage(index, (AbstractMessage)value);
            }
            return this;
        }

        public Builder addExperimentalFields(ExperimentalField.Builder builderForValue) {
            if (this.experimentalFieldsBuilder_ == null) {
                this.ensureExperimentalFieldsIsMutable();
                this.experimentalFields_.add(builderForValue.build());
                this.onChanged();
            } else {
                this.experimentalFieldsBuilder_.addMessage((AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addExperimentalFields(int index, ExperimentalField.Builder builderForValue) {
            if (this.experimentalFieldsBuilder_ == null) {
                this.ensureExperimentalFieldsIsMutable();
                this.experimentalFields_.add(index, builderForValue.build());
                this.onChanged();
            } else {
                this.experimentalFieldsBuilder_.addMessage(index, (AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addAllExperimentalFields(Iterable<? extends ExperimentalField> values) {
            if (this.experimentalFieldsBuilder_ == null) {
                this.ensureExperimentalFieldsIsMutable();
                AbstractMessageLite.Builder.addAll(values, this.experimentalFields_);
                this.onChanged();
            } else {
                this.experimentalFieldsBuilder_.addAllMessages(values);
            }
            return this;
        }

        public Builder clearExperimentalFields() {
            if (this.experimentalFieldsBuilder_ == null) {
                this.experimentalFields_ = Collections.emptyList();
                this.bitField0_ &= 0xFFFFDFFF;
                this.onChanged();
            } else {
                this.experimentalFieldsBuilder_.clear();
            }
            return this;
        }

        public Builder removeExperimentalFields(int index) {
            if (this.experimentalFieldsBuilder_ == null) {
                this.ensureExperimentalFieldsIsMutable();
                this.experimentalFields_.remove(index);
                this.onChanged();
            } else {
                this.experimentalFieldsBuilder_.remove(index);
            }
            return this;
        }

        public ExperimentalField.Builder getExperimentalFieldsBuilder(int index) {
            return (ExperimentalField.Builder)this.getExperimentalFieldsFieldBuilder().getBuilder(index);
        }

        @Override
        public ExperimentalFieldOrBuilder getExperimentalFieldsOrBuilder(int index) {
            if (this.experimentalFieldsBuilder_ == null) {
                return this.experimentalFields_.get(index);
            }
            return (ExperimentalFieldOrBuilder)this.experimentalFieldsBuilder_.getMessageOrBuilder(index);
        }

        @Override
        public List<? extends ExperimentalFieldOrBuilder> getExperimentalFieldsOrBuilderList() {
            if (this.experimentalFieldsBuilder_ != null) {
                return this.experimentalFieldsBuilder_.getMessageOrBuilderList();
            }
            return Collections.unmodifiableList(this.experimentalFields_);
        }

        public ExperimentalField.Builder addExperimentalFieldsBuilder() {
            return (ExperimentalField.Builder)this.getExperimentalFieldsFieldBuilder().addBuilder((AbstractMessage)ExperimentalField.getDefaultInstance());
        }

        public ExperimentalField.Builder addExperimentalFieldsBuilder(int index) {
            return (ExperimentalField.Builder)this.getExperimentalFieldsFieldBuilder().addBuilder(index, (AbstractMessage)ExperimentalField.getDefaultInstance());
        }

        public List<ExperimentalField.Builder> getExperimentalFieldsBuilderList() {
            return this.getExperimentalFieldsFieldBuilder().getBuilderList();
        }

        private RepeatedFieldBuilderV3<ExperimentalField, ExperimentalField.Builder, ExperimentalFieldOrBuilder> getExperimentalFieldsFieldBuilder() {
            if (this.experimentalFieldsBuilder_ == null) {
                this.experimentalFieldsBuilder_ = new RepeatedFieldBuilderV3(this.experimentalFields_, (this.bitField0_ & 0x2000) != 0, (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.experimentalFields_ = null;
            }
            return this.experimentalFieldsBuilder_;
        }

        @Override
        public boolean hasUserProperties() {
            return (this.bitField0_ & 0x4000) != 0;
        }

        @Override
        public UserProperties getUserProperties() {
            if (this.userPropertiesBuilder_ == null) {
                return this.userProperties_ == null ? UserProperties.getDefaultInstance() : this.userProperties_;
            }
            return (UserProperties)this.userPropertiesBuilder_.getMessage();
        }

        public Builder setUserProperties(UserProperties value) {
            if (this.userPropertiesBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.userProperties_ = value;
            } else {
                this.userPropertiesBuilder_.setMessage((AbstractMessage)value);
            }
            this.bitField0_ |= 0x4000;
            this.onChanged();
            return this;
        }

        public Builder setUserProperties(UserProperties.Builder builderForValue) {
            if (this.userPropertiesBuilder_ == null) {
                this.userProperties_ = builderForValue.build();
            } else {
                this.userPropertiesBuilder_.setMessage((AbstractMessage)builderForValue.build());
            }
            this.bitField0_ |= 0x4000;
            this.onChanged();
            return this;
        }

        public Builder mergeUserProperties(UserProperties value) {
            if (this.userPropertiesBuilder_ == null) {
                if ((this.bitField0_ & 0x4000) != 0 && this.userProperties_ != null && this.userProperties_ != UserProperties.getDefaultInstance()) {
                    this.getUserPropertiesBuilder().mergeFrom(value);
                } else {
                    this.userProperties_ = value;
                }
            } else {
                this.userPropertiesBuilder_.mergeFrom((AbstractMessage)value);
            }
            if (this.userProperties_ != null) {
                this.bitField0_ |= 0x4000;
                this.onChanged();
            }
            return this;
        }

        public Builder clearUserProperties() {
            this.bitField0_ &= 0xFFFFBFFF;
            this.userProperties_ = null;
            if (this.userPropertiesBuilder_ != null) {
                this.userPropertiesBuilder_.dispose();
                this.userPropertiesBuilder_ = null;
            }
            this.onChanged();
            return this;
        }

        public UserProperties.Builder getUserPropertiesBuilder() {
            this.bitField0_ |= 0x4000;
            this.onChanged();
            return (UserProperties.Builder)this.getUserPropertiesFieldBuilder().getBuilder();
        }

        @Override
        public UserPropertiesOrBuilder getUserPropertiesOrBuilder() {
            if (this.userPropertiesBuilder_ != null) {
                return (UserPropertiesOrBuilder)this.userPropertiesBuilder_.getMessageOrBuilder();
            }
            return this.userProperties_ == null ? UserProperties.getDefaultInstance() : this.userProperties_;
        }

        private SingleFieldBuilderV3<UserProperties, UserProperties.Builder, UserPropertiesOrBuilder> getUserPropertiesFieldBuilder() {
            if (this.userPropertiesBuilder_ == null) {
                this.userPropertiesBuilder_ = new SingleFieldBuilderV3((AbstractMessage)this.getUserProperties(), (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.userProperties_ = null;
            }
            return this.userPropertiesBuilder_;
        }

        @Override
        public String getEventName() {
            Object ref = this.eventName_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.eventName_ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getEventNameBytes() {
            Object ref = this.eventName_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.eventName_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setEventName(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.eventName_ = value;
            this.bitField0_ |= 0x8000;
            this.onChanged();
            return this;
        }

        public Builder clearEventName() {
            this.eventName_ = Event.getDefaultInstance().getEventName();
            this.bitField0_ &= 0xFFFF7FFF;
            this.onChanged();
            return this;
        }

        public Builder setEventNameBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            Event.checkByteStringIsUtf8((ByteString)value);
            this.eventName_ = value;
            this.bitField0_ |= 0x8000;
            this.onChanged();
            return this;
        }

        @Override
        public String getClientId() {
            Object ref = this.clientId_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.clientId_ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getClientIdBytes() {
            Object ref = this.clientId_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.clientId_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setClientId(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.clientId_ = value;
            this.bitField0_ |= 0x10000;
            this.onChanged();
            return this;
        }

        public Builder clearClientId() {
            this.clientId_ = Event.getDefaultInstance().getClientId();
            this.bitField0_ &= 0xFFFEFFFF;
            this.onChanged();
            return this;
        }

        public Builder setClientIdBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            Event.checkByteStringIsUtf8((ByteString)value);
            this.clientId_ = value;
            this.bitField0_ |= 0x10000;
            this.onChanged();
            return this;
        }

        @Override
        public String getUserId() {
            Object ref = this.userId_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.userId_ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getUserIdBytes() {
            Object ref = this.userId_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.userId_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setUserId(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.userId_ = value;
            this.bitField0_ |= 0x20000;
            this.onChanged();
            return this;
        }

        public Builder clearUserId() {
            this.userId_ = Event.getDefaultInstance().getUserId();
            this.bitField0_ &= 0xFFFDFFFF;
            this.onChanged();
            return this;
        }

        public Builder setUserIdBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            Event.checkByteStringIsUtf8((ByteString)value);
            this.userId_ = value;
            this.bitField0_ |= 0x20000;
            this.onChanged();
            return this;
        }

        private void ensureAdditionalEventParametersIsMutable() {
            if ((this.bitField0_ & 0x40000) == 0) {
                this.additionalEventParameters_ = new ArrayList<EventParameter>(this.additionalEventParameters_);
                this.bitField0_ |= 0x40000;
            }
        }

        @Override
        public List<EventParameter> getAdditionalEventParametersList() {
            if (this.additionalEventParametersBuilder_ == null) {
                return Collections.unmodifiableList(this.additionalEventParameters_);
            }
            return this.additionalEventParametersBuilder_.getMessageList();
        }

        @Override
        public int getAdditionalEventParametersCount() {
            if (this.additionalEventParametersBuilder_ == null) {
                return this.additionalEventParameters_.size();
            }
            return this.additionalEventParametersBuilder_.getCount();
        }

        @Override
        public EventParameter getAdditionalEventParameters(int index) {
            if (this.additionalEventParametersBuilder_ == null) {
                return this.additionalEventParameters_.get(index);
            }
            return (EventParameter)this.additionalEventParametersBuilder_.getMessage(index);
        }

        public Builder setAdditionalEventParameters(int index, EventParameter value) {
            if (this.additionalEventParametersBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureAdditionalEventParametersIsMutable();
                this.additionalEventParameters_.set(index, value);
                this.onChanged();
            } else {
                this.additionalEventParametersBuilder_.setMessage(index, (AbstractMessage)value);
            }
            return this;
        }

        public Builder setAdditionalEventParameters(int index, EventParameter.Builder builderForValue) {
            if (this.additionalEventParametersBuilder_ == null) {
                this.ensureAdditionalEventParametersIsMutable();
                this.additionalEventParameters_.set(index, builderForValue.build());
                this.onChanged();
            } else {
                this.additionalEventParametersBuilder_.setMessage(index, (AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addAdditionalEventParameters(EventParameter value) {
            if (this.additionalEventParametersBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureAdditionalEventParametersIsMutable();
                this.additionalEventParameters_.add(value);
                this.onChanged();
            } else {
                this.additionalEventParametersBuilder_.addMessage((AbstractMessage)value);
            }
            return this;
        }

        public Builder addAdditionalEventParameters(int index, EventParameter value) {
            if (this.additionalEventParametersBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureAdditionalEventParametersIsMutable();
                this.additionalEventParameters_.add(index, value);
                this.onChanged();
            } else {
                this.additionalEventParametersBuilder_.addMessage(index, (AbstractMessage)value);
            }
            return this;
        }

        public Builder addAdditionalEventParameters(EventParameter.Builder builderForValue) {
            if (this.additionalEventParametersBuilder_ == null) {
                this.ensureAdditionalEventParametersIsMutable();
                this.additionalEventParameters_.add(builderForValue.build());
                this.onChanged();
            } else {
                this.additionalEventParametersBuilder_.addMessage((AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addAdditionalEventParameters(int index, EventParameter.Builder builderForValue) {
            if (this.additionalEventParametersBuilder_ == null) {
                this.ensureAdditionalEventParametersIsMutable();
                this.additionalEventParameters_.add(index, builderForValue.build());
                this.onChanged();
            } else {
                this.additionalEventParametersBuilder_.addMessage(index, (AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addAllAdditionalEventParameters(Iterable<? extends EventParameter> values) {
            if (this.additionalEventParametersBuilder_ == null) {
                this.ensureAdditionalEventParametersIsMutable();
                AbstractMessageLite.Builder.addAll(values, this.additionalEventParameters_);
                this.onChanged();
            } else {
                this.additionalEventParametersBuilder_.addAllMessages(values);
            }
            return this;
        }

        public Builder clearAdditionalEventParameters() {
            if (this.additionalEventParametersBuilder_ == null) {
                this.additionalEventParameters_ = Collections.emptyList();
                this.bitField0_ &= 0xFFFBFFFF;
                this.onChanged();
            } else {
                this.additionalEventParametersBuilder_.clear();
            }
            return this;
        }

        public Builder removeAdditionalEventParameters(int index) {
            if (this.additionalEventParametersBuilder_ == null) {
                this.ensureAdditionalEventParametersIsMutable();
                this.additionalEventParameters_.remove(index);
                this.onChanged();
            } else {
                this.additionalEventParametersBuilder_.remove(index);
            }
            return this;
        }

        public EventParameter.Builder getAdditionalEventParametersBuilder(int index) {
            return (EventParameter.Builder)this.getAdditionalEventParametersFieldBuilder().getBuilder(index);
        }

        @Override
        public EventParameterOrBuilder getAdditionalEventParametersOrBuilder(int index) {
            if (this.additionalEventParametersBuilder_ == null) {
                return this.additionalEventParameters_.get(index);
            }
            return (EventParameterOrBuilder)this.additionalEventParametersBuilder_.getMessageOrBuilder(index);
        }

        @Override
        public List<? extends EventParameterOrBuilder> getAdditionalEventParametersOrBuilderList() {
            if (this.additionalEventParametersBuilder_ != null) {
                return this.additionalEventParametersBuilder_.getMessageOrBuilderList();
            }
            return Collections.unmodifiableList(this.additionalEventParameters_);
        }

        public EventParameter.Builder addAdditionalEventParametersBuilder() {
            return (EventParameter.Builder)this.getAdditionalEventParametersFieldBuilder().addBuilder((AbstractMessage)EventParameter.getDefaultInstance());
        }

        public EventParameter.Builder addAdditionalEventParametersBuilder(int index) {
            return (EventParameter.Builder)this.getAdditionalEventParametersFieldBuilder().addBuilder(index, (AbstractMessage)EventParameter.getDefaultInstance());
        }

        public List<EventParameter.Builder> getAdditionalEventParametersBuilderList() {
            return this.getAdditionalEventParametersFieldBuilder().getBuilderList();
        }

        private RepeatedFieldBuilderV3<EventParameter, EventParameter.Builder, EventParameterOrBuilder> getAdditionalEventParametersFieldBuilder() {
            if (this.additionalEventParametersBuilder_ == null) {
                this.additionalEventParametersBuilder_ = new RepeatedFieldBuilderV3(this.additionalEventParameters_, (this.bitField0_ & 0x40000) != 0, (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.additionalEventParameters_ = null;
            }
            return this.additionalEventParametersBuilder_;
        }

        public final Builder setUnknownFields(UnknownFieldSet unknownFields) {
            return (Builder)super.setUnknownFields(unknownFields);
        }

        public final Builder mergeUnknownFields(UnknownFieldSet unknownFields) {
            return (Builder)super.mergeUnknownFields(unknownFields);
        }
    }
}

