/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.admanager.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class UserName
implements ResourceName {
    private static final PathTemplate NETWORK_CODE_USER = PathTemplate.createWithoutUrlEncoding((String)"networks/{network_code}/users/{user}");
    private volatile Map<String, String> fieldValuesMap;
    private final String networkCode;
    private final String user;

    @Deprecated
    protected UserName() {
        this.networkCode = null;
        this.user = null;
    }

    private UserName(Builder builder) {
        this.networkCode = (String)Preconditions.checkNotNull((Object)builder.getNetworkCode());
        this.user = (String)Preconditions.checkNotNull((Object)builder.getUser());
    }

    public String getNetworkCode() {
        return this.networkCode;
    }

    public String getUser() {
        return this.user;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static UserName of(String networkCode, String user) {
        return UserName.newBuilder().setNetworkCode(networkCode).setUser(user).build();
    }

    public static String format(String networkCode, String user) {
        return UserName.newBuilder().setNetworkCode(networkCode).setUser(user).build().toString();
    }

    public static UserName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = NETWORK_CODE_USER.validatedMatch(formattedString, "UserName.parse: formattedString not in valid format");
        return UserName.of((String)matchMap.get("network_code"), (String)matchMap.get("user"));
    }

    public static List<UserName> parseList(List<String> formattedStrings) {
        ArrayList<UserName> list = new ArrayList<UserName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(UserName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<UserName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (UserName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return NETWORK_CODE_USER.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            UserName userName = this;
            synchronized (userName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.networkCode != null) {
                        fieldMapBuilder.put((Object)"network_code", (Object)this.networkCode);
                    }
                    if (this.user != null) {
                        fieldMapBuilder.put((Object)"user", (Object)this.user);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return NETWORK_CODE_USER.instantiate(new String[]{"network_code", this.networkCode, "user", this.user});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            UserName that = (UserName)o;
            return Objects.equals(this.networkCode, that.networkCode) && Objects.equals(this.user, that.user);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.networkCode);
        h *= 1000003;
        return h ^= Objects.hashCode(this.user);
    }

    public static class Builder {
        private String networkCode;
        private String user;

        protected Builder() {
        }

        public String getNetworkCode() {
            return this.networkCode;
        }

        public String getUser() {
            return this.user;
        }

        public Builder setNetworkCode(String networkCode) {
            this.networkCode = networkCode;
            return this;
        }

        public Builder setUser(String user) {
            this.user = user;
            return this;
        }

        private Builder(UserName userName) {
            this.networkCode = userName.networkCode;
            this.user = userName.user;
        }

        public UserName build() {
            return new UserName(this);
        }
    }
}

