/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.admanager.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class NetworkName
implements ResourceName {
    private static final PathTemplate NETWORK_CODE = PathTemplate.createWithoutUrlEncoding((String)"networks/{network_code}");
    private volatile Map<String, String> fieldValuesMap;
    private final String networkCode;

    @Deprecated
    protected NetworkName() {
        this.networkCode = null;
    }

    private NetworkName(Builder builder) {
        this.networkCode = (String)Preconditions.checkNotNull((Object)builder.getNetworkCode());
    }

    public String getNetworkCode() {
        return this.networkCode;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static NetworkName of(String networkCode) {
        return NetworkName.newBuilder().setNetworkCode(networkCode).build();
    }

    public static String format(String networkCode) {
        return NetworkName.newBuilder().setNetworkCode(networkCode).build().toString();
    }

    public static NetworkName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = NETWORK_CODE.validatedMatch(formattedString, "NetworkName.parse: formattedString not in valid format");
        return NetworkName.of((String)matchMap.get("network_code"));
    }

    public static List<NetworkName> parseList(List<String> formattedStrings) {
        ArrayList<NetworkName> list = new ArrayList<NetworkName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(NetworkName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<NetworkName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (NetworkName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return NETWORK_CODE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            NetworkName networkName = this;
            synchronized (networkName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.networkCode != null) {
                        fieldMapBuilder.put((Object)"network_code", (Object)this.networkCode);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return NETWORK_CODE.instantiate(new String[]{"network_code", this.networkCode});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            NetworkName that = (NetworkName)o;
            return Objects.equals(this.networkCode, that.networkCode);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        return h ^= Objects.hashCode(this.networkCode);
    }

    public static class Builder {
        private String networkCode;

        protected Builder() {
        }

        public String getNetworkCode() {
            return this.networkCode;
        }

        public Builder setNetworkCode(String networkCode) {
            this.networkCode = networkCode;
            return this;
        }

        private Builder(NetworkName networkName) {
            this.networkCode = networkName.networkCode;
        }

        public NetworkName build() {
            return new NetworkName(this);
        }
    }
}

