/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.admanager.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class LineItemName
implements ResourceName {
    private static final PathTemplate NETWORK_CODE_ORDER_LINE_ITEM = PathTemplate.createWithoutUrlEncoding((String)"networks/{network_code}/orders/{order}/lineItems/{line_item}");
    private volatile Map<String, String> fieldValuesMap;
    private final String networkCode;
    private final String order;
    private final String lineItem;

    @Deprecated
    protected LineItemName() {
        this.networkCode = null;
        this.order = null;
        this.lineItem = null;
    }

    private LineItemName(Builder builder) {
        this.networkCode = (String)Preconditions.checkNotNull((Object)builder.getNetworkCode());
        this.order = (String)Preconditions.checkNotNull((Object)builder.getOrder());
        this.lineItem = (String)Preconditions.checkNotNull((Object)builder.getLineItem());
    }

    public String getNetworkCode() {
        return this.networkCode;
    }

    public String getOrder() {
        return this.order;
    }

    public String getLineItem() {
        return this.lineItem;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static LineItemName of(String networkCode, String order, String lineItem) {
        return LineItemName.newBuilder().setNetworkCode(networkCode).setOrder(order).setLineItem(lineItem).build();
    }

    public static String format(String networkCode, String order, String lineItem) {
        return LineItemName.newBuilder().setNetworkCode(networkCode).setOrder(order).setLineItem(lineItem).build().toString();
    }

    public static LineItemName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = NETWORK_CODE_ORDER_LINE_ITEM.validatedMatch(formattedString, "LineItemName.parse: formattedString not in valid format");
        return LineItemName.of((String)matchMap.get("network_code"), (String)matchMap.get("order"), (String)matchMap.get("line_item"));
    }

    public static List<LineItemName> parseList(List<String> formattedStrings) {
        ArrayList<LineItemName> list = new ArrayList<LineItemName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(LineItemName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<LineItemName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (LineItemName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return NETWORK_CODE_ORDER_LINE_ITEM.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            LineItemName lineItemName = this;
            synchronized (lineItemName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.networkCode != null) {
                        fieldMapBuilder.put((Object)"network_code", (Object)this.networkCode);
                    }
                    if (this.order != null) {
                        fieldMapBuilder.put((Object)"order", (Object)this.order);
                    }
                    if (this.lineItem != null) {
                        fieldMapBuilder.put((Object)"line_item", (Object)this.lineItem);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return NETWORK_CODE_ORDER_LINE_ITEM.instantiate(new String[]{"network_code", this.networkCode, "order", this.order, "line_item", this.lineItem});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            LineItemName that = (LineItemName)o;
            return Objects.equals(this.networkCode, that.networkCode) && Objects.equals(this.order, that.order) && Objects.equals(this.lineItem, that.lineItem);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.networkCode);
        h *= 1000003;
        h ^= Objects.hashCode(this.order);
        h *= 1000003;
        return h ^= Objects.hashCode(this.lineItem);
    }

    public static class Builder {
        private String networkCode;
        private String order;
        private String lineItem;

        protected Builder() {
        }

        public String getNetworkCode() {
            return this.networkCode;
        }

        public String getOrder() {
            return this.order;
        }

        public String getLineItem() {
            return this.lineItem;
        }

        public Builder setNetworkCode(String networkCode) {
            this.networkCode = networkCode;
            return this;
        }

        public Builder setOrder(String order) {
            this.order = order;
            return this;
        }

        public Builder setLineItem(String lineItem) {
            this.lineItem = lineItem;
            return this;
        }

        private Builder(LineItemName lineItemName) {
            this.networkCode = lineItemName.networkCode;
            this.order = lineItemName.order;
            this.lineItem = lineItemName.lineItem;
        }

        public LineItemName build() {
            return new LineItemName(this);
        }
    }
}

