/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.admanager.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class LabelName
implements ResourceName {
    private static final PathTemplate NETWORK_CODE_LABEL = PathTemplate.createWithoutUrlEncoding((String)"networks/{network_code}/labels/{label}");
    private volatile Map<String, String> fieldValuesMap;
    private final String networkCode;
    private final String label;

    @Deprecated
    protected LabelName() {
        this.networkCode = null;
        this.label = null;
    }

    private LabelName(Builder builder) {
        this.networkCode = (String)Preconditions.checkNotNull((Object)builder.getNetworkCode());
        this.label = (String)Preconditions.checkNotNull((Object)builder.getLabel());
    }

    public String getNetworkCode() {
        return this.networkCode;
    }

    public String getLabel() {
        return this.label;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static LabelName of(String networkCode, String label) {
        return LabelName.newBuilder().setNetworkCode(networkCode).setLabel(label).build();
    }

    public static String format(String networkCode, String label) {
        return LabelName.newBuilder().setNetworkCode(networkCode).setLabel(label).build().toString();
    }

    public static LabelName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = NETWORK_CODE_LABEL.validatedMatch(formattedString, "LabelName.parse: formattedString not in valid format");
        return LabelName.of((String)matchMap.get("network_code"), (String)matchMap.get("label"));
    }

    public static List<LabelName> parseList(List<String> formattedStrings) {
        ArrayList<LabelName> list = new ArrayList<LabelName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(LabelName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<LabelName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (LabelName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return NETWORK_CODE_LABEL.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            LabelName labelName = this;
            synchronized (labelName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.networkCode != null) {
                        fieldMapBuilder.put((Object)"network_code", (Object)this.networkCode);
                    }
                    if (this.label != null) {
                        fieldMapBuilder.put((Object)"label", (Object)this.label);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return NETWORK_CODE_LABEL.instantiate(new String[]{"network_code", this.networkCode, "label", this.label});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            LabelName that = (LabelName)o;
            return Objects.equals(this.networkCode, that.networkCode) && Objects.equals(this.label, that.label);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.networkCode);
        h *= 1000003;
        return h ^= Objects.hashCode(this.label);
    }

    public static class Builder {
        private String networkCode;
        private String label;

        protected Builder() {
        }

        public String getNetworkCode() {
            return this.networkCode;
        }

        public String getLabel() {
            return this.label;
        }

        public Builder setNetworkCode(String networkCode) {
            this.networkCode = networkCode;
            return this;
        }

        public Builder setLabel(String label) {
            this.label = label;
            return this;
        }

        private Builder(LabelName labelName) {
            this.networkCode = labelName.networkCode;
            this.label = labelName.label;
        }

        public LabelName build() {
            return new LabelName(this);
        }
    }
}

