/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.admanager.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class CustomFieldName
implements ResourceName {
    private static final PathTemplate NETWORK_CODE_CUSTOM_FIELD = PathTemplate.createWithoutUrlEncoding((String)"networks/{network_code}/customFields/{custom_field}");
    private volatile Map<String, String> fieldValuesMap;
    private final String networkCode;
    private final String customField;

    @Deprecated
    protected CustomFieldName() {
        this.networkCode = null;
        this.customField = null;
    }

    private CustomFieldName(Builder builder) {
        this.networkCode = (String)Preconditions.checkNotNull((Object)builder.getNetworkCode());
        this.customField = (String)Preconditions.checkNotNull((Object)builder.getCustomField());
    }

    public String getNetworkCode() {
        return this.networkCode;
    }

    public String getCustomField() {
        return this.customField;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static CustomFieldName of(String networkCode, String customField) {
        return CustomFieldName.newBuilder().setNetworkCode(networkCode).setCustomField(customField).build();
    }

    public static String format(String networkCode, String customField) {
        return CustomFieldName.newBuilder().setNetworkCode(networkCode).setCustomField(customField).build().toString();
    }

    public static CustomFieldName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = NETWORK_CODE_CUSTOM_FIELD.validatedMatch(formattedString, "CustomFieldName.parse: formattedString not in valid format");
        return CustomFieldName.of((String)matchMap.get("network_code"), (String)matchMap.get("custom_field"));
    }

    public static List<CustomFieldName> parseList(List<String> formattedStrings) {
        ArrayList<CustomFieldName> list = new ArrayList<CustomFieldName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(CustomFieldName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<CustomFieldName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (CustomFieldName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return NETWORK_CODE_CUSTOM_FIELD.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            CustomFieldName customFieldName = this;
            synchronized (customFieldName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.networkCode != null) {
                        fieldMapBuilder.put((Object)"network_code", (Object)this.networkCode);
                    }
                    if (this.customField != null) {
                        fieldMapBuilder.put((Object)"custom_field", (Object)this.customField);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return NETWORK_CODE_CUSTOM_FIELD.instantiate(new String[]{"network_code", this.networkCode, "custom_field", this.customField});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            CustomFieldName that = (CustomFieldName)o;
            return Objects.equals(this.networkCode, that.networkCode) && Objects.equals(this.customField, that.customField);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.networkCode);
        h *= 1000003;
        return h ^= Objects.hashCode(this.customField);
    }

    public static class Builder {
        private String networkCode;
        private String customField;

        protected Builder() {
        }

        public String getNetworkCode() {
            return this.networkCode;
        }

        public String getCustomField() {
            return this.customField;
        }

        public Builder setNetworkCode(String networkCode) {
            this.networkCode = networkCode;
            return this;
        }

        public Builder setCustomField(String customField) {
            this.customField = customField;
            return this;
        }

        private Builder(CustomFieldName customFieldName) {
            this.networkCode = customFieldName.networkCode;
            this.customField = customFieldName.customField;
        }

        public CustomFieldName build() {
            return new CustomFieldName(this);
        }
    }
}

