/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.ads.adwords.axis.utils.v201708.shopping;

import com.google.api.ads.adwords.axis.utils.v201708.shopping.ProductPartitionNode;
import com.google.api.ads.adwords.axis.v201708.cm.AdGroupCriterion;
import com.google.api.ads.adwords.axis.v201708.cm.BidSource;
import com.google.api.ads.adwords.axis.v201708.cm.BiddableAdGroupCriterion;
import com.google.api.ads.adwords.axis.v201708.cm.BiddingStrategyConfiguration;
import com.google.api.ads.adwords.axis.v201708.cm.Bids;
import com.google.api.ads.adwords.axis.v201708.cm.CpcBid;
import com.google.api.ads.adwords.axis.v201708.cm.Money;
import com.google.api.ads.adwords.axis.v201708.cm.NegativeAdGroupCriterion;
import com.google.api.ads.adwords.axis.v201708.cm.ProductPartition;
import com.google.api.ads.adwords.axis.v201708.cm.ProductPartitionType;
import com.google.common.base.Preconditions;

class ProductPartitionNodeAdapter {
    private ProductPartitionNodeAdapter() {
    }

    static AdGroupCriterion createCriterionForRemove(ProductPartitionNode node, long adGroupId) {
        Preconditions.checkNotNull((Object)node, (Object)"Null node");
        AdGroupCriterion adGroupCriterion = new AdGroupCriterion();
        adGroupCriterion.setAdGroupId(adGroupId);
        adGroupCriterion.setCriterion(new ProductPartition());
        adGroupCriterion.getCriterion().setId(node.getProductPartitionId());
        return adGroupCriterion;
    }

    static AdGroupCriterion createCriterionForAdd(ProductPartitionNode node, long adGroupId, BiddingStrategyConfiguration biddingConfig) {
        AdGroupCriterion adGroupCriterion;
        Preconditions.checkNotNull((Object)node, (Object)"Null node");
        Preconditions.checkNotNull((Object)biddingConfig, (Object)"Null bidding configuration");
        if (node.isExcludedUnit()) {
            adGroupCriterion = new NegativeAdGroupCriterion();
        } else {
            adGroupCriterion = new BiddableAdGroupCriterion();
            if (node.isUnit() && node.getBid() != null) {
                Money bidMoney = new Money();
                bidMoney.setMicroAmount(node.getBid());
                CpcBid cpcBid = new CpcBid();
                cpcBid.setBid(bidMoney);
                cpcBid.setCpcBidSource(BidSource.CRITERION);
                biddingConfig.setBids(new Bids[]{cpcBid});
                ((BiddableAdGroupCriterion)adGroupCriterion).setBiddingStrategyConfiguration(biddingConfig);
            }
        }
        adGroupCriterion.setAdGroupId(adGroupId);
        ProductPartition partition = new ProductPartition();
        partition.setId(node.getProductPartitionId());
        if (node.getParent() != null) {
            partition.setParentCriterionId(node.getParent().getProductPartitionId());
        }
        partition.setCaseValue(node.getDimension());
        partition.setPartitionType(node.isUnit() ? ProductPartitionType.UNIT : ProductPartitionType.SUBDIVISION);
        adGroupCriterion.setCriterion(partition);
        return adGroupCriterion;
    }

    static AdGroupCriterion createCriterionForSetBid(ProductPartitionNode node, long adGroupId, BiddingStrategyConfiguration biddingConfig) {
        Preconditions.checkNotNull((Object)node, (Object)"Null node");
        Preconditions.checkNotNull((Object)biddingConfig, (Object)"Null bidding configuration");
        Preconditions.checkArgument((boolean)node.isBiddableUnit(), (Object)"Node is not a biddable unit");
        BiddableAdGroupCriterion biddableCriterion = new BiddableAdGroupCriterion();
        biddableCriterion.setAdGroupId(adGroupId);
        ProductPartition partition = new ProductPartition();
        partition.setId(node.getProductPartitionId());
        if (node.getParent() != null) {
            partition.setParentCriterionId(node.getParent().getProductPartitionId());
        }
        partition.setCaseValue(node.getDimension());
        partition.setPartitionType(ProductPartitionType.UNIT);
        biddableCriterion.setCriterion(partition);
        if (node.getBid() != null) {
            Money bidMoney = new Money();
            bidMoney.setMicroAmount(node.getBid());
            CpcBid cpcBid = new CpcBid();
            cpcBid.setBid(bidMoney);
            biddingConfig.setBids(new Bids[]{cpcBid});
        } else {
            biddingConfig.setBids(new Bids[0]);
        }
        biddableCriterion.setBiddingStrategyConfiguration(biddingConfig);
        return biddableCriterion;
    }
}

