/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.ads.adwords.axis;

import com.google.api.ads.adwords.lib.client.AdWordsServiceDescriptor;
import com.google.api.ads.common.lib.soap.axis.AxisSoapHeaderFactory;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Map;
import javax.inject.Inject;

public class AdWordsAxisSoapHeaderFactory
implements AxisSoapHeaderFactory<AdWordsServiceDescriptor> {
    private final Map<AdWordsServiceDescriptor.AdWordsSubProduct, String> subProductHeaderNameMap;

    @Inject
    public AdWordsAxisSoapHeaderFactory(Map<AdWordsServiceDescriptor.AdWordsSubProduct, String> subProductHeaderNameMap) {
        this.subProductHeaderNameMap = subProductHeaderNameMap;
    }

    public Object createSoapHeader(AdWordsServiceDescriptor adWordsServiceDescriptor) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        Class interfaceClass = adWordsServiceDescriptor.getInterfaceClass();
        String packageName = interfaceClass.getPackage().getName();
        ArrayList packageParts = Lists.newArrayList((Object[])packageName.split("\\."));
        String parentPackage = Joiner.on((String)".").join(packageParts.subList(0, packageParts.size() - 1));
        String headerName = this.subProductHeaderNameMap.get(adWordsServiceDescriptor.getSubProduct());
        return Class.forName(parentPackage + "." + headerName).newInstance();
    }
}

