/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.ads.adwords.axis;

import com.google.api.ads.adwords.lib.client.AdWordsServiceDescriptor;
import com.google.api.ads.adwords.lib.client.AdWordsSession;
import com.google.api.ads.adwords.lib.conf.AdWordsApiConfiguration;
import com.google.api.ads.common.lib.client.AdsServiceDescriptor;
import com.google.api.ads.common.lib.client.AdsSession;
import com.google.api.ads.common.lib.client.HeaderHandler;
import com.google.api.ads.common.lib.conf.AdsLibConfiguration;
import com.google.api.ads.common.lib.exception.AuthenticationException;
import com.google.api.ads.common.lib.exception.ServiceException;
import com.google.api.ads.common.lib.soap.AuthorizationHeaderHandler;
import com.google.api.ads.common.lib.soap.axis.AxisHandler;
import com.google.api.ads.common.lib.soap.axis.AxisSoapHeaderFactory;
import com.google.api.ads.common.lib.useragent.UserAgentCombiner;
import com.google.common.base.Preconditions;
import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import javax.inject.Inject;
import org.apache.axis.client.Stub;

public class AdWordsAxisHeaderHandler
implements HeaderHandler<AdWordsSession, AdWordsServiceDescriptor> {
    private final AxisHandler soapClientHandler;
    private final AdWordsApiConfiguration adWordsApiConfiguration;
    private final AdsLibConfiguration adsLibConfiguration;
    private final AuthorizationHeaderHandler authorizationHeaderHandler;
    private final UserAgentCombiner userAgentCombiner;
    private final Map<AdWordsServiceDescriptor.AdWordsSubProduct, HeaderHandler<AdWordsSession, AdWordsServiceDescriptor>> subProductHeaderHandlerMap;
    private final AxisSoapHeaderFactory<AdWordsServiceDescriptor> soapHeaderFactory;
    static final String REQUEST_HEADER_LOCAL_PART = "RequestHeader";

    @Inject
    AdWordsAxisHeaderHandler(AxisHandler soapClientHandler, AdWordsApiConfiguration adWordsApiConfiguration, AdsLibConfiguration adsLibConfiguration, AuthorizationHeaderHandler authorizationHeaderHandler, UserAgentCombiner userAgentCombiner, Map<AdWordsServiceDescriptor.AdWordsSubProduct, HeaderHandler<AdWordsSession, AdWordsServiceDescriptor>> subProductHeaderHandlerMap, AxisSoapHeaderFactory<AdWordsServiceDescriptor> soapHeaderFactory) {
        this.soapClientHandler = soapClientHandler;
        this.adWordsApiConfiguration = adWordsApiConfiguration;
        this.adsLibConfiguration = adsLibConfiguration;
        this.authorizationHeaderHandler = authorizationHeaderHandler;
        this.userAgentCombiner = userAgentCombiner;
        this.subProductHeaderHandlerMap = subProductHeaderHandlerMap;
        this.soapHeaderFactory = soapHeaderFactory;
    }

    public void setHeaders(Object soapClient, AdWordsSession adWordsSession, AdWordsServiceDescriptor adWordsServiceDescriptor) throws AuthenticationException, ServiceException {
        try {
            Preconditions.checkArgument((boolean)(soapClient instanceof Stub), (String)"soapClient must be Stub but was: %s", (Object)soapClient);
            Stub stub = (Stub)soapClient;
            Object soapHeader = this.soapHeaderFactory.createSoapHeader((AdsServiceDescriptor)adWordsServiceDescriptor);
            String namespace = this.adWordsApiConfiguration.getNamespacePrefix() + "/" + adWordsServiceDescriptor.getPackageGroup() + "/" + adWordsServiceDescriptor.getVersion();
            this.soapClientHandler.setHeader(stub, namespace, REQUEST_HEADER_LOCAL_PART, soapHeader);
            this.soapClientHandler.setHeaderChild(stub, REQUEST_HEADER_LOCAL_PART, "developerToken", (Object)adWordsSession.getDeveloperToken());
            this.soapClientHandler.setHeaderChild(stub, REQUEST_HEADER_LOCAL_PART, "clientCustomerId", (Object)adWordsSession.getClientCustomerId());
            this.soapClientHandler.setHeaderChild(stub, REQUEST_HEADER_LOCAL_PART, "userAgent", (Object)this.userAgentCombiner.getUserAgent(adWordsSession.getUserAgent()));
            this.soapClientHandler.setHeaderChild(stub, REQUEST_HEADER_LOCAL_PART, "validateOnly", (Object)adWordsSession.isValidateOnly());
            this.soapClientHandler.setHeaderChild(stub, REQUEST_HEADER_LOCAL_PART, "partialFailure", (Object)adWordsSession.isPartialFailure());
            this.soapClientHandler.setCompression(stub, this.adsLibConfiguration.isCompressionEnabled());
            this.soapClientHandler.setRequestTimeout(stub, this.adsLibConfiguration.getSoapRequestTimeout());
            HeaderHandler<AdWordsSession, AdWordsServiceDescriptor> subProductHandler = this.subProductHeaderHandlerMap.get(adWordsServiceDescriptor.getSubProduct());
            subProductHandler.setHeaders(soapClient, (AdsSession)adWordsSession, (AdsServiceDescriptor)adWordsServiceDescriptor);
            this.setAuthenticationHeaders(soapClient, adWordsSession);
        }
        catch (InstantiationException e) {
            throw new ServiceException("Unexpected exception.", (Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new ServiceException("Unexpected exception.", (Throwable)e);
        }
        catch (ClassNotFoundException e) {
            throw new ServiceException("Unexpected exception.", (Throwable)e);
        }
        catch (InvocationTargetException e) {
            throw new ServiceException("Unexpected exception.", (Throwable)e);
        }
    }

    private void setAuthenticationHeaders(Object soapClient, AdWordsSession adWordsSession) throws IllegalAccessException, InvocationTargetException, AuthenticationException {
        this.authorizationHeaderHandler.setAuthorization(soapClient, (AdsSession)adWordsSession);
    }
}

