/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.ads.adwords.axis;

import com.google.api.ads.adwords.lib.client.AdWordsServiceDescriptor;
import com.google.api.ads.adwords.lib.client.AdWordsSession;
import com.google.api.ads.common.lib.client.HeaderHandler;
import com.google.api.ads.common.lib.exception.AuthenticationException;
import com.google.api.ads.common.lib.exception.ServiceException;
import com.google.api.ads.common.lib.soap.axis.AxisHandler;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import javax.inject.Inject;
import org.apache.axis.client.Stub;

public class AdWordsAxisExpressHeaderHandler
implements HeaderHandler<AdWordsSession, AdWordsServiceDescriptor> {
    private final AxisHandler axisHandler;
    @VisibleForTesting
    static final String EXPRESS_BUSINESS_ID_LOCAL_PART = "expressBusinessId";
    @VisibleForTesting
    static final String PLUS_PAGE_ID_LOCAL_PART = "pageId";

    @Inject
    public AdWordsAxisExpressHeaderHandler(AxisHandler axisHandler) {
        this.axisHandler = axisHandler;
    }

    public void setHeaders(Object soapClient, AdWordsSession adWordsSession, AdWordsServiceDescriptor adWordsServiceDescriptor) throws ServiceException, AuthenticationException {
        if (adWordsSession.getExpressBusinessId() != null || adWordsSession.getExpressPlusPageId() != null) {
            Preconditions.checkArgument((adWordsSession.getExpressBusinessId() == null || adWordsSession.getExpressPlusPageId() == null ? 1 : 0) != 0, (Object)"Both expressBusinessId and expressPlusPageId are not null. Please set expressBusinessId, expressPlusPageId or neither, but not both.");
            Preconditions.checkArgument((boolean)(soapClient instanceof Stub), (String)"soapClient must be Stub but was: %s", (Object)soapClient);
            Stub stub = (Stub)soapClient;
            if (adWordsSession.getExpressPlusPageId() != null) {
                this.axisHandler.setHeaderChild(stub, "RequestHeader", PLUS_PAGE_ID_LOCAL_PART, (Object)adWordsSession.getExpressPlusPageId());
            } else {
                this.axisHandler.setHeaderChild(stub, "RequestHeader", EXPRESS_BUSINESS_ID_LOCAL_PART, (Object)adWordsSession.getExpressBusinessId());
            }
        }
    }
}

