/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.ads.adwords.axis.utils.v201601.shopping;

import com.google.api.ads.adwords.axis.v201601.cm.ProductDimension;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Map;
import java.util.SortedMap;
import javax.annotation.Nullable;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.lang.SerializationUtils;
import org.apache.commons.lang.SystemUtils;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;

public class ProductPartitionNode {
    @Nullable
    private final ProductPartitionNode parentNode;
    @Nullable
    private final ProductDimension dimension;
    @Nullable
    private Long partitionId;
    private NodeState nodeState;
    private final SortedMap<ProductDimension, ProductPartitionNode> children;
    private static final ImmutableList<String> DIMENSION_PROPERTY_NAMES = ImmutableList.of((Object)"type", (Object)"condition", (Object)"value", (Object)"channel", (Object)"channelExclusivity");

    ProductPartitionNode(@Nullable ProductPartitionNode parentNode, @Nullable ProductDimension dimension, @Nullable Long partitionId, Comparator<? super ProductDimension> comparator) {
        this.parentNode = parentNode;
        this.dimension = dimension;
        this.children = Maps.newTreeMap(comparator);
        this.partitionId = partitionId;
        this.nodeState = new BiddableUnitState();
    }

    static ProductPartitionNode copyProperties(ProductPartitionNode fromNode, ProductPartitionNode toNode) {
        switch (fromNode.nodeState.getNodeType()) {
            case BIDDABLE_UNIT: {
                toNode = toNode.asBiddableUnit();
                toNode.setBid(fromNode.getBid());
                break;
            }
            case EXCLUDED_UNIT: {
                toNode = toNode.asExcludedUnit();
                break;
            }
            case SUBDIVISION: {
                toNode = toNode.asSubdivision();
                break;
            }
            default: {
                throw new IllegalStateException("Unrecognized node state: " + (Object)((Object)fromNode.nodeState.getNodeType()));
            }
        }
        return toNode.setProductPartitionId(fromNode.getProductPartitionId());
    }

    public ProductDimension getDimension() {
        return (ProductDimension)SerializationUtils.clone((Serializable)this.dimension);
    }

    @Nullable
    public Long getProductPartitionId() {
        return this.partitionId;
    }

    ProductPartitionNode setProductPartitionId(Long partitionId) {
        this.partitionId = partitionId;
        return this;
    }

    public boolean isSubdivision() {
        return this.nodeState.getNodeType() == NodeType.SUBDIVISION;
    }

    public boolean isUnit() {
        return this.nodeState.getNodeType() == NodeType.BIDDABLE_UNIT || this.nodeState.getNodeType() == NodeType.EXCLUDED_UNIT;
    }

    public ProductPartitionNode asSubdivision() {
        this.nodeState = this.nodeState.transitionTo(NodeType.SUBDIVISION);
        return this;
    }

    public Iterable<ProductPartitionNode> getChildren() {
        return ImmutableList.copyOf(this.children.values());
    }

    public ProductPartitionNode getChild(ProductDimension dimension) {
        Preconditions.checkArgument((boolean)this.hasChild(dimension), (String)"No child exists with dimension: %s", (Object[])new Object[]{ProductPartitionNode.toString(dimension)});
        return (ProductPartitionNode)this.children.get(dimension);
    }

    public boolean hasChild(ProductDimension dimension) {
        return this.children.containsKey(dimension);
    }

    private boolean hasChildren() {
        return !this.children.isEmpty();
    }

    @Nullable
    public Long getBid() {
        return this.nodeState.getBidInMicros();
    }

    public boolean isBiddableUnit() {
        return this.nodeState.getNodeType() == NodeType.BIDDABLE_UNIT;
    }

    public boolean isExcludedUnit() {
        return this.nodeState.getNodeType() == NodeType.EXCLUDED_UNIT;
    }

    public String toString() {
        Long parentPartitionId = this.getParent() != null ? this.getParent().getProductPartitionId() : null;
        return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append("dimension", (Object)ProductPartitionNode.toString(this.dimension)).append("partitionId", (Object)this.partitionId).append("parentPartitionId", (Object)parentPartitionId).append("nodeType", (Object)this.nodeState.getNodeType()).append("bidMicros", (Object)this.nodeState.getBidInMicros()).append("hasChildren", this.hasChildren()).toString();
    }

    public String toDetailedString() {
        StringBuilder stringBuilder = new StringBuilder();
        this.appendDetailedString(0, stringBuilder);
        return stringBuilder.toString();
    }

    private void appendDetailedString(int level, StringBuilder stringBuilder) {
        String pad = Strings.repeat((String)"--", (int)level);
        stringBuilder.append(pad).append(this).append(SystemUtils.LINE_SEPARATOR);
        for (ProductPartitionNode childNode : this.getChildren()) {
            childNode.appendDetailedString(level + 1, stringBuilder);
        }
    }

    public static String toString(ProductDimension dimension) {
        if (dimension == null) {
            return String.valueOf(dimension);
        }
        ArrayList attributeToStrings = Lists.newArrayList();
        try {
            Map propertiesMap = BeanUtils.describe((Object)dimension);
            for (String propertyName : DIMENSION_PROPERTY_NAMES) {
                if (!propertiesMap.containsKey(propertyName)) continue;
                attributeToStrings.add(String.format("%s=%s", propertyName, BeanUtils.getProperty((Object)dimension, (String)propertyName)));
            }
        }
        catch (Exception e) {
            attributeToStrings.add("--UNKNOWN--");
        }
        return String.format("%s[%s]", dimension.getClass().getSimpleName(), Joiner.on((char)',').join((Iterable)attributeToStrings));
    }

    public ProductPartitionNode getParent() {
        return this.parentNode;
    }

    public ProductPartitionNode addChild(ProductDimension childDimension) {
        ProductPartitionNode newChild = new ProductPartitionNode(this, childDimension, null, this.children.comparator());
        Preconditions.checkArgument((boolean)this.isSubdivision(), (Object)"Parent node is not a SUBDIVISION. Call asSubdivision before adding children to a node.");
        if (this.children.containsKey(childDimension)) {
            throw new IllegalArgumentException(String.format("A child with dimension %s already exists", ProductPartitionNode.toString(childDimension)));
        }
        this.children.put(childDimension, newChild);
        return newChild;
    }

    public ProductPartitionNode removeChild(ProductDimension childDimension) {
        if (!this.children.containsKey(childDimension)) {
            throw new IllegalArgumentException(String.format("Attempted to remove child %s but no such child exists", ProductPartitionNode.toString(childDimension)));
        }
        this.children.remove(childDimension);
        return this;
    }

    public ProductPartitionNode removeAllChildren() {
        this.children.clear();
        return this;
    }

    public ProductPartitionNode asExcludedUnit() {
        if (this.getParent() == null) {
            throw new IllegalStateException("The root node cannot be an excluded unit");
        }
        this.nodeState = this.nodeState.transitionTo(NodeType.EXCLUDED_UNIT);
        this.removeAllChildren();
        return this;
    }

    public ProductPartitionNode asBiddableUnit() {
        this.nodeState = this.nodeState.transitionTo(NodeType.BIDDABLE_UNIT);
        this.removeAllChildren();
        return this;
    }

    public ProductPartitionNode setBid(@Nullable Long bidInMicros) {
        this.nodeState.setBidInMicros(bidInMicros);
        return this;
    }

    private static class BiddableUnitState
    extends NodeState {
        private Long bidInMicros;

        private BiddableUnitState() {
        }

        @Override
        Long getBidInMicros() {
            return this.bidInMicros;
        }

        @Override
        void setBidInMicros(Long bidInMicros) {
            Preconditions.checkArgument((bidInMicros == null || bidInMicros > 0L ? 1 : 0) != 0, (String)"Invalid bid: %s. Bid must be null or > 0.", (Object[])new Object[]{bidInMicros});
            this.bidInMicros = bidInMicros;
        }

        @Override
        NodeType getNodeType() {
            return NodeType.BIDDABLE_UNIT;
        }
    }

    private static class ExcludedUnitState
    extends NodeState {
        private ExcludedUnitState() {
        }

        @Override
        NodeType getNodeType() {
            return NodeType.EXCLUDED_UNIT;
        }
    }

    private static class SubdivisionState
    extends NodeState {
        private SubdivisionState() {
        }

        @Override
        NodeType getNodeType() {
            return NodeType.SUBDIVISION;
        }
    }

    private static abstract class NodeState {
        private NodeState() {
        }

        abstract NodeType getNodeType();

        @Nullable
        Long getBidInMicros() {
            return null;
        }

        void setBidInMicros(@Nullable Long bidInMicros) {
            throw new IllegalStateException(String.format("Cannot set bid on a %s node", new Object[]{this.getNodeType()}));
        }

        NodeState transitionTo(NodeType nodeType) {
            Preconditions.checkNotNull((Object)((Object)nodeType), (Object)"Null node type");
            if (nodeType == this.getNodeType()) {
                return this;
            }
            switch (nodeType) {
                case BIDDABLE_UNIT: {
                    return new BiddableUnitState();
                }
                case EXCLUDED_UNIT: {
                    return new ExcludedUnitState();
                }
                case SUBDIVISION: {
                    return new SubdivisionState();
                }
            }
            throw new IllegalArgumentException("Unrecognized node type: " + (Object)((Object)nodeType));
        }
    }

    private static enum NodeType {
        BIDDABLE_UNIT,
        EXCLUDED_UNIT,
        SUBDIVISION;

    }
}

