/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.ads.adwords.axis.utils;

import com.google.api.ads.adwords.lib.utils.BatchJobMutateResultInterface;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.io.ByteSource;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.rpc.encoding.DeserializerFactory;
import javax.xml.rpc.encoding.SerializerFactory;
import javax.xml.rpc.encoding.TypeMapping;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.axis.AxisEngine;
import org.apache.axis.MessageContext;
import org.apache.axis.encoding.DeserializationContext;
import org.apache.axis.encoding.TypeMappingRegistry;
import org.apache.axis.encoding.TypeMappingRegistryImpl;
import org.apache.axis.encoding.ser.BaseDeserializerFactory;
import org.apache.axis.encoding.ser.BaseSerializerFactory;
import org.apache.axis.encoding.ser.BeanDeserializerFactory;
import org.apache.axis.encoding.ser.BeanSerializerFactory;
import org.apache.axis.message.MessageElement;
import org.apache.axis.message.SOAPBodyElement;
import org.apache.axis.message.SOAPEnvelope;
import org.apache.axis.server.AxisServer;
import org.xml.sax.InputSource;

public class AxisDeserializer {
    private static final String SOAP_START_BODY = "<soapenv:Envelope xmlns:soapenv=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><soapenv:Body>";
    private static final String SOAP_END_BODY = "</soapenv:Body></soapenv:Envelope>";
    private static final String INDENT_AMOUNT = "4";

    public <OperandT, ApiErrorT, ResultT extends BatchJobMutateResultInterface<OperandT, ApiErrorT>> List<ResultT> deserializeBatchJobMutateResults(URL url, List<org.apache.axis.encoding.TypeMapping> serviceTypeMappings, Class<ResultT> resultClass, QName resultQName, Class<OperandT> operandClass, QName operandQName) throws Exception {
        ArrayList results = Lists.newArrayList();
        InputStream wrappedStream = this.buildWrappedInputStream(url.openStream());
        DeserializationContext deserializationContext = new DeserializationContext(new InputSource(wrappedStream), new MessageContext((AxisEngine)new AxisServer()), "response");
        TypeMappingRegistry mappingRegistry = this.addTypeMappingDelegates(deserializationContext.getTypeMappingRegistry(), serviceTypeMappings);
        mappingRegistry = this.addTypeMappingDelegate(mappingRegistry, operandClass, operandQName, deserializationContext.getEncodingStyle());
        deserializationContext.parse();
        SOAPEnvelope envelope = deserializationContext.getEnvelope();
        SOAPBodyElement body = envelope.getFirstBody();
        Iterator iter = body.getChildElements();
        while (iter.hasNext()) {
            Object child = iter.next();
            MessageElement childElm = (MessageElement)child;
            BatchJobMutateResultInterface mutateResult = (BatchJobMutateResultInterface)childElm.getValueAsType(resultQName, resultClass);
            results.add(mutateResult);
        }
        return results;
    }

    private InputStream buildWrappedInputStream(InputStream downloadInputStream) throws TransformerException, IOException {
        Transformer omitXmlDeclarationTransformer = TransformerFactory.newInstance().newTransformer();
        omitXmlDeclarationTransformer.setOutputProperty("indent", "yes");
        omitXmlDeclarationTransformer.setOutputProperty("omit-xml-declaration", "yes");
        omitXmlDeclarationTransformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", INDENT_AMOUNT);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        StreamResult streamResult = new StreamResult(outputStream);
        StreamSource xmlSource = new StreamSource(downloadInputStream);
        omitXmlDeclarationTransformer.transform(xmlSource, streamResult);
        return ByteSource.concat((ByteSource[])new ByteSource[]{ByteSource.wrap((byte[])SOAP_START_BODY.getBytes()), ByteSource.wrap((byte[])outputStream.toByteArray()), ByteSource.wrap((byte[])SOAP_END_BODY.getBytes())}).openStream();
    }

    private TypeMappingRegistry addTypeMappingDelegates(TypeMappingRegistry startingRegistry, List<org.apache.axis.encoding.TypeMapping> typeMappings) {
        Preconditions.checkNotNull(typeMappings, (Object)"Null type mappings");
        Preconditions.checkArgument((!typeMappings.isEmpty() ? 1 : 0) != 0, (Object)"Empty type mappings");
        TypeMappingRegistry lastRegistry = (TypeMappingRegistry)Preconditions.checkNotNull((Object)startingRegistry, (Object)"Null starting registry");
        for (org.apache.axis.encoding.TypeMapping typeMapping : typeMappings) {
            TypeMappingRegistryImpl typeMappingReg = new TypeMappingRegistryImpl(false);
            typeMappingReg.registerDefault((TypeMapping)typeMapping);
            lastRegistry.delegate((TypeMappingRegistry)typeMappingReg);
            lastRegistry = typeMappingReg;
        }
        return lastRegistry;
    }

    private TypeMappingRegistry addTypeMappingDelegate(TypeMappingRegistry prevRegistry, Class<?> clazz, QName qname, String encodingStyle) {
        Preconditions.checkNotNull(clazz, (Object)"Null class");
        Preconditions.checkNotNull((Object)qname, (Object)"Null qname");
        TypeMappingRegistryImpl newRegistry = new TypeMappingRegistryImpl(false);
        org.apache.axis.encoding.TypeMapping typeMapping = newRegistry.getOrMakeTypeMapping(encodingStyle);
        typeMapping.register(clazz, qname, (SerializerFactory)BaseSerializerFactory.createFactory(BeanSerializerFactory.class, clazz, (QName)qname), (DeserializerFactory)BaseDeserializerFactory.createFactory(BeanDeserializerFactory.class, clazz, (QName)qname));
        newRegistry.registerDefault((TypeMapping)typeMapping);
        Preconditions.checkState((boolean)newRegistry.getOrMakeTypeMapping(encodingStyle).isRegistered(clazz, qname), (String)"Class %s and QName %s failed to register", (Object[])new Object[]{clazz, qname});
        prevRegistry.delegate((TypeMappingRegistry)newRegistry);
        return newRegistry;
    }
}

