/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.ads.adwords.axis;

import com.google.api.ads.adwords.lib.client.AdWordsServiceDescriptor;
import com.google.api.ads.adwords.lib.client.AdWordsSession;
import com.google.api.ads.adwords.lib.conf.AdWordsApiConfiguration;
import com.google.api.ads.common.lib.client.AdsSession;
import com.google.api.ads.common.lib.client.HeaderHandler;
import com.google.api.ads.common.lib.exception.AuthenticationException;
import com.google.api.ads.common.lib.exception.ServiceException;
import com.google.api.ads.common.lib.soap.AuthorizationHeaderHandler;
import com.google.api.ads.common.lib.soap.SoapClientHandlerInterface;
import com.google.api.ads.common.lib.useragent.UserAgentCombiner;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.inject.Inject;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import org.apache.commons.beanutils.BeanUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AdWordsAxisHeaderHandler
implements HeaderHandler<AdWordsSession, AdWordsServiceDescriptor> {
    private final SoapClientHandlerInterface<Object> soapClientHandler;
    private final AdWordsApiConfiguration adWordsApiConfiguration;
    private final AuthorizationHeaderHandler authorizationHeaderHandler;
    private final UserAgentCombiner userAgentCombiner;

    @Inject
    public AdWordsAxisHeaderHandler(SoapClientHandlerInterface soapClientHandler, AdWordsApiConfiguration adWordsApiConfiguration, AuthorizationHeaderHandler authorizationHeaderHandler, UserAgentCombiner userAgentCombiner) {
        this.soapClientHandler = soapClientHandler;
        this.adWordsApiConfiguration = adWordsApiConfiguration;
        this.authorizationHeaderHandler = authorizationHeaderHandler;
        this.userAgentCombiner = userAgentCombiner;
    }

    public void setHeaders(Object soapClient, AdWordsSession adWordsSession, AdWordsServiceDescriptor adWordsServiceDescriptor) throws AuthenticationException, ServiceException {
        try {
            Object soapHeader = this.createSoapHeader(adWordsServiceDescriptor);
            BeanUtils.setProperty((Object)soapHeader, (String)"developerToken", (Object)adWordsSession.getDeveloperToken());
            BeanUtils.setProperty((Object)soapHeader, (String)"clientCustomerId", (Object)adWordsSession.getClientCustomerId());
            BeanUtils.setProperty((Object)soapHeader, (String)"userAgent", (Object)this.userAgentCombiner.getUserAgent(adWordsSession.getUserAgent()));
            BeanUtils.setProperty((Object)soapHeader, (String)"validateOnly", (Object)adWordsSession.isValidateOnly());
            BeanUtils.setProperty((Object)soapHeader, (String)"partialFailure", (Object)adWordsSession.isPartialFailure());
            this.setAuthenticationHeaders(soapClient, soapHeader, adWordsSession);
            String namespace = String.valueOf(this.adWordsApiConfiguration.getNamespacePrefix()) + "/" + adWordsServiceDescriptor.getPackageGroup() + "/" + adWordsServiceDescriptor.getVersion();
            this.soapClientHandler.setHeader(soapClient, namespace, "RequestHeader", soapHeader);
        }
        catch (InstantiationException e) {
            throw new ServiceException("Unexpected exception.", (Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new ServiceException("Unexpected exception.", (Throwable)e);
        }
        catch (ClassNotFoundException e) {
            throw new ServiceException("Unexpected exception.", (Throwable)e);
        }
        catch (InvocationTargetException e) {
            throw new ServiceException("Unexpected exception.", (Throwable)e);
        }
    }

    @VisibleForTesting
    void setAuthenticationHeaders(Object soapClient, Object soapHeader, AdWordsSession adWordsSession) throws IllegalAccessException, InvocationTargetException, AuthenticationException {
        if (adWordsSession.getClientLoginToken() != null) {
            BeanUtils.setProperty((Object)soapHeader, (String)"authToken", (Object)adWordsSession.getClientLoginToken());
        } else {
            this.authorizationHeaderHandler.setAuthorization(soapClient, (AdsSession)adWordsSession);
        }
    }

    @VisibleForTesting
    Object createSoapHeader(AdWordsServiceDescriptor adsServiceDescriptor) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        Class interfaceClass = adsServiceDescriptor.getInterfaceClass();
        String packageName = interfaceClass.getPackage().getName();
        ArrayList packageParts = Lists.newArrayList((Object[])packageName.split("\\."));
        String parentPackage = Joiner.on((String)".").join(packageParts.subList(0, packageParts.size() - 1));
        return Class.forName(String.valueOf(parentPackage) + ".cm.SoapHeader").newInstance();
    }
}

