/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.ads.adwords.lib.utils.v201809;

import com.google.api.ads.adwords.lib.utils.AdWordsInternals;
import com.google.api.ads.adwords.lib.utils.ReportQueryInterface;
import com.google.api.ads.adwords.lib.utils.v201809.ReportQueryBuilderImpl;
import com.google.api.ads.common.lib.utils.AdsUtilityInvocationHandler;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.reflect.Reflection;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.lang.reflect.InvocationHandler;
import org.joda.time.LocalDate;

public class ReportQuery
implements ReportQueryInterface {
    private final String awqlQuery;

    ReportQuery(String awqlQuery) {
        this.awqlQuery = awqlQuery;
    }

    public String toString() {
        return this.awqlQuery;
    }

    public boolean equals(Object obj) {
        if (obj instanceof ReportQuery) {
            ReportQuery other = (ReportQuery)obj;
            return Objects.equal((Object)this.awqlQuery, (Object)other.awqlQuery);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.awqlQuery});
    }

    public static class Builder
    implements ReportQueryInterface.BuilderInterface {
        private final ReportQueryInterface.BuilderInterface proxy;
        private final ReportQueryBuilderImpl proxiedImpl;

        public Builder() {
            this.proxiedImpl = new ReportQueryBuilderImpl(this);
            AdsUtilityInvocationHandler invocationHandler = new AdsUtilityInvocationHandler(this.proxiedImpl, AdWordsInternals.getInstance().getAdsUtilityRegistry());
            this.proxy = (ReportQueryInterface.BuilderInterface)Reflection.newProxy(ReportQueryInterface.BuilderInterface.class, (InvocationHandler)((Object)invocationHandler));
        }

        public Builder(ReportQueryInterface.BuilderInterface builderInterface) {
            Preconditions.checkNotNull((Object)builderInterface, (Object)"The report query builder cannot be null.");
            Builder builder = (Builder)builderInterface;
            this.proxiedImpl = new ReportQueryBuilderImpl(builder.proxiedImpl);
            AdsUtilityInvocationHandler invocationHandler = new AdsUtilityInvocationHandler(this.proxiedImpl, AdWordsInternals.getInstance().getAdsUtilityRegistry());
            this.proxy = (ReportQueryInterface.BuilderInterface)Reflection.newProxy(ReportQueryInterface.BuilderInterface.class, (InvocationHandler)((Object)invocationHandler));
        }

        @Override
        public ReportQueryInterface.BuilderInterface.ReportWhereBuilderInterface<Builder> where(String field) {
            return this.proxy.where(field);
        }

        @Override
        @CanIgnoreReturnValue
        public Builder fields(String ... fields) {
            this.proxy.fields(fields);
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public Builder fields(Iterable<String> fields) {
            this.proxy.fields((Iterable)fields);
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public Builder from(Enum<?> reportType) {
            this.proxy.from(reportType);
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public Builder from(String reportType) {
            this.proxy.from(reportType);
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public Builder during(Enum<?> dateRange) {
            this.proxy.during(dateRange);
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public Builder during(LocalDate startDate, LocalDate endDate) {
            this.proxy.during(startDate, endDate);
            return this;
        }

        @Override
        public ReportQuery build() {
            return (ReportQuery)this.proxy.build();
        }
    }
}

