/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.ads.common.lib.soap;

import com.google.api.ads.common.lib.client.ResponseInfo;
import com.google.api.ads.common.lib.conf.AdsApiConfiguration;
import com.google.api.ads.common.lib.utils.IterableXPath;
import com.google.api.ads.common.lib.utils.NodeExtractor;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.primitives.Longs;
import com.google.inject.Inject;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPHeader;
import javax.xml.soap.SOAPMessage;
import org.w3c.dom.Node;

public class ResponseInfoXPathSet {
    private final IterableXPath requestIdXPath;
    private final IterableXPath responseTimeXPath;
    private final IterableXPath operationsCountXPath;
    private final NodeExtractor nodeExtractor;

    @Inject
    public ResponseInfoXPathSet(AdsApiConfiguration apiConfig, NodeExtractor nodeExtractor) {
        this.requestIdXPath = new IterableXPath(apiConfig.getRequestIdXPath());
        this.responseTimeXPath = new IterableXPath(apiConfig.getResponseTimeXPath());
        this.operationsCountXPath = new IterableXPath(apiConfig.getResponseOperationsCountXPath());
        this.nodeExtractor = nodeExtractor;
    }

    public IterableXPath getRequestIdXPath() {
        return this.requestIdXPath;
    }

    public IterableXPath getResponseTimeXPath() {
        return this.responseTimeXPath;
    }

    public IterableXPath getOperationsCountXPath() {
        return this.operationsCountXPath;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("requestIdXPath", (Object)this.requestIdXPath).add("responseTimeXPath", (Object)this.responseTimeXPath).add("operationsCountXPath", (Object)this.operationsCountXPath).toString();
    }

    public ResponseInfo.Builder parseMessage(ResponseInfo.Builder builder, SOAPMessage soapMessage) {
        Preconditions.checkNotNull((Object)builder, (Object)"Null builder");
        if (soapMessage == null) {
            return builder;
        }
        try (ByteArrayOutputStream outputStream = new ByteArrayOutputStream();){
            soapMessage.writeTo((OutputStream)outputStream);
            builder.withPayload(outputStream.toString(StandardCharsets.UTF_8.name()));
        }
        catch (IOException | SOAPException e) {
            builder.withPayload("Unable to read response due to exception: " + e);
        }
        try {
            SOAPHeader soapHeader = soapMessage.getSOAPHeader();
            String responseTimeString = this.nodeExtractor.extractNodeValue((Node)soapHeader, this.responseTimeXPath);
            String operationsString = this.nodeExtractor.extractNodeValue((Node)soapHeader, this.operationsCountXPath);
            builder.withRequestId(this.nodeExtractor.extractNodeValue((Node)soapHeader, this.requestIdXPath)).withResponseTimeMillis(Longs.tryParse((String)Strings.nullToEmpty((String)responseTimeString))).withOperationsCount(Longs.tryParse((String)Strings.nullToEmpty((String)operationsString)));
        }
        catch (SOAPException e) {
            builder.withRequestId("Unable to extract the requestId due to exception: " + (Object)((Object)e));
        }
        return builder;
    }
}

