/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.ads.adwords.lib.utils;

import com.google.api.ads.adwords.lib.AdWordsModule;
import com.google.api.ads.adwords.lib.conf.AdWordsLibConfiguration;
import com.google.api.ads.adwords.lib.factory.DependencyBootstrapper;
import com.google.api.ads.common.lib.auth.AuthorizationHeaderProvider;
import com.google.api.ads.common.lib.auth.OAuth2Helper;
import com.google.api.ads.common.lib.useragent.UserAgentCombiner;
import com.google.api.ads.common.lib.utils.AdsUtilityRegistry;
import com.google.api.ads.common.lib.utils.Internals;
import com.google.api.ads.common.lib.utils.XmlFieldExtractor;
import com.google.api.ads.common.lib.utils.logging.AdsServiceLoggers;
import com.google.api.client.http.HttpTransport;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import javax.inject.Inject;

public class AdWordsInternals
extends Internals {
    private static final Injector DEFAULT_INJECTOR = Guice.createInjector((Module[])new Module[]{new AdWordsModule()});
    private static final AdWordsInternals INSTANCE = (AdWordsInternals)DEFAULT_INJECTOR.getInstance(AdWordsInternals.class);
    private final AdWordsLibConfiguration adWordsLibConfiguration;
    private final Injector injector;

    @Inject
    AdWordsInternals(AuthorizationHeaderProvider authorizationHeaderProvider, UserAgentCombiner userAgentCombiner, HttpTransport httpTransport, AdWordsLibConfiguration adWordsLibConfiguration, AdsServiceLoggers adsServiceLoggers, OAuth2Helper oAuth2Helper, AdsUtilityRegistry adsUtilityRegistry, XmlFieldExtractor xmlFieldExtractor, Injector injector) {
        super(authorizationHeaderProvider, userAgentCombiner, httpTransport, adsServiceLoggers, oAuth2Helper, adsUtilityRegistry, xmlFieldExtractor);
        this.adWordsLibConfiguration = adWordsLibConfiguration;
        this.injector = injector;
    }

    public static AdWordsInternals getInstance() {
        return INSTANCE;
    }

    public static DependencyBootstrapper getBootstrapper() {
        return (DependencyBootstrapper)AdWordsInternals.INSTANCE.injector.getInstance(DependencyBootstrapper.class);
    }

    public AdWordsLibConfiguration getAdWordsLibConfiguration() {
        return this.adWordsLibConfiguration;
    }
}

