/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.ads.adwords.lib.utils.v201802;

import com.google.api.ads.adwords.lib.jaxb.v201802.ReportDefinitionDateRangeType;
import com.google.api.ads.adwords.lib.jaxb.v201802.ReportDefinitionReportType;
import com.google.api.ads.adwords.lib.utils.QueryBuilder;
import com.google.api.ads.adwords.lib.utils.ReportQueryInterface;
import com.google.api.ads.adwords.lib.utils.v201802.ReportQuery;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.List;
import org.joda.time.LocalDate;

class ReportQueryBuilderImpl
extends QueryBuilder<ReportQueryBuilderImpl, ReportQueryInterface>
implements ReportQueryInterface.BuilderInterface {
    private static final String DURING_DATE_FORMAT = "yyyyMMdd";
    private final ReportQuery.Builder builder;
    private List<String> fields = Lists.newArrayList();
    private ReportDefinitionReportType from;
    private ReportDefinitionDateRangeType dateRange;
    private LocalDate startDate;
    private LocalDate endDate;

    ReportQueryBuilderImpl(ReportQuery.Builder builder) {
        this.builder = builder;
        this.fields = Lists.newArrayList();
        this.from = null;
        this.dateRange = null;
        this.startDate = null;
        this.endDate = null;
    }

    ReportQueryBuilderImpl(ReportQueryBuilderImpl builderImpl) {
        super(builderImpl);
        Preconditions.checkNotNull((Object)builderImpl, (Object)"The report query builder cannot be null.");
        this.builder = builderImpl.builder;
        this.fields = Lists.newArrayList(builderImpl.fields);
        this.from = builderImpl.from;
        this.dateRange = builderImpl.dateRange;
        this.startDate = builderImpl.startDate;
        this.endDate = builderImpl.endDate;
    }

    @Override
    public ReportWhereBuilder where(String field) {
        QueryBuilder.WhereBuilder whereBuilderDelegate = new QueryBuilder.WhereBuilder(field);
        this.whereBuilders.add(whereBuilderDelegate);
        return new ReportWhereBuilder(whereBuilderDelegate);
    }

    @Override
    public ReportQuery.Builder fields(String ... fields) {
        Preconditions.checkNotNull((Object)fields, (Object)"Fields to be selected cannot be null.");
        this.fields = Lists.newArrayList((Object[])fields);
        return this.builder;
    }

    @Override
    public ReportQuery.Builder fields(Iterable<String> fields) {
        Preconditions.checkNotNull(fields, (Object)"Fields to be selected cannot be null.");
        this.fields = Lists.newArrayList(fields);
        return this.builder;
    }

    @Override
    public ReportQuery.Builder from(Enum<?> reportType) {
        Preconditions.checkNotNull(reportType, (Object)"The report type cannot be null.");
        this.from = (ReportDefinitionReportType)reportType;
        return this.builder;
    }

    @Override
    public ReportQuery.Builder from(String reportType) {
        return this.from((Enum)ReportDefinitionReportType.fromValue(reportType));
    }

    @Override
    public ReportQuery.Builder during(Enum<?> dateRange) {
        Preconditions.checkNotNull(dateRange, (Object)"The date range cannot be null.");
        this.startDate = null;
        this.endDate = null;
        this.dateRange = (ReportDefinitionDateRangeType)dateRange;
        return this.builder;
    }

    @Override
    public ReportQuery.Builder during(LocalDate startDate, LocalDate endDate) {
        Preconditions.checkNotNull((Object)startDate, (Object)"The start date cannot be null.");
        Preconditions.checkNotNull((Object)endDate, (Object)"The end date cannot be null.");
        this.dateRange = null;
        this.startDate = startDate;
        this.endDate = endDate;
        return this.builder;
    }

    @Override
    public ReportQuery build() {
        this.validate();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("SELECT ");
        Joiner.on((String)", ").skipNulls().appendTo(stringBuilder, this.fields);
        stringBuilder.append(String.format(" FROM %s", new Object[]{this.from}));
        if (!this.whereBuilders.isEmpty()) {
            stringBuilder.append(String.format(" WHERE %s", Joiner.on((String)" AND ").skipNulls().join((Iterable)this.whereBuilders)));
        }
        if (this.dateRange != null) {
            stringBuilder.append(String.format(" DURING %s", new Object[]{this.dateRange}));
        } else if (this.startDate != null && this.endDate != null) {
            stringBuilder.append(String.format(" DURING %s,%s", this.startDate.toString(DURING_DATE_FORMAT), this.endDate.toString(DURING_DATE_FORMAT)));
        }
        return new ReportQuery(stringBuilder.toString());
    }

    private void validate() {
        if (this.fields.isEmpty()) {
            throw new IllegalStateException("Must use fields() to specify the SELECT clause first.");
        }
        if (this.from == null) {
            throw new IllegalStateException("Must use from() to specify the FROM clause first.");
        }
    }

    class ReportWhereBuilder
    implements ReportQueryInterface.BuilderInterface.ReportWhereBuilderInterface<ReportQuery.Builder> {
        private final QueryBuilder.WhereBuilder whereBuilderDelegate;

        ReportWhereBuilder(QueryBuilder.WhereBuilder whereBuilderDelegate) {
            this.whereBuilderDelegate = whereBuilderDelegate;
        }

        public String toString() {
            return this.whereBuilderDelegate.toString();
        }

        @Override
        public ReportQuery.Builder equalTo(String propertyValue) {
            this.whereBuilderDelegate.equalTo(propertyValue);
            return ReportQueryBuilderImpl.this.builder;
        }

        @Override
        public ReportQuery.Builder equalTo(int propertyValue) {
            this.whereBuilderDelegate.equalTo(propertyValue);
            return ReportQueryBuilderImpl.this.builder;
        }

        @Override
        public ReportQuery.Builder equalTo(long propertyValue) {
            this.whereBuilderDelegate.equalTo(propertyValue);
            return ReportQueryBuilderImpl.this.builder;
        }

        @Override
        public ReportQuery.Builder equalTo(boolean propertyValue) {
            this.whereBuilderDelegate.equalTo(propertyValue);
            return ReportQueryBuilderImpl.this.builder;
        }

        @Override
        public ReportQuery.Builder notEqualTo(String propertyValue) {
            this.whereBuilderDelegate.notEqualTo(propertyValue);
            return ReportQueryBuilderImpl.this.builder;
        }

        @Override
        public ReportQuery.Builder notEqualTo(int propertyValue) {
            this.whereBuilderDelegate.notEqualTo(propertyValue);
            return ReportQueryBuilderImpl.this.builder;
        }

        @Override
        public ReportQuery.Builder notEqualTo(long propertyValue) {
            this.whereBuilderDelegate.notEqualTo(propertyValue);
            return ReportQueryBuilderImpl.this.builder;
        }

        @Override
        public ReportQuery.Builder notEqualTo(boolean propertyValue) {
            this.whereBuilderDelegate.notEqualTo(propertyValue);
            return ReportQueryBuilderImpl.this.builder;
        }

        @Override
        public ReportQuery.Builder contains(String propertyValue) {
            this.whereBuilderDelegate.contains(propertyValue);
            return ReportQueryBuilderImpl.this.builder;
        }

        @Override
        public ReportQuery.Builder containsIgnoreCase(String propertyValue) {
            this.whereBuilderDelegate.containsIgnoreCase(propertyValue);
            return ReportQueryBuilderImpl.this.builder;
        }

        @Override
        public ReportQuery.Builder doesNotContain(String propertyValue) {
            this.whereBuilderDelegate.doesNotContain(propertyValue);
            return ReportQueryBuilderImpl.this.builder;
        }

        @Override
        public ReportQuery.Builder doesNotContainIgnoreCase(String propertyValue) {
            this.whereBuilderDelegate.doesNotContainIgnoreCase(propertyValue);
            return ReportQueryBuilderImpl.this.builder;
        }

        @Override
        public ReportQuery.Builder greaterThan(long propertyValue) {
            this.whereBuilderDelegate.greaterThan(propertyValue);
            return ReportQueryBuilderImpl.this.builder;
        }

        @Override
        public ReportQuery.Builder greaterThan(int propertyValue) {
            this.whereBuilderDelegate.greaterThan(propertyValue);
            return ReportQueryBuilderImpl.this.builder;
        }

        @Override
        public ReportQuery.Builder greaterThan(double propertyValue) {
            this.whereBuilderDelegate.greaterThan(propertyValue);
            return ReportQueryBuilderImpl.this.builder;
        }

        @Override
        public ReportQuery.Builder greaterThanOrEqualTo(long propertyValue) {
            this.whereBuilderDelegate.greaterThanOrEqualTo(propertyValue);
            return ReportQueryBuilderImpl.this.builder;
        }

        @Override
        public ReportQuery.Builder greaterThanOrEqualTo(int propertyValue) {
            this.whereBuilderDelegate.greaterThanOrEqualTo(propertyValue);
            return ReportQueryBuilderImpl.this.builder;
        }

        @Override
        public ReportQuery.Builder greaterThanOrEqualTo(double propertyValue) {
            this.whereBuilderDelegate.greaterThanOrEqualTo(propertyValue);
            return ReportQueryBuilderImpl.this.builder;
        }

        @Override
        public ReportQuery.Builder lessThan(long propertyValue) {
            this.whereBuilderDelegate.lessThan(propertyValue);
            return ReportQueryBuilderImpl.this.builder;
        }

        @Override
        public ReportQuery.Builder lessThan(int propertyValue) {
            this.whereBuilderDelegate.lessThan(propertyValue);
            return ReportQueryBuilderImpl.this.builder;
        }

        @Override
        public ReportQuery.Builder lessThan(double propertyValue) {
            this.whereBuilderDelegate.lessThan(propertyValue);
            return ReportQueryBuilderImpl.this.builder;
        }

        @Override
        public ReportQuery.Builder lessThanOrEqualTo(long propertyValue) {
            this.whereBuilderDelegate.lessThanOrEqualTo(propertyValue);
            return ReportQueryBuilderImpl.this.builder;
        }

        @Override
        public ReportQuery.Builder lessThanOrEqualTo(int propertyValue) {
            this.whereBuilderDelegate.lessThanOrEqualTo(propertyValue);
            return ReportQueryBuilderImpl.this.builder;
        }

        @Override
        public ReportQuery.Builder lessThanOrEqualTo(double propertyValue) {
            this.whereBuilderDelegate.lessThanOrEqualTo(propertyValue);
            return ReportQueryBuilderImpl.this.builder;
        }

        @Override
        public ReportQuery.Builder startsWith(String propertyValue) {
            this.whereBuilderDelegate.startsWith(propertyValue);
            return ReportQueryBuilderImpl.this.builder;
        }

        @Override
        public ReportQuery.Builder startsWithIgnoreCase(String propertyValue) {
            this.whereBuilderDelegate.startsWithIgnoreCase(propertyValue);
            return ReportQueryBuilderImpl.this.builder;
        }

        @Override
        public ReportQuery.Builder in(String ... values) {
            this.whereBuilderDelegate.in(values);
            return ReportQueryBuilderImpl.this.builder;
        }

        @Override
        public ReportQuery.Builder in(int ... values) {
            this.whereBuilderDelegate.in(values);
            return ReportQueryBuilderImpl.this.builder;
        }

        @Override
        public ReportQuery.Builder in(long ... values) {
            this.whereBuilderDelegate.in(values);
            return ReportQueryBuilderImpl.this.builder;
        }

        @Override
        public ReportQuery.Builder in(double ... values) {
            this.whereBuilderDelegate.in(values);
            return ReportQueryBuilderImpl.this.builder;
        }

        @Override
        public ReportQuery.Builder in(boolean ... values) {
            this.whereBuilderDelegate.in(values);
            return ReportQueryBuilderImpl.this.builder;
        }

        @Override
        public ReportQuery.Builder notIn(String ... values) {
            this.whereBuilderDelegate.notIn(values);
            return ReportQueryBuilderImpl.this.builder;
        }

        @Override
        public ReportQuery.Builder notIn(int ... values) {
            this.whereBuilderDelegate.notIn(values);
            return ReportQueryBuilderImpl.this.builder;
        }

        @Override
        public ReportQuery.Builder notIn(long ... values) {
            this.whereBuilderDelegate.notIn(values);
            return ReportQueryBuilderImpl.this.builder;
        }

        @Override
        public ReportQuery.Builder notIn(double ... values) {
            this.whereBuilderDelegate.notIn(values);
            return ReportQueryBuilderImpl.this.builder;
        }

        @Override
        public ReportQuery.Builder notIn(boolean ... values) {
            this.whereBuilderDelegate.notIn(values);
            return ReportQueryBuilderImpl.this.builder;
        }

        @Override
        public ReportQuery.Builder containsAny(String ... values) {
            this.whereBuilderDelegate.containsAny(values);
            return ReportQueryBuilderImpl.this.builder;
        }

        @Override
        public ReportQuery.Builder containsAny(int ... values) {
            this.whereBuilderDelegate.containsAny(values);
            return ReportQueryBuilderImpl.this.builder;
        }

        @Override
        public ReportQuery.Builder containsAny(long ... values) {
            this.whereBuilderDelegate.containsAny(values);
            return ReportQueryBuilderImpl.this.builder;
        }

        @Override
        public ReportQuery.Builder containsAny(double ... values) {
            this.whereBuilderDelegate.containsAny(values);
            return ReportQueryBuilderImpl.this.builder;
        }

        @Override
        public ReportQuery.Builder containsAll(String ... values) {
            this.whereBuilderDelegate.containsAll(values);
            return ReportQueryBuilderImpl.this.builder;
        }

        @Override
        public ReportQuery.Builder containsAll(int ... values) {
            this.whereBuilderDelegate.containsAll(values);
            return ReportQueryBuilderImpl.this.builder;
        }

        @Override
        public ReportQuery.Builder containsAll(long ... values) {
            this.whereBuilderDelegate.containsAll(values);
            return ReportQueryBuilderImpl.this.builder;
        }

        @Override
        public ReportQuery.Builder containsAll(double ... values) {
            this.whereBuilderDelegate.containsAll(values);
            return ReportQueryBuilderImpl.this.builder;
        }

        @Override
        public ReportQuery.Builder containsNone(String ... values) {
            this.whereBuilderDelegate.containsNone(values);
            return ReportQueryBuilderImpl.this.builder;
        }

        @Override
        public ReportQuery.Builder containsNone(int ... values) {
            this.whereBuilderDelegate.containsNone(values);
            return ReportQueryBuilderImpl.this.builder;
        }

        @Override
        public ReportQuery.Builder containsNone(long ... values) {
            this.whereBuilderDelegate.containsNone(values);
            return ReportQueryBuilderImpl.this.builder;
        }

        @Override
        public ReportQuery.Builder containsNone(double ... values) {
            this.whereBuilderDelegate.containsNone(values);
            return ReportQueryBuilderImpl.this.builder;
        }
    }
}

