/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.ads.adwords.lib.conf;

import com.google.api.ads.common.lib.conf.AdsApiConfiguration;
import com.google.common.collect.Lists;
import com.google.inject.name.Named;
import javax.inject.Inject;
import org.apache.commons.configuration.Configuration;

public class AdWordsApiConfiguration
extends AdsApiConfiguration {
    public static final String NAMESPACE_PREFIX_KEY = "api.adwords.namespace.prefix";
    private static final String KEY_PREFIX = "api.adwords";

    @Inject
    public AdWordsApiConfiguration(@Named(value="api") Configuration config) {
        super(config);
    }

    @Override
    public String getNamespacePrefix() {
        return this.getString(NAMESPACE_PREFIX_KEY);
    }

    public String getServiceUrlGroup(String version, String service) {
        String[] groups;
        for (String group : groups = this.config.getStringArray("api.adwords.version." + version + ".groups")) {
            Object[] services = this.config.getStringArray("api.adwords.version." + version + "." + group + ".services");
            if (!Lists.newArrayList((Object[])services).contains(service)) continue;
            return group;
        }
        throw new NullPointerException("No group found for service: " + version + "." + service);
    }

    @Override
    public String getRequestIdXPath() {
        return this.config.getString(String.format("%s.%s", KEY_PREFIX, "requestIdXPath"));
    }

    @Override
    public String[] getSensitiveXPaths() {
        return this.config.getStringArray(String.format("%s.%s", KEY_PREFIX, "sensitiveXPaths"));
    }
}

