/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.ads.adwords.lib.utils.logging;

import com.google.api.ads.adwords.lib.utils.BatchJobMutateResponseInterface;
import com.google.api.ads.adwords.lib.utils.BatchJobMutateResultInterface;
import com.google.api.ads.adwords.lib.utils.BatchJobUploadResponse;
import com.google.api.ads.common.lib.client.RemoteCallReturn;
import com.google.api.ads.common.lib.client.RequestInfo;
import com.google.api.ads.common.lib.client.ResponseInfo;
import com.google.api.ads.common.lib.utils.logging.RemoteCallLoggerDelegate;
import com.google.common.base.Strings;
import com.google.inject.name.Named;
import java.net.URI;
import javax.annotation.Nullable;
import javax.inject.Inject;
import org.slf4j.Logger;

public class BatchJobLogger {
    private static final String CONTEXT_NAME = "clientCustomerId";
    private final RemoteCallLoggerDelegate loggerDelegate;

    @Inject
    BatchJobLogger(@Named(value="batch_job") Logger batchJobLogger) {
        this(new RemoteCallLoggerDelegate(batchJobLogger, batchJobLogger, null, RemoteCallLoggerDelegate.RemoteCallType.HTTP));
    }

    BatchJobLogger(RemoteCallLoggerDelegate loggerDelegate) {
        this.loggerDelegate = loggerDelegate;
    }

    public void logUpload(String uploadContents, URI uploadUri, @Nullable BatchJobUploadResponse batchJobUploadResponse, @Nullable Throwable throwable) {
        RequestInfo requestInfo = new RequestInfo.Builder().withServiceName("batchjobupload").withContext(CONTEXT_NAME, null).withUrl(uploadUri.toString()).withPayload(Strings.nullToEmpty((String)uploadContents).trim()).build();
        ResponseInfo.Builder responseInfoBuilder = new ResponseInfo.Builder();
        if (batchJobUploadResponse != null) {
            responseInfoBuilder.withPayload(String.format("%d %s%n", batchJobUploadResponse.getHttpStatus(), batchJobUploadResponse.getHttpResponseMessage()));
        }
        RemoteCallReturn remoteCallReturn = new RemoteCallReturn.Builder().withRequestInfo(requestInfo).withResponseInfo(responseInfoBuilder.build()).withException(throwable).build();
        this.loggerDelegate.logRequestSummary(remoteCallReturn);
        this.loggerDelegate.logRequestDetails(remoteCallReturn);
    }

    public <O, E, R extends BatchJobMutateResultInterface<O, E>> void logDownload(String downloadUrl, @Nullable BatchJobMutateResponseInterface<O, E, R> response, @Nullable Throwable throwable) {
        RequestInfo requestInfo = new RequestInfo.Builder().withServiceName("batchjobdownload").withContext(CONTEXT_NAME, null).withUrl(downloadUrl).build();
        int resultsCount = 0;
        if (response != null && response.getMutateResults() != null) {
            resultsCount = response.getMutateResults().length;
        }
        ResponseInfo responseInfo = new ResponseInfo.Builder().withPayload(String.format("Results count: %d", resultsCount)).build();
        RemoteCallReturn remoteCallReturn = new RemoteCallReturn.Builder().withRequestInfo(requestInfo).withResponseInfo(responseInfo).withException(throwable).build();
        this.loggerDelegate.logRequestSummary(remoteCallReturn);
        this.loggerDelegate.logRequestDetails(remoteCallReturn);
    }
}

