/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.ads.common.lib.utils.logging;

import com.google.api.ads.common.lib.soap.RequestInfo;
import com.google.api.ads.common.lib.soap.ResponseInfo;
import com.google.api.ads.common.lib.soap.SoapCallReturn;
import com.google.api.ads.common.lib.utils.logging.PrettyPrinterInterface;
import com.google.inject.name.Named;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AdsServiceLoggers {
    public static final Logger ADS_API_LIB_LOG = LoggerFactory.getLogger((String)(AdsServiceLoggers.class.getName() + ".ads_api_lib"));
    private final PrettyPrinterInterface prettyPrinter;
    private final Logger soapXmlLogger;
    private final Logger requestInfoLogger;

    @Inject
    protected AdsServiceLoggers(PrettyPrinterInterface prettyPrinter, @Named(value="soapXmlLogger") Logger soapXmlLogger, @Named(value="requestInfoLogger") Logger requestInfoLogger) {
        this.prettyPrinter = prettyPrinter;
        this.soapXmlLogger = soapXmlLogger;
        this.requestInfoLogger = requestInfoLogger;
    }

    public Logger getLibLogger() {
        return ADS_API_LIB_LOG;
    }

    public void logSoapXml(SoapCallReturn soapCallReturn) {
        RequestInfo request = soapCallReturn.getRequestInfo();
        ResponseInfo response = soapCallReturn.getResponseInfo();
        if (this.soapXmlLogger.isInfoEnabled() || this.soapXmlLogger.isWarnEnabled() && soapCallReturn.getException() != null) {
            String prettyRequest = "SOAP Request:\n" + this.prettyPrinter.prettyPrint(request.getSoapRequestXml());
            String prettyResponse = "SOAP Response:\n" + this.prettyPrinter.prettyPrint(response.getSoapResponseXml());
            if (soapCallReturn.getException() == null) {
                this.soapXmlLogger.info(prettyRequest);
                this.soapXmlLogger.info(prettyResponse);
            } else {
                this.soapXmlLogger.warn(prettyRequest);
                this.soapXmlLogger.warn(prettyResponse);
            }
        }
    }

    public void logRequest(SoapCallReturn soapCallReturn) {
        RequestInfo request = soapCallReturn.getRequestInfo();
        ResponseInfo response = soapCallReturn.getResponseInfo();
        Object[] logArgs = new Object[4];
        if (request != null) {
            logArgs[0] = request.getServiceName();
            logArgs[1] = request.getMethodName();
            logArgs[2] = request.getUrl();
        }
        if (response != null) {
            logArgs[3] = response.getRequestId();
        }
        this.requestInfoLogger.info("Request made: Service: \"{}\" Method: \"{}\" URL: \"{}\" Request ID: \"{}\"", logArgs);
    }
}

