/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.ads.adwords.lib.conf;

import com.google.api.ads.adwords.lib.client.AdWordsServiceDescriptor;
import com.google.api.ads.common.lib.conf.AdsApiConfiguration;
import com.google.common.collect.Lists;
import com.google.inject.name.Named;
import javax.inject.Inject;
import org.apache.commons.configuration.Configuration;

public class AdWordsApiConfiguration
extends AdsApiConfiguration {
    public static final String NAMESPACE_PREFIX_KEY = "api.adwords.namespace.prefix";
    private static final String KEY_PREFIX = "api.adwords";

    @Inject
    public AdWordsApiConfiguration(@Named(value="api") Configuration config) {
        super(config);
    }

    @Override
    public String getNamespacePrefix() {
        return this.getString(NAMESPACE_PREFIX_KEY);
    }

    public String getServiceUrlGroup(String version, String service) {
        String[] groups;
        for (String group : groups = this.config.getStringArray(new StringBuilder(27 + String.valueOf(version).length()).append("api.adwords.version.").append(version).append(".groups").toString())) {
            Object[] services = this.config.getStringArray(new StringBuilder(30 + String.valueOf(version).length() + String.valueOf(group).length()).append("api.adwords.version.").append(version).append(".").append(group).append(".services").toString());
            if (!Lists.newArrayList((Object[])services).contains(service)) continue;
            return group;
        }
        throw new NullPointerException(new StringBuilder(29 + String.valueOf(version).length() + String.valueOf(service).length()).append("No group found for service: ").append(version).append(".").append(service).toString());
    }

    public AdWordsServiceDescriptor.AdWordsSubProduct getServiceSubProduct(String version, String service) {
        String string = this.getServiceUrlGroup(version, service);
        String subProductName = this.config.getString(new StringBuilder(32 + String.valueOf(version).length() + String.valueOf(string).length()).append("api.adwords.version.").append(version).append(".").append(string).append(".subproduct").toString());
        return subProductName != null ? Enum.valueOf(AdWordsServiceDescriptor.AdWordsSubProduct.class, subProductName.toUpperCase()) : AdWordsServiceDescriptor.AdWordsSubProduct.DEFAULT;
    }

    @Override
    public String getRequestIdXPath() {
        return this.config.getString(String.format("%s.%s", KEY_PREFIX, "requestIdXPath"));
    }

    @Override
    public String[] getSensitiveXPaths() {
        return this.config.getStringArray(String.format("%s.%s", KEY_PREFIX, "sensitiveXPaths"));
    }
}

