/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.ads.dfp.lib.client;

import com.google.api.ads.common.lib.client.AdsServiceDescriptor;
import com.google.api.ads.common.lib.exception.ServiceException;
import com.google.api.ads.common.lib.soap.compatability.AxisCompatible;
import com.google.api.ads.common.lib.soap.compatability.JaxWsCompatible;
import com.google.common.annotations.VisibleForTesting;
import com.google.inject.assistedinject.Assisted;
import java.net.MalformedURLException;
import java.net.URL;
import javax.inject.Inject;

public class DfpServiceDescriptor
implements AdsServiceDescriptor,
AxisCompatible,
JaxWsCompatible {
    private final Class<?> interfaceClass;
    private final String version;

    @Inject
    public DfpServiceDescriptor(@Assisted(value="interfaceClass") Class<?> interfaceClass, @Assisted(value="version") String version) {
        this.interfaceClass = interfaceClass;
        this.version = version;
    }

    @Override
    public Class<?> getInterfaceClass() throws ServiceException {
        return this.interfaceClass;
    }

    @Override
    public String getEndpointAddress(String endpointServer) throws MalformedURLException {
        String serviceName = this.getServiceName();
        String endpointServerUrl = new URL(endpointServer).toString();
        if (endpointServerUrl.endsWith("/")) {
            endpointServerUrl = endpointServerUrl.substring(0, endpointServerUrl.length() - 1);
        }
        String string = endpointServerUrl;
        String string2 = this.version;
        return new StringBuilder(21 + String.valueOf(string).length() + String.valueOf(string2).length() + String.valueOf(serviceName).length()).append(string).append("/apis/ads/publisher/").append(string2).append("/").append(serviceName).toString();
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    @Override
    public Class<?> getLocatorClass() throws ClassNotFoundException {
        String string = String.valueOf(this.interfaceClass.getPackage().getName());
        String string2 = this.getServiceName();
        return Class.forName(new StringBuilder(8 + String.valueOf(string).length() + String.valueOf(string2).length()).append(string).append(".").append(string2).append("Locator").toString());
    }

    @VisibleForTesting
    String getServiceName() {
        String simpleName = this.interfaceClass.getSimpleName();
        return simpleName.substring(0, simpleName.indexOf("Interface"));
    }

    @Override
    public Class<?> getServiceClass() throws ClassNotFoundException {
        String string = String.valueOf(this.interfaceClass.getPackage().getName());
        String string2 = this.getServiceName();
        return Class.forName(new StringBuilder(1 + String.valueOf(string).length() + String.valueOf(string2).length()).append(string).append(".").append(string2).toString());
    }
}

