/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.ads.adwords.lib.utils;

import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.net.URI;
import javax.annotation.Nullable;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;

public class BatchJobUploadStatus
implements Serializable {
    private final long totalContentLength;
    private final URI resumableUploadUri;

    public BatchJobUploadStatus(long totalContentLength, @Nullable URI resumableUploadUri) {
        Preconditions.checkArgument((totalContentLength >= 0L ? 1 : 0) != 0, (String)"Total content length %s is < 0", (Object[])new Object[]{totalContentLength});
        this.totalContentLength = totalContentLength;
        this.resumableUploadUri = resumableUploadUri;
    }

    public long getTotalContentLength() {
        return this.totalContentLength;
    }

    @Nullable
    public URI getResumableUploadUri() {
        return this.resumableUploadUri;
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append("totalContentLength", this.totalContentLength).append("resumableUploadUri", (Object)this.resumableUploadUri).toString();
    }
}

