/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.ads.dfp.lib.client;

import com.google.api.ads.common.lib.auth.OAuth2Compatible;
import com.google.api.ads.common.lib.client.AdsSession;
import com.google.api.ads.common.lib.conf.ConfigurationHelper;
import com.google.api.ads.common.lib.conf.ConfigurationLoadException;
import com.google.api.ads.common.lib.exception.ValidationException;
import com.google.api.ads.dfp.lib.utils.DfpInternals;
import com.google.api.client.auth.oauth2.Credential;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.commons.configuration.Configuration;
import org.slf4j.Logger;

public class DfpSession
implements AdsSession,
OAuth2Compatible {
    private String networkCode;
    private Credential oAuth2Credential;
    private final String applicationName;
    private final String endpoint;
    private final Logger libLogger;
    public static final String DEFAULT_ENDPOINT = "https://ads.google.com/";
    private static final String DEFAULT_APPLICATION_NAME = "INSERT_APPLICATION_NAME_HERE";

    private DfpSession(Builder builder) {
        this.applicationName = builder.applicationName;
        this.endpoint = builder.endpoint;
        this.networkCode = builder.networkCode;
        this.oAuth2Credential = builder.oAuth2Credential;
        this.libLogger = builder.libLogger;
    }

    public String getApplicationName() {
        return this.applicationName;
    }

    @Override
    public Credential getOAuth2Credential() {
        return this.oAuth2Credential;
    }

    public void setOAuth2Credential(Credential oAuth2Credential) {
        Preconditions.checkNotNull((Object)oAuth2Credential, (Object)"oAuth2Credential cannot be null.");
        this.clearAuthentication();
        this.oAuth2Credential = oAuth2Credential;
    }

    @Override
    public String getEndpoint() {
        return this.endpoint;
    }

    public String getNetworkCode() {
        return this.networkCode;
    }

    public void setNetworkCode(String networkCode) {
        this.networkCode = networkCode;
    }

    private void clearAuthentication() {
        this.oAuth2Credential = null;
    }

    /* synthetic */ DfpSession(Builder builder, DfpSession dfpSession) {
        this(builder);
    }

    public static class Builder
    implements com.google.api.ads.common.lib.utils.Builder<DfpSession> {
        private String applicationName;
        private String endpoint;
        private String networkCode;
        private Credential oAuth2Credential;
        private final Logger libLogger;
        private final ConfigurationHelper configHelper;

        public Builder() {
            this(DfpInternals.getInstance().getAdsServiceLoggers().getLibLogger());
        }

        @VisibleForTesting
        Builder(Logger libLogger) {
            this(libLogger, new ConfigurationHelper());
        }

        private Builder(Logger libLogger, ConfigurationHelper configHelper) {
            this.libLogger = libLogger;
            this.configHelper = configHelper;
        }

        public Builder fromFile() throws ConfigurationLoadException {
            return this.fromFile("ads.properties");
        }

        public Builder fromFile(String path) throws ConfigurationLoadException {
            return this.from(this.configHelper.fromFile(path));
        }

        public Builder fromFile(File path) throws ConfigurationLoadException {
            return this.from(this.configHelper.fromFile(path));
        }

        public Builder fromFile(URL path) throws ConfigurationLoadException {
            return this.from(this.configHelper.fromFile(path));
        }

        public Builder from(Configuration config) {
            this.applicationName = config.getString("api.dfp.applicationName", null);
            this.networkCode = config.getString("api.dfp.networkCode", null);
            this.endpoint = config.getString("api.dfp.endpoint", null);
            return this;
        }

        public Builder withOAuth2Credential(Credential oAuth2Credential) {
            this.clearAuthentication();
            this.oAuth2Credential = oAuth2Credential;
            return this;
        }

        public Builder withNetworkCode(String networkCode) {
            this.networkCode = networkCode;
            return this;
        }

        public Builder withApplicationName(String applicationName) {
            this.applicationName = applicationName;
            return this;
        }

        public Builder withEndpoint(String endpoint) {
            this.endpoint = endpoint;
            return this;
        }

        private void clearAuthentication() {
            this.oAuth2Credential = null;
        }

        @Override
        public DfpSession build() throws ValidationException {
            this.defaultOptionals();
            this.validate();
            return new DfpSession(this, null);
        }

        private void defaultOptionals() {
            if (this.endpoint == null) {
                this.endpoint = DfpSession.DEFAULT_ENDPOINT;
            }
        }

        private void validate() throws ValidationException {
            if (this.oAuth2Credential == null) {
                throw new ValidationException("OAuth2 authentication must be used.", "");
            }
            if (Strings.isNullOrEmpty((String)this.applicationName) || this.applicationName.contains(DfpSession.DEFAULT_APPLICATION_NAME)) {
                throw new ValidationException(String.format("Application name must be set and not be the default [%s]", DfpSession.DEFAULT_APPLICATION_NAME), "applicationName");
            }
            try {
                new URL(this.endpoint);
            }
            catch (MalformedURLException e) {
                throw new ValidationException(String.format("Endpoint [%s] not recognized as a valid URL.", this.endpoint), "endpoint", e);
            }
        }
    }
}

