/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.ads.common.lib.soap;

import com.google.api.ads.common.lib.soap.SoapCall;
import com.google.api.ads.common.lib.soap.SoapClientHandlerInterface;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;

public abstract class SoapClientHandler<T>
implements SoapClientHandlerInterface<T> {
    protected SoapClientHandler() {
    }

    protected Object[] processSoapArguments(Method soapClientMethod, Object[] args) {
        ArrayList argsList = new ArrayList();
        if (args == null) {
            return null;
        }
        Collections.addAll(argsList, args);
        int curretNumArgs = argsList.size();
        while (curretNumArgs < soapClientMethod.getParameterTypes().length) {
            argsList.add(null);
            ++curretNumArgs;
        }
        return argsList.toArray(new Object[0]);
    }

    @Override
    public Method getSoapClientMethod(T soapClient, Method method) throws NoSuchMethodException {
        Method[] methodArray = soapClient.getClass().getMethods();
        int n = methodArray.length;
        int n2 = 0;
        while (n2 < n) {
            Method soapClientMethod = methodArray[n2];
            if (method.getName().equals(soapClientMethod.getName()) && method.getReturnType().equals(soapClientMethod.getReturnType())) {
                return soapClientMethod;
            }
            ++n2;
        }
        throw new NoSuchMethodException("No method named " + method.getName() + " with return type " + method.getReturnType() + " found.");
    }

    protected Object invoke(SoapCall<T> soapCall) throws Exception {
        Method soapClientMethod = soapCall.getSoapClientMethod();
        Object[] soapArgs = soapCall.getSoapArgs();
        soapArgs = this.processSoapArguments(soapClientMethod, soapArgs);
        return soapClientMethod.invoke(soapCall.getSoapClient(), soapArgs);
    }
}

