/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.ads.adwords.lib.utils;

import com.google.api.ads.adwords.lib.client.AdWordsSession;
import com.google.api.ads.adwords.lib.utils.AdHocReportDownloadHelper;
import com.google.api.ads.adwords.lib.utils.AdWordsInternals;
import com.google.api.ads.adwords.lib.utils.ReportException;
import com.google.api.ads.common.lib.auth.AuthorizationHeaderProvider;
import com.google.api.ads.common.lib.exception.AuthenticationException;
import com.google.api.ads.common.lib.useragent.UserAgentCombiner;
import com.google.api.ads.common.lib.utils.Internals;
import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReportUrlConnectionHelper {
    private static final Logger logger = LoggerFactory.getLogger((String)(String.valueOf(AdHocReportDownloadHelper.class.getPackage().getName()) + ".report_download"));
    public static final String DOWNLOAD_SERVER_URI = "/api/adwords/reportdownload";
    private static final String REQUEST_METHOD = "POST";
    private final AdWordsSession session;
    private final UserAgentCombiner userAgentCombiner;
    private final AuthorizationHeaderProvider authorizationHeaderProvider;

    ReportUrlConnectionHelper(AdWordsSession session) {
        this(session, AdWordsInternals.getInstance());
    }

    @VisibleForTesting
    ReportUrlConnectionHelper(AdWordsSession session, Internals internals) {
        this(session, internals.getAuthorizationHeaderProvider(), internals.getUserAgentCombiner());
    }

    @VisibleForTesting
    ReportUrlConnectionHelper(AdWordsSession session, AuthorizationHeaderProvider authorizationHeaderProvider, UserAgentCombiner userAgentCombiner) {
        this.session = session;
        this.authorizationHeaderProvider = authorizationHeaderProvider;
        this.userAgentCombiner = userAgentCombiner;
    }

    @VisibleForTesting
    HttpURLConnection getReportHttpUrlConnection(String reportUrl) throws MalformedURLException, IOException, ReportException, AuthenticationException {
        HttpURLConnection httpUrlConnection = (HttpURLConnection)new URL(reportUrl).openConnection();
        httpUrlConnection.setRequestMethod(REQUEST_METHOD);
        logger.info("{} {}", (Object)REQUEST_METHOD, (Object)reportUrl);
        httpUrlConnection.setRequestProperty("Authorization", this.authorizationHeaderProvider.getAuthorizationHeader(this.session, reportUrl));
        String userAgent = this.userAgentCombiner.getUserAgent(this.session.getUserAgent());
        httpUrlConnection.setRequestProperty("User-Agent", userAgent);
        logger.info("User-Agent: {}", (Object)userAgent);
        httpUrlConnection.setRequestProperty("developerToken", this.session.getDeveloperToken());
        logger.info("developerToken: {}", (Object)this.session.getDeveloperToken());
        httpUrlConnection.setRequestProperty("clientCustomerId", this.session.getClientCustomerId());
        logger.info("clientCustomerId: {}", (Object)this.session.getClientCustomerId());
        httpUrlConnection.setRequestProperty("returnMoneyInMicros", Boolean.toString(this.session.isReportMoneyInMicros()));
        logger.info("returnMoneyInMicros: {}", (Object)this.session.isReportMoneyInMicros());
        return httpUrlConnection;
    }
}

