/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.ads.adwords.lib.client.reporting;

import com.google.common.annotations.VisibleForTesting;
import javax.annotation.Nullable;

public class ReportingConfiguration {
    @VisibleForTesting
    static final String MINIMUM_REPORTING_CONFIGURATION_VERSION = "v201409";
    private Boolean isSkipReportHeader;
    private Boolean isSkipReportSummary;

    private ReportingConfiguration() {
    }

    private ReportingConfiguration(ReportingConfiguration configToClone) {
        this.isSkipReportHeader = configToClone.isSkipReportHeader;
        this.isSkipReportSummary = configToClone.isSkipReportSummary;
    }

    @Nullable
    public Boolean isSkipReportHeader() {
        return this.isSkipReportHeader;
    }

    @Nullable
    public Boolean isSkipReportSummary() {
        return this.isSkipReportSummary;
    }

    public void validate(@Nullable String version) {
        if (version != null && MINIMUM_REPORTING_CONFIGURATION_VERSION.compareTo(version) > 0) {
            throw new IllegalArgumentException(String.format("ReportingConfiguration options are not supported in version %s. See %s for details.", version, "https://developers.google.com/adwords/api/docs/guides/reporting"));
        }
    }

    /* synthetic */ ReportingConfiguration(ReportingConfiguration reportingConfiguration, ReportingConfiguration reportingConfiguration2) {
        this();
    }

    /* synthetic */ ReportingConfiguration(ReportingConfiguration reportingConfiguration, ReportingConfiguration reportingConfiguration2, ReportingConfiguration reportingConfiguration3) {
        this(reportingConfiguration);
    }

    public static class Builder {
        private ReportingConfiguration reportingConfiguration = new ReportingConfiguration(null, null);

        public Builder skipReportHeader(Boolean isSkipReportHeader) {
            this.reportingConfiguration.isSkipReportHeader = isSkipReportHeader;
            return this;
        }

        public Builder skipReportSummary(Boolean isSkipReportSummary) {
            this.reportingConfiguration.isSkipReportSummary = isSkipReportSummary;
            return this;
        }

        public ReportingConfiguration build() {
            ReportingConfiguration configToReturn = this.reportingConfiguration;
            this.reportingConfiguration = new ReportingConfiguration(configToReturn, null, null);
            return configToReturn;
        }
    }
}

