/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.ads.common.lib.auth;

import com.google.api.ads.common.lib.auth.CaptchaInformation;
import com.google.api.ads.common.lib.auth.ClientLogin;
import com.google.api.ads.common.lib.conf.ConfigurationHelper;
import com.google.api.ads.common.lib.conf.ConfigurationLoadException;
import com.google.api.ads.common.lib.exception.ClientLoginException;
import com.google.api.ads.common.lib.exception.ValidationException;
import com.google.api.ads.common.lib.utils.Streams;
import com.google.api.client.googleapis.auth.clientlogin.ClientLoginResponseException;
import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.http.javanet.NetHttpTransport;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Strings;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import org.apache.commons.configuration.Configuration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClientLoginTokens {
    @Deprecated
    public static final String ADWORDS_SERVICE = "adwords";
    @Deprecated
    public static final String DFP_SERVICE = "gam";
    @Deprecated
    private static final String ADWORDS_PROP_KEY_PREFIX = "api.adwords.";
    @Deprecated
    private static final String DFP_PROP_KEY_PREFIX = "api.dfp.";
    @Deprecated
    private static final String RESOURCE_PROPERTIES_NAME = "ads.properties";
    private static final int HTTP_CLIENT_SOCKET_TIMEOUT_IN_MS = (int)TimeUnit.SECONDS.toMillis(20L);
    private static final String AUTH_TOKEN_KEY = "Auth";
    private static final String ERROR_KEY = "Error";
    private static final String URL_KEY = "Url";
    private static final String CAPTCHA_TOKEN_KEY = "CaptchaToken";
    private static final String CAPTCHA_URL_KEY = "CaptchaUrl";
    private static final String CAPTCHA_REQUIRED_ERROR = "CaptchaRequired";
    private static final String DEFAULT_CLIENT_LOGIN_SERVER_URL = "https://www.google.com/accounts/ClientLogin";
    private static final String INFO_KEY = "Info";
    private static final String SOURCE = "Ads-Api-Java-Lib";
    @Deprecated
    private String service;
    @Deprecated
    private ConfigurationHelper configHelper;
    @Deprecated
    private String clientLoginServerUrl = "https://www.google.com/accounts/ClientLogin";
    @VisibleForTesting
    ClientLogin clientLogin;
    private String clientLoginTokenOverride;

    @Deprecated
    @VisibleForTesting
    String getPropertyKey(String suffix) {
        if (ADWORDS_SERVICE.equalsIgnoreCase(this.service)) {
            return ADWORDS_PROP_KEY_PREFIX + suffix;
        }
        if (DFP_SERVICE.equalsIgnoreCase(this.service)) {
            return DFP_PROP_KEY_PREFIX + suffix;
        }
        return suffix;
    }

    @VisibleForTesting
    ClientLoginTokens(ClientLogin clientLogin) {
        this.clientLogin = clientLogin;
    }

    @Deprecated
    public ClientLoginTokens(String service) {
        this(service, new ConfigurationHelper());
    }

    private ClientLoginTokens(String service, ConfigurationHelper helper) {
        this.service = service;
        this.configHelper = helper;
    }

    @Deprecated
    public String fromFile() throws ClientLoginException, ConfigurationLoadException {
        return this.fromFile(RESOURCE_PROPERTIES_NAME);
    }

    @Deprecated
    public String fromFile(String path) throws ClientLoginException, ConfigurationLoadException {
        return this.from(this.configHelper.fromFile(path));
    }

    @Deprecated
    public String fromFile(File path) throws ClientLoginException, ConfigurationLoadException {
        return this.from(this.configHelper.fromFile(path));
    }

    @Deprecated
    public String fromFile(URL path) throws ClientLoginException, ConfigurationLoadException {
        return this.from(this.configHelper.fromFile(path));
    }

    @Deprecated
    public String from(Configuration config) throws ClientLoginException {
        if (config.getString(this.getPropertyKey("clientLoginToken")) != null) {
            return config.getString(this.getPropertyKey("clientLoginToken"));
        }
        if (config.getString(this.getPropertyKey("email")) != null && config.getString(this.getPropertyKey("password")) != null) {
            return this.from(config.getString(this.getPropertyKey("email")), config.getString(this.getPropertyKey("password")));
        }
        throw new IllegalArgumentException("Expected Configuration to contain either a clientLoginToken or an email and password.");
    }

    @Deprecated
    public String from(String email, String password) throws ClientLoginException {
        return this.from(email, password, null, null);
    }

    @Deprecated
    public String from(String email, String password, String loginToken, String loginCaptcha) throws ClientLoginException {
        return this.deprecatedRequestToken(email, password, loginToken, loginCaptcha);
    }

    public String requestToken(String captchaToken, String captchaAnswer) throws ClientLoginResponseException, IOException {
        if (this.clientLogin == null) {
            throw new IllegalStateException("requestToken() and requestToken(captchaToken, captchaAnswer) can only be used with ClientLoginTokens created from ClientLogin.Builder");
        }
        try {
            this.clientLogin.setCaptchaAnswer(captchaAnswer);
            this.clientLogin.setCaptchaToken(captchaToken);
            String string = this.requestToken();
            return string;
        }
        finally {
            this.clientLogin.setCaptchaAnswer(null);
            this.clientLogin.setCaptchaToken(null);
        }
    }

    public String getToken() throws ClientLoginResponseException, IOException {
        return this.clientLoginTokenOverride != null && this.clientLoginTokenOverride.trim().length() > 0 ? this.clientLoginTokenOverride : this.requestToken();
    }

    public String requestToken() throws ClientLoginResponseException, IOException {
        if (this.clientLogin == null) {
            throw new IllegalStateException("requestToken() and requestToken(captchaToken, captchaAnswer) can only be used with ClientLoginTokens created from ClientLogin.Builder");
        }
        return this.clientLogin.requestToken();
    }

    @Deprecated
    private String deprecatedRequestToken(String email, String password, String loginToken, String loginCaptcha) throws ClientLoginException {
        if (!Strings.isNullOrEmpty((String)this.clientLoginTokenOverride)) {
            return this.clientLoginTokenOverride;
        }
        try {
            HttpURLConnection conn = this.postToClientLogin(email, password, loginToken, loginCaptcha);
            int statusCode = conn.getResponseCode();
            String responseBody = Streams.readAll(statusCode == 200 ? conn.getInputStream() : conn.getErrorStream());
            Properties responseProperties = ClientLoginTokens.generatePropertiesFromResponse(Streams.wrapString(responseBody));
            if (statusCode == 200) {
                if (responseProperties.containsKey(AUTH_TOKEN_KEY)) {
                    return responseProperties.getProperty(AUTH_TOKEN_KEY).toString();
                }
                throw new IllegalStateException("Unable to get auth token from Client Login server");
            }
            CaptchaInformation captchaInfo = null;
            String errorCode = null;
            if (responseProperties.containsKey(ERROR_KEY)) {
                errorCode = responseProperties.getProperty(ERROR_KEY);
                if (errorCode != null && errorCode.equals(CAPTCHA_REQUIRED_ERROR)) {
                    captchaInfo = this.extractCaptchaInfoFromProperties(responseProperties);
                }
                if (responseProperties.getProperty(INFO_KEY) != null) {
                    errorCode = String.valueOf(errorCode) + ": " + responseProperties.getProperty(INFO_KEY);
                }
            }
            throw new ClientLoginException(statusCode, responseBody, errorCode, captchaInfo, null);
        }
        catch (IOException e) {
            throw new ClientLoginException(null, null, null, null, e);
        }
    }

    @Deprecated
    private HttpURLConnection postToClientLogin(String email, String password, String loginToken, String loginCaptcha) throws IOException {
        HttpURLConnection conn = this.getConnection("POST");
        TreeMap<String, String> params = new TreeMap<String, String>();
        params.put("Email", email);
        params.put("Passwd", password);
        params.put("accountType", "GOOGLE");
        params.put("service", this.service);
        params.put("source", SOURCE);
        if (loginToken != null) {
            params.put("logintoken", loginToken);
        }
        if (loginCaptcha != null) {
            params.put("logincaptcha", loginCaptcha);
        }
        String payload = this.generateParamsPayload(params);
        Streams.write(payload, conn.getOutputStream());
        conn.connect();
        return conn;
    }

    @Deprecated
    private HttpURLConnection getConnection(String requestMethod) throws IOException {
        HttpURLConnection conn = (HttpURLConnection)new URL(this.clientLoginServerUrl).openConnection();
        conn.setConnectTimeout(HTTP_CLIENT_SOCKET_TIMEOUT_IN_MS);
        conn.setRequestMethod(requestMethod);
        if ("POST".equalsIgnoreCase(requestMethod)) {
            conn.setDoOutput(true);
        }
        return conn;
    }

    @Deprecated
    private String generateParamsPayload(Map<String, String> params) {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, String> entry : params.entrySet()) {
            if (sb.length() > 0) {
                sb.append("&");
            }
            try {
                sb.append(entry.getKey()).append("=").append(URLEncoder.encode(entry.getValue(), "UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                throw new IllegalStateException("UTF-8 should be a supported encoding.", e);
            }
        }
        return sb.toString();
    }

    @Deprecated
    private CaptchaInformation extractCaptchaInfoFromProperties(Properties authProperties) {
        String captchaUrl = String.valueOf(this.clientLoginServerUrl) + authProperties.getProperty(CAPTCHA_URL_KEY);
        String captchaToken = authProperties.getProperty(CAPTCHA_TOKEN_KEY);
        String url = authProperties.getProperty(URL_KEY);
        return new CaptchaInformation(captchaUrl, captchaToken, url);
    }

    @Deprecated
    private static Properties generatePropertiesFromResponse(InputStream responseBodyStream) throws IOException {
        Properties properties = new Properties();
        properties.load(responseBodyStream);
        return properties;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Api {
        ADWORDS("adwords", "api.adwords."),
        DFP("gam", "api.dfp.");

        private final String service;
        private final String propKeyPrefix;

        private Api(String service, String propKeyPrefix) {
            this.service = service;
            this.propKeyPrefix = propKeyPrefix;
        }

        public String getService() {
            return this.service;
        }

        public String getPropKeyPrefix() {
            return this.propKeyPrefix;
        }
    }

    public static class Builder {
        private final ForApiBuilder forApiBuilder = new ForApiBuilder();

        public ForApiBuilder forApi(Api api) {
            this.forApiBuilder.api = api;
            return this.forApiBuilder;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ForApiBuilder
    implements com.google.api.ads.common.lib.utils.Builder<ClientLoginTokens> {
        private static final HttpTransport DEFAULT_HTTP_TRANSPORT = new NetHttpTransport();
        @VisibleForTesting
        final ConfigurationHelper configHelper;
        private final ClientLoginTokens clientLoginTokens;
        @VisibleForTesting
        Api api;

        private ForApiBuilder() {
            this(new ConfigurationHelper(), new ClientLogin());
        }

        @VisibleForTesting
        ForApiBuilder(ConfigurationHelper configHelper, ClientLogin clientLogin) {
            this.configHelper = configHelper;
            this.clientLoginTokens = new ClientLoginTokens(clientLogin);
        }

        public ForApiBuilder fromFile(String path) throws ConfigurationLoadException {
            return this.from(this.configHelper.fromFile(path));
        }

        public ForApiBuilder fromFile(File path) throws ConfigurationLoadException {
            return this.from(this.configHelper.fromFile(path));
        }

        public ForApiBuilder fromFile(URL path) throws ConfigurationLoadException {
            return this.from(this.configHelper.fromFile(path));
        }

        public ForApiBuilder fromFile() throws ConfigurationLoadException {
            return this.fromFile(ClientLoginTokens.RESOURCE_PROPERTIES_NAME);
        }

        public ForApiBuilder from(Configuration config) {
            this.clientLoginTokens.clientLoginTokenOverride = config.getString(this.getPropertyKey("clientLoginToken"), null);
            this.clientLoginTokens.clientLogin.setUsername(config.getString(this.getPropertyKey("email"), null));
            this.clientLoginTokens.clientLogin.setPassword(config.getString(this.getPropertyKey("password"), null));
            String clientLoginServerUrl = config.getString("clientLoginServerUrl", null);
            if (!Strings.isNullOrEmpty((String)clientLoginServerUrl)) {
                this.clientLoginTokens.clientLoginServerUrl = clientLoginServerUrl;
                this.clientLoginTokens.clientLogin.setServerUrl(new GenericUrl(clientLoginServerUrl));
            }
            return this;
        }

        public ForApiBuilder withEmailAndPassword(String email, String password) {
            this.clientLoginTokens.clientLogin.setUsername(email);
            this.clientLoginTokens.clientLogin.setPassword(password);
            return this;
        }

        public ForApiBuilder withHttpTransport(HttpTransport httpTransport) {
            this.clientLoginTokens.clientLogin.setTransport(httpTransport);
            return this;
        }

        public ForApiBuilder withClientLoginServerUrl(String serverUrl) {
            this.clientLoginTokens.clientLoginServerUrl = serverUrl;
            this.clientLoginTokens.clientLogin.setServerUrl(new GenericUrl(serverUrl));
            return this;
        }

        private void validate() throws ValidationException {
            if (!(Strings.isNullOrEmpty((String)this.clientLoginTokens.clientLoginTokenOverride) || Strings.isNullOrEmpty((String)this.clientLoginTokens.clientLogin.getUsername()) && Strings.isNullOrEmpty((String)this.clientLoginTokens.clientLogin.getPassword()))) {
                throw new ValidationException("Email and password or client login token should be set. Not both.", "");
            }
            if (Strings.isNullOrEmpty((String)this.clientLoginTokens.clientLoginTokenOverride) && (Strings.isNullOrEmpty((String)this.clientLoginTokens.clientLogin.getUsername()) || Strings.isNullOrEmpty((String)this.clientLoginTokens.clientLogin.getPassword()))) {
                throw new ValidationException("Email and password or client login token must be set.", "");
            }
        }

        @Override
        public ClientLoginTokens build() throws ValidationException {
            this.validate();
            if (this.clientLoginTokens.clientLogin.getTransport() == null) {
                this.clientLoginTokens.clientLogin.setTransport(DEFAULT_HTTP_TRANSPORT);
            }
            this.clientLoginTokens.clientLogin.setAccountType("GOOGLE");
            this.clientLoginTokens.clientLogin.setAuthTokenType(this.api.getService());
            return this.clientLoginTokens;
        }

        @VisibleForTesting
        String getPropertyKey(String suffix) {
            return String.valueOf(this.api.getPropKeyPrefix()) + suffix;
        }
    }
}

