/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.ads.dfp.lib.factory;

import com.google.api.ads.common.lib.exception.ValidationException;
import com.google.api.ads.common.lib.factory.FactoryConfiguration;
import com.google.api.ads.dfp.lib.DfpModule;
import com.google.api.ads.dfp.lib.client.DfpSession;
import com.google.api.ads.dfp.lib.factory.DfpServiceClientFactory;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Throwables;
import org.apache.commons.configuration.ConfigurationException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DfpServices {
    private final DfpServiceClientFactory factory;

    public DfpServices() {
        FactoryConfiguration factoryConfiguration = null;
        try {
            factoryConfiguration = new FactoryConfiguration.Builder().fromFile().build();
        }
        catch (IllegalArgumentException e) {
            if (!(Throwables.getRootCause((Throwable)e) instanceof ConfigurationException)) {
                throw new IllegalStateException(e);
            }
        }
        catch (ValidationException e) {
            throw new IllegalStateException("A SOAP module specified in your properties file is invalid.", e);
        }
        this.factory = factoryConfiguration == null ? new DfpServiceClientFactory() : new DfpServiceClientFactory(new DfpModule(factoryConfiguration));
    }

    @VisibleForTesting
    DfpServices(DfpServiceClientFactory factory) {
        this.factory = factory;
    }

    public DfpServices(FactoryConfiguration factoryConfiguration) {
        this.factory = new DfpServiceClientFactory(new DfpModule(factoryConfiguration));
    }

    public <T> T get(DfpSession dfpSession, Class<T> interfaceClass) {
        return this.factory.getServiceClientAsInterface(dfpSession, interfaceClass);
    }
}

