/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.ads.common.lib.utils;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MapUtils {
    public <K, V, T> Map<K, V> toMap(T[] entryArray) throws IllegalArgumentException {
        Method getValueMethod;
        Method getKeyMethod;
        if (entryArray == null) {
            throw new IllegalArgumentException("entryArray cannot be null.");
        }
        Class<?> clazz = entryArray.getClass().getComponentType();
        try {
            getKeyMethod = clazz.getMethod("getKey", new Class[0]);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException("The entry type [" + clazz.toString() + "] is not compatible because a getKey() method was not found.", e);
        }
        try {
            getValueMethod = clazz.getMethod("getValue", new Class[0]);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException("The entry type [" + clazz.toString() + "] is not compatible because a getValue() method was not found.", e);
        }
        HashMap<Object, Object> result = new HashMap<Object, Object>();
        T[] TArray = entryArray;
        int n = entryArray.length;
        int n2 = 0;
        while (n2 < n) {
            T entry = TArray[n2];
            try {
                Object key = null;
                try {
                    key = getKeyMethod.invoke(entry, new Object[0]);
                }
                catch (IllegalAccessException e) {
                    throw new IllegalStateException("The entry type [" + entry.getClass().toString() + "] is not compatible because the getKey()" + " method could not be accessed.", e);
                }
                Object value = null;
                try {
                    value = getValueMethod.invoke(entry, new Object[0]);
                }
                catch (IllegalAccessException e) {
                    throw new IllegalStateException("The entry type [" + entry.getClass().toString() + "] is not compatible because the getValue()" + " method could not be accessed.", e);
                }
                result.put(key, value);
            }
            catch (InvocationTargetException e) {
                throw new IllegalStateException("Unexpected exception while creating map: " + e.getMessage(), e);
            }
            ++n2;
        }
        return result;
    }

    public <K, V, T> T[] toArray(Map<K, V> map, T[] a) {
        Method setValueMethod;
        Method setKeyMethod;
        Class<?> clazz = a.getClass().getComponentType();
        if (clazz == null) {
            throw new IllegalStateException("Component type for array parameter not found.");
        }
        try {
            setKeyMethod = this.findMethod("setKey", clazz);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException("The entry type [" + clazz.toString() + "] is not compatible because a setKey() method was not found.", e);
        }
        try {
            setValueMethod = this.findMethod("setValue", clazz);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException("The entry type [" + clazz.toString() + "] is not compatible because a setValue() method was not found.", e);
        }
        ArrayList<Object> result = new ArrayList<Object>();
        for (Map.Entry<K, V> entry : map.entrySet()) {
            try {
                Object newEntry = null;
                try {
                    newEntry = clazz.newInstance();
                }
                catch (InstantiationException e) {
                    throw new IllegalStateException("Unexpected exception: could not create map entry of type " + clazz.toString(), e);
                }
                catch (IllegalAccessException e) {
                    throw new IllegalStateException("Unexpected exception: could not create map entry of type " + clazz.toString(), e);
                }
                try {
                    setKeyMethod.invoke(newEntry, entry.getKey());
                }
                catch (IllegalArgumentException e) {
                    throw new IllegalArgumentException("The entry type [" + newEntry.getClass().toString() + "] is not compatible because the setKey() method could not take a type [" + entry.getKey().getClass() + "]", e);
                }
                catch (IllegalAccessException e) {
                    throw new IllegalArgumentException("The entry type [" + newEntry.getClass().toString() + "] is not compatible because a setKey() method could not be accessed.", e);
                }
                try {
                    setValueMethod.invoke(newEntry, entry.getValue());
                }
                catch (IllegalArgumentException e) {
                    throw new IllegalArgumentException("The entry type [" + newEntry.getClass().toString() + "] is not compatible because the setValue() method could not take a type " + entry.getValue().getClass(), e);
                }
                catch (IllegalAccessException e) {
                    throw new IllegalArgumentException("The entry type [" + newEntry.getClass().toString() + "] is not compatible because the setValue() method could not be accessed.", e);
                }
                result.add(newEntry);
            }
            catch (InvocationTargetException e) {
                new IllegalStateException("Unexpected exception while creating array: " + e.getMessage(), e);
            }
        }
        return result.toArray(a);
    }

    private <T> Method findMethod(String methodName, Class<T> clazz) throws NoSuchMethodException {
        Method[] methodArray = clazz.getMethods();
        int n = methodArray.length;
        int n2 = 0;
        while (n2 < n) {
            Method method = methodArray[n2];
            if (method.getName().equals(methodName)) {
                return method;
            }
            ++n2;
        }
        throw new NoSuchMethodException("A " + methodName + "() method in type [" + clazz.toString() + "] could not be found");
    }
}

