/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.ads.common.lib.utils;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;

public final class ImageUtils {
    public byte[] getImageDataFromFile(String fileName) throws IOException {
        return this.getByteArrayFromStream(new BufferedInputStream(new FileInputStream(new File(fileName))));
    }

    public byte[] getImageDataFromUrl(String url) throws IOException {
        return this.getByteArrayFromStream(new BufferedInputStream(new URL(url).openStream()));
    }

    private byte[] getByteArrayFromStream(InputStream inputStream) throws IOException {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        try {
            int i = 0;
            while ((i = inputStream.read()) != -1) {
                outputStream.write(i);
            }
        }
        finally {
            if (inputStream != null) {
                inputStream.close();
            }
            if (outputStream != null) {
                outputStream.close();
            }
        }
        return outputStream.toByteArray();
    }
}

