/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.ads.common.lib.soap.axis;

import com.google.api.client.http.ByteArrayContent;
import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.HttpContent;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestFactory;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.http.javanet.NetHttpTransport;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.io.ByteStreams;
import java.io.ByteArrayOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.zip.GZIPOutputStream;
import javax.xml.soap.SOAPException;
import org.apache.axis.AxisFault;
import org.apache.axis.Constants;
import org.apache.axis.Message;
import org.apache.axis.MessageContext;
import org.apache.axis.handlers.BasicHandler;
import org.apache.axis.utils.Messages;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpHandler
extends BasicHandler
implements HttpRequestInitializer {
    private static final Logger logger = LoggerFactory.getLogger(HttpHandler.class);
    private final HttpRequestFactory requestFactory;
    private final InputStreamEventListener inputStreamEventListener;
    private static final HttpTransport defaultHttpTransport = new NetHttpTransport();

    public HttpHandler() {
        this(defaultHttpTransport, null);
    }

    @VisibleForTesting
    HttpHandler(HttpTransport transport, InputStreamEventListener inputStreamEventListener) {
        this.requestFactory = transport.createRequestFactory((HttpRequestInitializer)this);
        this.inputStreamEventListener = inputStreamEventListener;
    }

    public void invoke(MessageContext msgContext) throws AxisFault {
        if (msgContext == null) {
            throw AxisFault.makeFault((Exception)new NullPointerException("Null message context"));
        }
        try {
            HttpResponse response = null;
            HttpRequest postRequest = this.createHttpRequest(msgContext);
            response = postRequest.execute();
            msgContext.setResponseMessage(this.createResponseMessage(response));
        }
        catch (Exception e) {
            throw AxisFault.makeFault((Exception)e);
        }
    }

    public void initialize(HttpRequest httpRequest) throws IOException {
        httpRequest.setThrowExceptionOnExecuteError(false);
        httpRequest.setFollowRedirects(false);
        httpRequest.setNumberOfRetries(0);
    }

    private HttpRequest createHttpRequest(MessageContext msgContext) throws SOAPException, IOException {
        Message requestMessage = (Message)Preconditions.checkNotNull((Object)msgContext.getRequestMessage(), (Object)"Null request message on message context");
        String contentType = requestMessage.getContentType(msgContext.getSOAPConstants());
        int contentLength = Long.valueOf(requestMessage.getContentLength()).intValue();
        ByteArrayOutputStream bos = contentLength > 0 ? new ByteArrayOutputStream(contentLength) : new ByteArrayOutputStream();
        if (msgContext.isPropertyTrue("transport.http.gzipRequest")) {
            logger.debug("Compressing request");
            try (GZIPOutputStream gzipOs = new GZIPOutputStream(bos);){
                requestMessage.writeTo((OutputStream)gzipOs);
            }
        } else {
            logger.debug("Not compressing request");
            requestMessage.writeTo((OutputStream)bos);
        }
        HttpRequest httpRequest = this.requestFactory.buildPostRequest(new GenericUrl(msgContext.getStrProp("transport.url")), (HttpContent)new ByteArrayContent(contentType, bos.toByteArray()));
        int timeoutMillis = msgContext.getTimeout();
        if (timeoutMillis >= 0) {
            logger.debug("Setting read and connect timeout to {} millis", (Object)timeoutMillis);
            httpRequest.setReadTimeout(timeoutMillis);
            httpRequest.setConnectTimeout(timeoutMillis);
        }
        this.setHttpRequestHeaders(msgContext, httpRequest);
        return httpRequest;
    }

    private void setHttpRequestHeaders(MessageContext msgContext, HttpRequest httpRequest) {
        Map requestHeaders = (Map)msgContext.getProperty("HTTP-Request-Headers");
        if (requestHeaders != null) {
            for (Map.Entry headerEntry : requestHeaders.entrySet()) {
                Object headerKey = headerEntry.getKey();
                if (headerKey == null) continue;
                String headerName = headerKey.toString().trim();
                Object headerValue = headerEntry.getValue();
                if ("Authorization".equals(headerName) && headerValue instanceof String) {
                    httpRequest.getHeaders().setAuthorization((String)headerValue);
                    continue;
                }
                httpRequest.getHeaders().set(headerName, headerValue);
            }
        }
        if (msgContext.isPropertyTrue("transport.http.gzipRequest")) {
            httpRequest.getHeaders().setContentEncoding("gzip");
        }
    }

    private Message createResponseMessage(HttpResponse httpResponse) throws IOException, AxisFault {
        int statusCode = httpResponse.getStatusCode();
        String contentType = httpResponse.getContentType();
        boolean shouldParseResponse = statusCode > 199 && statusCode < 300 || contentType != null && !contentType.equals("text/html") && statusCode > 499 && statusCode < 600;
        NotifyingInputStream responseInputStream = new NotifyingInputStream(httpResponse.getContent(), this.inputStreamEventListener);
        if (!shouldParseResponse) {
            byte[] contentBytes;
            String statusMessage = httpResponse.getStatusMessage();
            AxisFault axisFault = new AxisFault("HTTP", "(" + statusCode + ")" + statusMessage, null, null);
            try (NotifyingInputStream stream = responseInputStream;){
                contentBytes = ByteStreams.toByteArray((InputStream)stream);
            }
            axisFault.setFaultDetailString(Messages.getMessage((String)"return01", (String)Integer.toString(statusCode), (String)new String(contentBytes, StandardCharsets.UTF_8)));
            axisFault.addFaultDetail(Constants.QNAME_FAULTDETAIL_HTTPERRORCODE, Integer.toString(statusCode));
            throw axisFault;
        }
        Message responseMessage = new Message((Object)responseInputStream, false, contentType, httpResponse.getHeaders().getLocation());
        responseMessage.setMessageType("response");
        return responseMessage;
    }

    private static class NotifyingInputStream
    extends FilterInputStream {
        private final InputStreamEventListener inputStreamEventListener;

        public NotifyingInputStream(InputStream inputStream, InputStreamEventListener inputStreamEventListener) {
            super(inputStream);
            this.inputStreamEventListener = inputStreamEventListener;
            if (this.inputStreamEventListener != null) {
                this.inputStreamEventListener.afterCreate();
            }
        }

        @Override
        public void close() throws IOException {
            if (this.inputStreamEventListener != null) {
                this.inputStreamEventListener.afterClose();
            }
            super.close();
        }
    }

    @VisibleForTesting
    static interface InputStreamEventListener {
        public void afterCreate();

        public void afterClose();
    }
}

