/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.admanager.v1.stub;

import com.google.ads.admanager.v1.CustomField;
import com.google.ads.admanager.v1.CustomFieldServiceClient;
import com.google.ads.admanager.v1.GetCustomFieldRequest;
import com.google.ads.admanager.v1.ListCustomFieldsRequest;
import com.google.ads.admanager.v1.ListCustomFieldsResponse;
import com.google.ads.admanager.v1.stub.CustomFieldServiceStub;
import com.google.ads.admanager.v1.stub.CustomFieldServiceStubSettings;
import com.google.ads.admanager.v1.stub.HttpJsonCustomFieldServiceCallableFactory;
import com.google.api.core.InternalApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.httpjson.ApiMethodDescriptor;
import com.google.api.gax.httpjson.HttpJsonCallSettings;
import com.google.api.gax.httpjson.HttpJsonStubCallableFactory;
import com.google.api.gax.httpjson.HttpRequestFormatter;
import com.google.api.gax.httpjson.HttpResponseParser;
import com.google.api.gax.httpjson.ProtoMessageRequestFormatter;
import com.google.api.gax.httpjson.ProtoMessageResponseParser;
import com.google.api.gax.httpjson.ProtoRestSerializer;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.RequestParamsBuilder;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.protobuf.Message;
import com.google.protobuf.TypeRegistry;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class HttpJsonCustomFieldServiceStub
extends CustomFieldServiceStub {
    private static final TypeRegistry typeRegistry = TypeRegistry.newBuilder().build();
    private static final ApiMethodDescriptor<GetCustomFieldRequest, CustomField> getCustomFieldMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.ads.admanager.v1.CustomFieldService/GetCustomField").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{name=networks/*/customFields/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)CustomField.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<ListCustomFieldsRequest, ListCustomFieldsResponse> listCustomFieldsMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.ads.admanager.v1.CustomFieldService/ListCustomFields").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{parent=networks/*}/customFields", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parent", (Object)request.getParent());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "filter", (Object)request.getFilter());
        serializer.putQueryParam(fields, "orderBy", (Object)request.getOrderBy());
        serializer.putQueryParam(fields, "pageSize", (Object)request.getPageSize());
        serializer.putQueryParam(fields, "pageToken", (Object)request.getPageToken());
        serializer.putQueryParam(fields, "skip", (Object)request.getSkip());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)ListCustomFieldsResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private final UnaryCallable<GetCustomFieldRequest, CustomField> getCustomFieldCallable;
    private final UnaryCallable<ListCustomFieldsRequest, ListCustomFieldsResponse> listCustomFieldsCallable;
    private final UnaryCallable<ListCustomFieldsRequest, CustomFieldServiceClient.ListCustomFieldsPagedResponse> listCustomFieldsPagedCallable;
    private final BackgroundResource backgroundResources;
    private final HttpJsonStubCallableFactory callableFactory;

    public static final HttpJsonCustomFieldServiceStub create(CustomFieldServiceStubSettings settings) throws IOException {
        return new HttpJsonCustomFieldServiceStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final HttpJsonCustomFieldServiceStub create(ClientContext clientContext) throws IOException {
        return new HttpJsonCustomFieldServiceStub(CustomFieldServiceStubSettings.newBuilder().build(), clientContext);
    }

    public static final HttpJsonCustomFieldServiceStub create(ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        return new HttpJsonCustomFieldServiceStub(CustomFieldServiceStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected HttpJsonCustomFieldServiceStub(CustomFieldServiceStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new HttpJsonCustomFieldServiceCallableFactory());
    }

    protected HttpJsonCustomFieldServiceStub(CustomFieldServiceStubSettings settings, ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        HttpJsonCallSettings getCustomFieldTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(getCustomFieldMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        HttpJsonCallSettings listCustomFieldsTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(listCustomFieldsMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        this.getCustomFieldCallable = callableFactory.createUnaryCallable(getCustomFieldTransportSettings, settings.getCustomFieldSettings(), clientContext);
        this.listCustomFieldsCallable = callableFactory.createUnaryCallable(listCustomFieldsTransportSettings, settings.listCustomFieldsSettings(), clientContext);
        this.listCustomFieldsPagedCallable = callableFactory.createPagedCallable(listCustomFieldsTransportSettings, settings.listCustomFieldsSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    @InternalApi
    public static List<ApiMethodDescriptor> getMethodDescriptors() {
        ArrayList<ApiMethodDescriptor> methodDescriptors = new ArrayList<ApiMethodDescriptor>();
        methodDescriptors.add(getCustomFieldMethodDescriptor);
        methodDescriptors.add(listCustomFieldsMethodDescriptor);
        return methodDescriptors;
    }

    @Override
    public UnaryCallable<GetCustomFieldRequest, CustomField> getCustomFieldCallable() {
        return this.getCustomFieldCallable;
    }

    @Override
    public UnaryCallable<ListCustomFieldsRequest, ListCustomFieldsResponse> listCustomFieldsCallable() {
        return this.listCustomFieldsCallable;
    }

    @Override
    public UnaryCallable<ListCustomFieldsRequest, CustomFieldServiceClient.ListCustomFieldsPagedResponse> listCustomFieldsPagedCallable() {
        return this.listCustomFieldsPagedCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

