/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.admanager.v1.stub;

import com.google.ads.admanager.v1.CustomField;
import com.google.ads.admanager.v1.CustomFieldServiceClient;
import com.google.ads.admanager.v1.GetCustomFieldRequest;
import com.google.ads.admanager.v1.ListCustomFieldsRequest;
import com.google.ads.admanager.v1.ListCustomFieldsResponse;
import com.google.ads.admanager.v1.stub.CustomFieldServiceStub;
import com.google.ads.admanager.v1.stub.HttpJsonCustomFieldServiceStub;
import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.ObsoleteApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;

public class CustomFieldServiceStubSettings
extends StubSettings<CustomFieldServiceStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().build();
    private final UnaryCallSettings<GetCustomFieldRequest, CustomField> getCustomFieldSettings;
    private final PagedCallSettings<ListCustomFieldsRequest, ListCustomFieldsResponse, CustomFieldServiceClient.ListCustomFieldsPagedResponse> listCustomFieldsSettings;
    private static final PagedListDescriptor<ListCustomFieldsRequest, ListCustomFieldsResponse, CustomField> LIST_CUSTOM_FIELDS_PAGE_STR_DESC = new PagedListDescriptor<ListCustomFieldsRequest, ListCustomFieldsResponse, CustomField>(){

        public String emptyToken() {
            return "";
        }

        public ListCustomFieldsRequest injectToken(ListCustomFieldsRequest payload, String token) {
            return ListCustomFieldsRequest.newBuilder((ListCustomFieldsRequest)payload).setPageToken(token).build();
        }

        public ListCustomFieldsRequest injectPageSize(ListCustomFieldsRequest payload, int pageSize) {
            return ListCustomFieldsRequest.newBuilder((ListCustomFieldsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListCustomFieldsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListCustomFieldsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<CustomField> extractResources(ListCustomFieldsResponse payload) {
            return payload.getCustomFieldsList() == null ? ImmutableList.of() : payload.getCustomFieldsList();
        }
    };
    private static final PagedListResponseFactory<ListCustomFieldsRequest, ListCustomFieldsResponse, CustomFieldServiceClient.ListCustomFieldsPagedResponse> LIST_CUSTOM_FIELDS_PAGE_STR_FACT = new PagedListResponseFactory<ListCustomFieldsRequest, ListCustomFieldsResponse, CustomFieldServiceClient.ListCustomFieldsPagedResponse>(){

        public ApiFuture<CustomFieldServiceClient.ListCustomFieldsPagedResponse> getFuturePagedResponse(UnaryCallable<ListCustomFieldsRequest, ListCustomFieldsResponse> callable, ListCustomFieldsRequest request, ApiCallContext context, ApiFuture<ListCustomFieldsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_CUSTOM_FIELDS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return CustomFieldServiceClient.ListCustomFieldsPagedResponse.createAsync((PageContext<ListCustomFieldsRequest, ListCustomFieldsResponse, CustomField>)pageContext, futureResponse);
        }
    };

    public UnaryCallSettings<GetCustomFieldRequest, CustomField> getCustomFieldSettings() {
        return this.getCustomFieldSettings;
    }

    public PagedCallSettings<ListCustomFieldsRequest, ListCustomFieldsResponse, CustomFieldServiceClient.ListCustomFieldsPagedResponse> listCustomFieldsSettings() {
        return this.listCustomFieldsSettings;
    }

    public CustomFieldServiceStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonCustomFieldServiceStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public String getServiceName() {
        return "admanager";
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    @ObsoleteApi(value="Use getEndpoint() instead")
    public static String getDefaultEndpoint() {
        return "admanager.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "admanager.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return CustomFieldServiceStubSettings.defaultHttpJsonTransportProviderBuilder().build();
    }

    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(CustomFieldServiceStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected CustomFieldServiceStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.getCustomFieldSettings = settingsBuilder.getCustomFieldSettings().build();
        this.listCustomFieldsSettings = settingsBuilder.listCustomFieldsSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<CustomFieldServiceStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final UnaryCallSettings.Builder<GetCustomFieldRequest, CustomField> getCustomFieldSettings;
        private final PagedCallSettings.Builder<ListCustomFieldsRequest, ListCustomFieldsResponse, CustomFieldServiceClient.ListCustomFieldsPagedResponse> listCustomFieldsSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.getCustomFieldSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listCustomFieldsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_CUSTOM_FIELDS_PAGE_STR_FACT);
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.getCustomFieldSettings, this.listCustomFieldsSettings);
            Builder.initDefaults(this);
        }

        protected Builder(CustomFieldServiceStubSettings settings) {
            super((StubSettings)settings);
            this.getCustomFieldSettings = settings.getCustomFieldSettings.toBuilder();
            this.listCustomFieldsSettings = settings.listCustomFieldsSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.getCustomFieldSettings, this.listCustomFieldsSettings);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(CustomFieldServiceStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)CustomFieldServiceStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)CustomFieldServiceStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(CustomFieldServiceStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.getCustomFieldSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.listCustomFieldsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public UnaryCallSettings.Builder<GetCustomFieldRequest, CustomField> getCustomFieldSettings() {
            return this.getCustomFieldSettings;
        }

        public PagedCallSettings.Builder<ListCustomFieldsRequest, ListCustomFieldsResponse, CustomFieldServiceClient.ListCustomFieldsPagedResponse> listCustomFieldsSettings() {
            return this.listCustomFieldsSettings;
        }

        public CustomFieldServiceStubSettings build() throws IOException {
            return new CustomFieldServiceStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"no_retry_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setRpcTimeoutMultiplier(1.0).build();
            definitions.put((Object)"no_retry_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

