/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.admanager.v1.stub;

import com.google.ads.admanager.v1.GetMobileCarrierRequest;
import com.google.ads.admanager.v1.ListMobileCarriersRequest;
import com.google.ads.admanager.v1.ListMobileCarriersResponse;
import com.google.ads.admanager.v1.MobileCarrier;
import com.google.ads.admanager.v1.MobileCarrierServiceClient;
import com.google.ads.admanager.v1.stub.HttpJsonMobileCarrierServiceStub;
import com.google.ads.admanager.v1.stub.MobileCarrierServiceStub;
import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.ObsoleteApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;

public class MobileCarrierServiceStubSettings
extends StubSettings<MobileCarrierServiceStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/admanager").build();
    private final UnaryCallSettings<GetMobileCarrierRequest, MobileCarrier> getMobileCarrierSettings;
    private final PagedCallSettings<ListMobileCarriersRequest, ListMobileCarriersResponse, MobileCarrierServiceClient.ListMobileCarriersPagedResponse> listMobileCarriersSettings;
    private static final PagedListDescriptor<ListMobileCarriersRequest, ListMobileCarriersResponse, MobileCarrier> LIST_MOBILE_CARRIERS_PAGE_STR_DESC = new PagedListDescriptor<ListMobileCarriersRequest, ListMobileCarriersResponse, MobileCarrier>(){

        public String emptyToken() {
            return "";
        }

        public ListMobileCarriersRequest injectToken(ListMobileCarriersRequest payload, String token) {
            return ListMobileCarriersRequest.newBuilder((ListMobileCarriersRequest)payload).setPageToken(token).build();
        }

        public ListMobileCarriersRequest injectPageSize(ListMobileCarriersRequest payload, int pageSize) {
            return ListMobileCarriersRequest.newBuilder((ListMobileCarriersRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListMobileCarriersRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListMobileCarriersResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<MobileCarrier> extractResources(ListMobileCarriersResponse payload) {
            return payload.getMobileCarriersList();
        }
    };
    private static final PagedListResponseFactory<ListMobileCarriersRequest, ListMobileCarriersResponse, MobileCarrierServiceClient.ListMobileCarriersPagedResponse> LIST_MOBILE_CARRIERS_PAGE_STR_FACT = new PagedListResponseFactory<ListMobileCarriersRequest, ListMobileCarriersResponse, MobileCarrierServiceClient.ListMobileCarriersPagedResponse>(){

        public ApiFuture<MobileCarrierServiceClient.ListMobileCarriersPagedResponse> getFuturePagedResponse(UnaryCallable<ListMobileCarriersRequest, ListMobileCarriersResponse> callable, ListMobileCarriersRequest request, ApiCallContext context, ApiFuture<ListMobileCarriersResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_MOBILE_CARRIERS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return MobileCarrierServiceClient.ListMobileCarriersPagedResponse.createAsync((PageContext<ListMobileCarriersRequest, ListMobileCarriersResponse, MobileCarrier>)pageContext, futureResponse);
        }
    };

    public UnaryCallSettings<GetMobileCarrierRequest, MobileCarrier> getMobileCarrierSettings() {
        return this.getMobileCarrierSettings;
    }

    public PagedCallSettings<ListMobileCarriersRequest, ListMobileCarriersResponse, MobileCarrierServiceClient.ListMobileCarriersPagedResponse> listMobileCarriersSettings() {
        return this.listMobileCarriersSettings;
    }

    public MobileCarrierServiceStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonMobileCarrierServiceStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public String getServiceName() {
        return "admanager";
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    @ObsoleteApi(value="Use getEndpoint() instead")
    public static String getDefaultEndpoint() {
        return "admanager.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "admanager.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return MobileCarrierServiceStubSettings.defaultHttpJsonTransportProviderBuilder().build();
    }

    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(MobileCarrierServiceStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected MobileCarrierServiceStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.getMobileCarrierSettings = settingsBuilder.getMobileCarrierSettings().build();
        this.listMobileCarriersSettings = settingsBuilder.listMobileCarriersSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<MobileCarrierServiceStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final UnaryCallSettings.Builder<GetMobileCarrierRequest, MobileCarrier> getMobileCarrierSettings;
        private final PagedCallSettings.Builder<ListMobileCarriersRequest, ListMobileCarriersResponse, MobileCarrierServiceClient.ListMobileCarriersPagedResponse> listMobileCarriersSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.getMobileCarrierSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listMobileCarriersSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_MOBILE_CARRIERS_PAGE_STR_FACT);
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.getMobileCarrierSettings, this.listMobileCarriersSettings);
            Builder.initDefaults(this);
        }

        protected Builder(MobileCarrierServiceStubSettings settings) {
            super((StubSettings)settings);
            this.getMobileCarrierSettings = settings.getMobileCarrierSettings.toBuilder();
            this.listMobileCarriersSettings = settings.listMobileCarriersSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.getMobileCarrierSettings, this.listMobileCarriersSettings);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(MobileCarrierServiceStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)MobileCarrierServiceStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)MobileCarrierServiceStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(MobileCarrierServiceStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.getMobileCarrierSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.listMobileCarriersSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public UnaryCallSettings.Builder<GetMobileCarrierRequest, MobileCarrier> getMobileCarrierSettings() {
            return this.getMobileCarrierSettings;
        }

        public PagedCallSettings.Builder<ListMobileCarriersRequest, ListMobileCarriersResponse, MobileCarrierServiceClient.ListMobileCarriersPagedResponse> listMobileCarriersSettings() {
            return this.listMobileCarriersSettings;
        }

        public MobileCarrierServiceStubSettings build() throws IOException {
            return new MobileCarrierServiceStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"no_retry_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setRpcTimeoutMultiplier(1.0).build();
            definitions.put((Object)"no_retry_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

