/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.admanager.v1.stub;

import com.google.ads.admanager.v1.ContentBundle;
import com.google.ads.admanager.v1.ContentBundleServiceClient;
import com.google.ads.admanager.v1.GetContentBundleRequest;
import com.google.ads.admanager.v1.ListContentBundlesRequest;
import com.google.ads.admanager.v1.ListContentBundlesResponse;
import com.google.ads.admanager.v1.stub.ContentBundleServiceStub;
import com.google.ads.admanager.v1.stub.HttpJsonContentBundleServiceStub;
import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.ObsoleteApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;

public class ContentBundleServiceStubSettings
extends StubSettings<ContentBundleServiceStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/admanager").build();
    private final UnaryCallSettings<GetContentBundleRequest, ContentBundle> getContentBundleSettings;
    private final PagedCallSettings<ListContentBundlesRequest, ListContentBundlesResponse, ContentBundleServiceClient.ListContentBundlesPagedResponse> listContentBundlesSettings;
    private static final PagedListDescriptor<ListContentBundlesRequest, ListContentBundlesResponse, ContentBundle> LIST_CONTENT_BUNDLES_PAGE_STR_DESC = new PagedListDescriptor<ListContentBundlesRequest, ListContentBundlesResponse, ContentBundle>(){

        public String emptyToken() {
            return "";
        }

        public ListContentBundlesRequest injectToken(ListContentBundlesRequest payload, String token) {
            return ListContentBundlesRequest.newBuilder((ListContentBundlesRequest)payload).setPageToken(token).build();
        }

        public ListContentBundlesRequest injectPageSize(ListContentBundlesRequest payload, int pageSize) {
            return ListContentBundlesRequest.newBuilder((ListContentBundlesRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListContentBundlesRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListContentBundlesResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<ContentBundle> extractResources(ListContentBundlesResponse payload) {
            return payload.getContentBundlesList();
        }
    };
    private static final PagedListResponseFactory<ListContentBundlesRequest, ListContentBundlesResponse, ContentBundleServiceClient.ListContentBundlesPagedResponse> LIST_CONTENT_BUNDLES_PAGE_STR_FACT = new PagedListResponseFactory<ListContentBundlesRequest, ListContentBundlesResponse, ContentBundleServiceClient.ListContentBundlesPagedResponse>(){

        public ApiFuture<ContentBundleServiceClient.ListContentBundlesPagedResponse> getFuturePagedResponse(UnaryCallable<ListContentBundlesRequest, ListContentBundlesResponse> callable, ListContentBundlesRequest request, ApiCallContext context, ApiFuture<ListContentBundlesResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_CONTENT_BUNDLES_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return ContentBundleServiceClient.ListContentBundlesPagedResponse.createAsync((PageContext<ListContentBundlesRequest, ListContentBundlesResponse, ContentBundle>)pageContext, futureResponse);
        }
    };

    public UnaryCallSettings<GetContentBundleRequest, ContentBundle> getContentBundleSettings() {
        return this.getContentBundleSettings;
    }

    public PagedCallSettings<ListContentBundlesRequest, ListContentBundlesResponse, ContentBundleServiceClient.ListContentBundlesPagedResponse> listContentBundlesSettings() {
        return this.listContentBundlesSettings;
    }

    public ContentBundleServiceStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonContentBundleServiceStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public String getServiceName() {
        return "admanager";
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    @ObsoleteApi(value="Use getEndpoint() instead")
    public static String getDefaultEndpoint() {
        return "admanager.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "admanager.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return ContentBundleServiceStubSettings.defaultHttpJsonTransportProviderBuilder().build();
    }

    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(ContentBundleServiceStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected ContentBundleServiceStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.getContentBundleSettings = settingsBuilder.getContentBundleSettings().build();
        this.listContentBundlesSettings = settingsBuilder.listContentBundlesSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<ContentBundleServiceStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final UnaryCallSettings.Builder<GetContentBundleRequest, ContentBundle> getContentBundleSettings;
        private final PagedCallSettings.Builder<ListContentBundlesRequest, ListContentBundlesResponse, ContentBundleServiceClient.ListContentBundlesPagedResponse> listContentBundlesSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.getContentBundleSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listContentBundlesSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_CONTENT_BUNDLES_PAGE_STR_FACT);
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.getContentBundleSettings, this.listContentBundlesSettings);
            Builder.initDefaults(this);
        }

        protected Builder(ContentBundleServiceStubSettings settings) {
            super((StubSettings)settings);
            this.getContentBundleSettings = settings.getContentBundleSettings.toBuilder();
            this.listContentBundlesSettings = settings.listContentBundlesSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.getContentBundleSettings, this.listContentBundlesSettings);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(ContentBundleServiceStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)ContentBundleServiceStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)ContentBundleServiceStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(ContentBundleServiceStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.getContentBundleSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.listContentBundlesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public UnaryCallSettings.Builder<GetContentBundleRequest, ContentBundle> getContentBundleSettings() {
            return this.getContentBundleSettings;
        }

        public PagedCallSettings.Builder<ListContentBundlesRequest, ListContentBundlesResponse, ContentBundleServiceClient.ListContentBundlesPagedResponse> listContentBundlesSettings() {
            return this.listContentBundlesSettings;
        }

        public ContentBundleServiceStubSettings build() throws IOException {
            return new ContentBundleServiceStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"no_retry_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setRpcTimeoutMultiplier(1.0).build();
            definitions.put((Object)"no_retry_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

