/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.admanager.v1.stub;

import com.google.ads.admanager.v1.AudienceSegment;
import com.google.ads.admanager.v1.AudienceSegmentServiceClient;
import com.google.ads.admanager.v1.GetAudienceSegmentRequest;
import com.google.ads.admanager.v1.ListAudienceSegmentsRequest;
import com.google.ads.admanager.v1.ListAudienceSegmentsResponse;
import com.google.ads.admanager.v1.stub.AudienceSegmentServiceStub;
import com.google.ads.admanager.v1.stub.HttpJsonAudienceSegmentServiceStub;
import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.ObsoleteApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;

public class AudienceSegmentServiceStubSettings
extends StubSettings<AudienceSegmentServiceStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/admanager").build();
    private final UnaryCallSettings<GetAudienceSegmentRequest, AudienceSegment> getAudienceSegmentSettings;
    private final PagedCallSettings<ListAudienceSegmentsRequest, ListAudienceSegmentsResponse, AudienceSegmentServiceClient.ListAudienceSegmentsPagedResponse> listAudienceSegmentsSettings;
    private static final PagedListDescriptor<ListAudienceSegmentsRequest, ListAudienceSegmentsResponse, AudienceSegment> LIST_AUDIENCE_SEGMENTS_PAGE_STR_DESC = new PagedListDescriptor<ListAudienceSegmentsRequest, ListAudienceSegmentsResponse, AudienceSegment>(){

        public String emptyToken() {
            return "";
        }

        public ListAudienceSegmentsRequest injectToken(ListAudienceSegmentsRequest payload, String token) {
            return ListAudienceSegmentsRequest.newBuilder((ListAudienceSegmentsRequest)payload).setPageToken(token).build();
        }

        public ListAudienceSegmentsRequest injectPageSize(ListAudienceSegmentsRequest payload, int pageSize) {
            return ListAudienceSegmentsRequest.newBuilder((ListAudienceSegmentsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListAudienceSegmentsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListAudienceSegmentsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<AudienceSegment> extractResources(ListAudienceSegmentsResponse payload) {
            return payload.getAudienceSegmentsList();
        }
    };
    private static final PagedListResponseFactory<ListAudienceSegmentsRequest, ListAudienceSegmentsResponse, AudienceSegmentServiceClient.ListAudienceSegmentsPagedResponse> LIST_AUDIENCE_SEGMENTS_PAGE_STR_FACT = new PagedListResponseFactory<ListAudienceSegmentsRequest, ListAudienceSegmentsResponse, AudienceSegmentServiceClient.ListAudienceSegmentsPagedResponse>(){

        public ApiFuture<AudienceSegmentServiceClient.ListAudienceSegmentsPagedResponse> getFuturePagedResponse(UnaryCallable<ListAudienceSegmentsRequest, ListAudienceSegmentsResponse> callable, ListAudienceSegmentsRequest request, ApiCallContext context, ApiFuture<ListAudienceSegmentsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_AUDIENCE_SEGMENTS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return AudienceSegmentServiceClient.ListAudienceSegmentsPagedResponse.createAsync((PageContext<ListAudienceSegmentsRequest, ListAudienceSegmentsResponse, AudienceSegment>)pageContext, futureResponse);
        }
    };

    public UnaryCallSettings<GetAudienceSegmentRequest, AudienceSegment> getAudienceSegmentSettings() {
        return this.getAudienceSegmentSettings;
    }

    public PagedCallSettings<ListAudienceSegmentsRequest, ListAudienceSegmentsResponse, AudienceSegmentServiceClient.ListAudienceSegmentsPagedResponse> listAudienceSegmentsSettings() {
        return this.listAudienceSegmentsSettings;
    }

    public AudienceSegmentServiceStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonAudienceSegmentServiceStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public String getServiceName() {
        return "admanager";
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    @ObsoleteApi(value="Use getEndpoint() instead")
    public static String getDefaultEndpoint() {
        return "admanager.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "admanager.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return AudienceSegmentServiceStubSettings.defaultHttpJsonTransportProviderBuilder().build();
    }

    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(AudienceSegmentServiceStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected AudienceSegmentServiceStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.getAudienceSegmentSettings = settingsBuilder.getAudienceSegmentSettings().build();
        this.listAudienceSegmentsSettings = settingsBuilder.listAudienceSegmentsSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<AudienceSegmentServiceStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final UnaryCallSettings.Builder<GetAudienceSegmentRequest, AudienceSegment> getAudienceSegmentSettings;
        private final PagedCallSettings.Builder<ListAudienceSegmentsRequest, ListAudienceSegmentsResponse, AudienceSegmentServiceClient.ListAudienceSegmentsPagedResponse> listAudienceSegmentsSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.getAudienceSegmentSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listAudienceSegmentsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_AUDIENCE_SEGMENTS_PAGE_STR_FACT);
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.getAudienceSegmentSettings, this.listAudienceSegmentsSettings);
            Builder.initDefaults(this);
        }

        protected Builder(AudienceSegmentServiceStubSettings settings) {
            super((StubSettings)settings);
            this.getAudienceSegmentSettings = settings.getAudienceSegmentSettings.toBuilder();
            this.listAudienceSegmentsSettings = settings.listAudienceSegmentsSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.getAudienceSegmentSettings, this.listAudienceSegmentsSettings);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(AudienceSegmentServiceStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)AudienceSegmentServiceStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)AudienceSegmentServiceStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(AudienceSegmentServiceStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.getAudienceSegmentSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.listAudienceSegmentsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public UnaryCallSettings.Builder<GetAudienceSegmentRequest, AudienceSegment> getAudienceSegmentSettings() {
            return this.getAudienceSegmentSettings;
        }

        public PagedCallSettings.Builder<ListAudienceSegmentsRequest, ListAudienceSegmentsResponse, AudienceSegmentServiceClient.ListAudienceSegmentsPagedResponse> listAudienceSegmentsSettings() {
            return this.listAudienceSegmentsSettings;
        }

        public AudienceSegmentServiceStubSettings build() throws IOException {
            return new AudienceSegmentServiceStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"no_retry_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setRpcTimeoutMultiplier(1.0).build();
            definitions.put((Object)"no_retry_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

