/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.admanager.v1;

import com.google.ads.admanager.v1.BatchCreateSitesRequest;
import com.google.ads.admanager.v1.BatchCreateSitesResponse;
import com.google.ads.admanager.v1.BatchDeactivateSitesRequest;
import com.google.ads.admanager.v1.BatchDeactivateSitesResponse;
import com.google.ads.admanager.v1.BatchSubmitSitesForApprovalRequest;
import com.google.ads.admanager.v1.BatchSubmitSitesForApprovalResponse;
import com.google.ads.admanager.v1.BatchUpdateSitesRequest;
import com.google.ads.admanager.v1.BatchUpdateSitesResponse;
import com.google.ads.admanager.v1.CreateSiteRequest;
import com.google.ads.admanager.v1.GetSiteRequest;
import com.google.ads.admanager.v1.ListSitesRequest;
import com.google.ads.admanager.v1.ListSitesResponse;
import com.google.ads.admanager.v1.NetworkName;
import com.google.ads.admanager.v1.Site;
import com.google.ads.admanager.v1.SiteName;
import com.google.ads.admanager.v1.SiteServiceSettings;
import com.google.ads.admanager.v1.UpdateSiteRequest;
import com.google.ads.admanager.v1.stub.SiteServiceStub;
import com.google.ads.admanager.v1.stub.SiteServiceStubSettings;
import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.protobuf.FieldMask;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class SiteServiceClient
implements BackgroundResource {
    private final SiteServiceSettings settings;
    private final SiteServiceStub stub;

    public static final SiteServiceClient create() throws IOException {
        return SiteServiceClient.create(SiteServiceSettings.newBuilder().build());
    }

    public static final SiteServiceClient create(SiteServiceSettings settings) throws IOException {
        return new SiteServiceClient(settings);
    }

    public static final SiteServiceClient create(SiteServiceStub stub) {
        return new SiteServiceClient(stub);
    }

    protected SiteServiceClient(SiteServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((SiteServiceStubSettings)settings.getStubSettings()).createStub();
    }

    protected SiteServiceClient(SiteServiceStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final SiteServiceSettings getSettings() {
        return this.settings;
    }

    public SiteServiceStub getStub() {
        return this.stub;
    }

    public final Site getSite(SiteName name) {
        GetSiteRequest request = GetSiteRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getSite(request);
    }

    public final Site getSite(String name) {
        GetSiteRequest request = GetSiteRequest.newBuilder().setName(name).build();
        return this.getSite(request);
    }

    public final Site getSite(GetSiteRequest request) {
        return (Site)this.getSiteCallable().call((Object)request);
    }

    public final UnaryCallable<GetSiteRequest, Site> getSiteCallable() {
        return this.stub.getSiteCallable();
    }

    public final ListSitesPagedResponse listSites(NetworkName parent) {
        ListSitesRequest request = ListSitesRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listSites(request);
    }

    public final ListSitesPagedResponse listSites(String parent) {
        ListSitesRequest request = ListSitesRequest.newBuilder().setParent(parent).build();
        return this.listSites(request);
    }

    public final ListSitesPagedResponse listSites(ListSitesRequest request) {
        return (ListSitesPagedResponse)((Object)this.listSitesPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListSitesRequest, ListSitesPagedResponse> listSitesPagedCallable() {
        return this.stub.listSitesPagedCallable();
    }

    public final UnaryCallable<ListSitesRequest, ListSitesResponse> listSitesCallable() {
        return this.stub.listSitesCallable();
    }

    public final Site createSite(NetworkName parent, Site site) {
        CreateSiteRequest request = CreateSiteRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setSite(site).build();
        return this.createSite(request);
    }

    public final Site createSite(String parent, Site site) {
        CreateSiteRequest request = CreateSiteRequest.newBuilder().setParent(parent).setSite(site).build();
        return this.createSite(request);
    }

    public final Site createSite(CreateSiteRequest request) {
        return (Site)this.createSiteCallable().call((Object)request);
    }

    public final UnaryCallable<CreateSiteRequest, Site> createSiteCallable() {
        return this.stub.createSiteCallable();
    }

    public final BatchCreateSitesResponse batchCreateSites(NetworkName parent, List<CreateSiteRequest> requests) {
        BatchCreateSitesRequest request = BatchCreateSitesRequest.newBuilder().setParent(parent == null ? null : parent.toString()).addAllRequests(requests).build();
        return this.batchCreateSites(request);
    }

    public final BatchCreateSitesResponse batchCreateSites(String parent, List<CreateSiteRequest> requests) {
        BatchCreateSitesRequest request = BatchCreateSitesRequest.newBuilder().setParent(parent).addAllRequests(requests).build();
        return this.batchCreateSites(request);
    }

    public final BatchCreateSitesResponse batchCreateSites(BatchCreateSitesRequest request) {
        return (BatchCreateSitesResponse)this.batchCreateSitesCallable().call((Object)request);
    }

    public final UnaryCallable<BatchCreateSitesRequest, BatchCreateSitesResponse> batchCreateSitesCallable() {
        return this.stub.batchCreateSitesCallable();
    }

    public final Site updateSite(Site site, FieldMask updateMask) {
        UpdateSiteRequest request = UpdateSiteRequest.newBuilder().setSite(site).setUpdateMask(updateMask).build();
        return this.updateSite(request);
    }

    public final Site updateSite(UpdateSiteRequest request) {
        return (Site)this.updateSiteCallable().call((Object)request);
    }

    public final UnaryCallable<UpdateSiteRequest, Site> updateSiteCallable() {
        return this.stub.updateSiteCallable();
    }

    public final BatchUpdateSitesResponse batchUpdateSites(NetworkName parent, List<UpdateSiteRequest> requests) {
        BatchUpdateSitesRequest request = BatchUpdateSitesRequest.newBuilder().setParent(parent == null ? null : parent.toString()).addAllRequests(requests).build();
        return this.batchUpdateSites(request);
    }

    public final BatchUpdateSitesResponse batchUpdateSites(String parent, List<UpdateSiteRequest> requests) {
        BatchUpdateSitesRequest request = BatchUpdateSitesRequest.newBuilder().setParent(parent).addAllRequests(requests).build();
        return this.batchUpdateSites(request);
    }

    public final BatchUpdateSitesResponse batchUpdateSites(BatchUpdateSitesRequest request) {
        return (BatchUpdateSitesResponse)this.batchUpdateSitesCallable().call((Object)request);
    }

    public final UnaryCallable<BatchUpdateSitesRequest, BatchUpdateSitesResponse> batchUpdateSitesCallable() {
        return this.stub.batchUpdateSitesCallable();
    }

    public final BatchDeactivateSitesResponse batchDeactivateSites(NetworkName parent, List<String> names) {
        BatchDeactivateSitesRequest request = BatchDeactivateSitesRequest.newBuilder().setParent(parent == null ? null : parent.toString()).addAllNames(names).build();
        return this.batchDeactivateSites(request);
    }

    public final BatchDeactivateSitesResponse batchDeactivateSites(String parent, List<String> names) {
        BatchDeactivateSitesRequest request = BatchDeactivateSitesRequest.newBuilder().setParent(parent).addAllNames(names).build();
        return this.batchDeactivateSites(request);
    }

    public final BatchDeactivateSitesResponse batchDeactivateSites(BatchDeactivateSitesRequest request) {
        return (BatchDeactivateSitesResponse)this.batchDeactivateSitesCallable().call((Object)request);
    }

    public final UnaryCallable<BatchDeactivateSitesRequest, BatchDeactivateSitesResponse> batchDeactivateSitesCallable() {
        return this.stub.batchDeactivateSitesCallable();
    }

    public final BatchSubmitSitesForApprovalResponse batchSubmitSitesForApproval(NetworkName parent, List<String> names) {
        BatchSubmitSitesForApprovalRequest request = BatchSubmitSitesForApprovalRequest.newBuilder().setParent(parent == null ? null : parent.toString()).addAllNames(names).build();
        return this.batchSubmitSitesForApproval(request);
    }

    public final BatchSubmitSitesForApprovalResponse batchSubmitSitesForApproval(String parent, List<String> names) {
        BatchSubmitSitesForApprovalRequest request = BatchSubmitSitesForApprovalRequest.newBuilder().setParent(parent).addAllNames(names).build();
        return this.batchSubmitSitesForApproval(request);
    }

    public final BatchSubmitSitesForApprovalResponse batchSubmitSitesForApproval(BatchSubmitSitesForApprovalRequest request) {
        return (BatchSubmitSitesForApprovalResponse)this.batchSubmitSitesForApprovalCallable().call((Object)request);
    }

    public final UnaryCallable<BatchSubmitSitesForApprovalRequest, BatchSubmitSitesForApprovalResponse> batchSubmitSitesForApprovalCallable() {
        return this.stub.batchSubmitSitesForApprovalCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListSitesFixedSizeCollection
    extends AbstractFixedSizeCollection<ListSitesRequest, ListSitesResponse, Site, ListSitesPage, ListSitesFixedSizeCollection> {
        private ListSitesFixedSizeCollection(List<ListSitesPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListSitesFixedSizeCollection createEmptyCollection() {
            return new ListSitesFixedSizeCollection(null, 0);
        }

        protected ListSitesFixedSizeCollection createCollection(List<ListSitesPage> pages, int collectionSize) {
            return new ListSitesFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListSitesPage
    extends AbstractPage<ListSitesRequest, ListSitesResponse, Site, ListSitesPage> {
        private ListSitesPage(PageContext<ListSitesRequest, ListSitesResponse, Site> context, ListSitesResponse response) {
            super(context, (Object)response);
        }

        private static ListSitesPage createEmptyPage() {
            return new ListSitesPage(null, null);
        }

        protected ListSitesPage createPage(PageContext<ListSitesRequest, ListSitesResponse, Site> context, ListSitesResponse response) {
            return new ListSitesPage(context, response);
        }

        public ApiFuture<ListSitesPage> createPageAsync(PageContext<ListSitesRequest, ListSitesResponse, Site> context, ApiFuture<ListSitesResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListSitesPagedResponse
    extends AbstractPagedListResponse<ListSitesRequest, ListSitesResponse, Site, ListSitesPage, ListSitesFixedSizeCollection> {
        public static ApiFuture<ListSitesPagedResponse> createAsync(PageContext<ListSitesRequest, ListSitesResponse, Site> context, ApiFuture<ListSitesResponse> futureResponse) {
            ApiFuture<ListSitesPage> futurePage = ListSitesPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListSitesPagedResponse((ListSitesPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListSitesPagedResponse(ListSitesPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListSitesFixedSizeCollection.createEmptyCollection());
        }
    }
}

