/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.admanager.v1;

import com.google.ads.admanager.v1.DeviceCapability;
import com.google.ads.admanager.v1.DeviceCapabilityName;
import com.google.ads.admanager.v1.DeviceCapabilityServiceSettings;
import com.google.ads.admanager.v1.GetDeviceCapabilityRequest;
import com.google.ads.admanager.v1.ListDeviceCapabilitiesRequest;
import com.google.ads.admanager.v1.ListDeviceCapabilitiesResponse;
import com.google.ads.admanager.v1.NetworkName;
import com.google.ads.admanager.v1.stub.DeviceCapabilityServiceStub;
import com.google.ads.admanager.v1.stub.DeviceCapabilityServiceStubSettings;
import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.common.util.concurrent.MoreExecutors;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class DeviceCapabilityServiceClient
implements BackgroundResource {
    private final DeviceCapabilityServiceSettings settings;
    private final DeviceCapabilityServiceStub stub;

    public static final DeviceCapabilityServiceClient create() throws IOException {
        return DeviceCapabilityServiceClient.create(DeviceCapabilityServiceSettings.newBuilder().build());
    }

    public static final DeviceCapabilityServiceClient create(DeviceCapabilityServiceSettings settings) throws IOException {
        return new DeviceCapabilityServiceClient(settings);
    }

    public static final DeviceCapabilityServiceClient create(DeviceCapabilityServiceStub stub) {
        return new DeviceCapabilityServiceClient(stub);
    }

    protected DeviceCapabilityServiceClient(DeviceCapabilityServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((DeviceCapabilityServiceStubSettings)settings.getStubSettings()).createStub();
    }

    protected DeviceCapabilityServiceClient(DeviceCapabilityServiceStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final DeviceCapabilityServiceSettings getSettings() {
        return this.settings;
    }

    public DeviceCapabilityServiceStub getStub() {
        return this.stub;
    }

    public final DeviceCapability getDeviceCapability(DeviceCapabilityName name) {
        GetDeviceCapabilityRequest request = GetDeviceCapabilityRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getDeviceCapability(request);
    }

    public final DeviceCapability getDeviceCapability(String name) {
        GetDeviceCapabilityRequest request = GetDeviceCapabilityRequest.newBuilder().setName(name).build();
        return this.getDeviceCapability(request);
    }

    public final DeviceCapability getDeviceCapability(GetDeviceCapabilityRequest request) {
        return (DeviceCapability)this.getDeviceCapabilityCallable().call((Object)request);
    }

    public final UnaryCallable<GetDeviceCapabilityRequest, DeviceCapability> getDeviceCapabilityCallable() {
        return this.stub.getDeviceCapabilityCallable();
    }

    public final ListDeviceCapabilitiesPagedResponse listDeviceCapabilities(NetworkName parent) {
        ListDeviceCapabilitiesRequest request = ListDeviceCapabilitiesRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listDeviceCapabilities(request);
    }

    public final ListDeviceCapabilitiesPagedResponse listDeviceCapabilities(String parent) {
        ListDeviceCapabilitiesRequest request = ListDeviceCapabilitiesRequest.newBuilder().setParent(parent).build();
        return this.listDeviceCapabilities(request);
    }

    public final ListDeviceCapabilitiesPagedResponse listDeviceCapabilities(ListDeviceCapabilitiesRequest request) {
        return (ListDeviceCapabilitiesPagedResponse)((Object)this.listDeviceCapabilitiesPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListDeviceCapabilitiesRequest, ListDeviceCapabilitiesPagedResponse> listDeviceCapabilitiesPagedCallable() {
        return this.stub.listDeviceCapabilitiesPagedCallable();
    }

    public final UnaryCallable<ListDeviceCapabilitiesRequest, ListDeviceCapabilitiesResponse> listDeviceCapabilitiesCallable() {
        return this.stub.listDeviceCapabilitiesCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListDeviceCapabilitiesFixedSizeCollection
    extends AbstractFixedSizeCollection<ListDeviceCapabilitiesRequest, ListDeviceCapabilitiesResponse, DeviceCapability, ListDeviceCapabilitiesPage, ListDeviceCapabilitiesFixedSizeCollection> {
        private ListDeviceCapabilitiesFixedSizeCollection(List<ListDeviceCapabilitiesPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListDeviceCapabilitiesFixedSizeCollection createEmptyCollection() {
            return new ListDeviceCapabilitiesFixedSizeCollection(null, 0);
        }

        protected ListDeviceCapabilitiesFixedSizeCollection createCollection(List<ListDeviceCapabilitiesPage> pages, int collectionSize) {
            return new ListDeviceCapabilitiesFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListDeviceCapabilitiesPage
    extends AbstractPage<ListDeviceCapabilitiesRequest, ListDeviceCapabilitiesResponse, DeviceCapability, ListDeviceCapabilitiesPage> {
        private ListDeviceCapabilitiesPage(PageContext<ListDeviceCapabilitiesRequest, ListDeviceCapabilitiesResponse, DeviceCapability> context, ListDeviceCapabilitiesResponse response) {
            super(context, (Object)response);
        }

        private static ListDeviceCapabilitiesPage createEmptyPage() {
            return new ListDeviceCapabilitiesPage(null, null);
        }

        protected ListDeviceCapabilitiesPage createPage(PageContext<ListDeviceCapabilitiesRequest, ListDeviceCapabilitiesResponse, DeviceCapability> context, ListDeviceCapabilitiesResponse response) {
            return new ListDeviceCapabilitiesPage(context, response);
        }

        public ApiFuture<ListDeviceCapabilitiesPage> createPageAsync(PageContext<ListDeviceCapabilitiesRequest, ListDeviceCapabilitiesResponse, DeviceCapability> context, ApiFuture<ListDeviceCapabilitiesResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListDeviceCapabilitiesPagedResponse
    extends AbstractPagedListResponse<ListDeviceCapabilitiesRequest, ListDeviceCapabilitiesResponse, DeviceCapability, ListDeviceCapabilitiesPage, ListDeviceCapabilitiesFixedSizeCollection> {
        public static ApiFuture<ListDeviceCapabilitiesPagedResponse> createAsync(PageContext<ListDeviceCapabilitiesRequest, ListDeviceCapabilitiesResponse, DeviceCapability> context, ApiFuture<ListDeviceCapabilitiesResponse> futureResponse) {
            ApiFuture<ListDeviceCapabilitiesPage> futurePage = ListDeviceCapabilitiesPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListDeviceCapabilitiesPagedResponse((ListDeviceCapabilitiesPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListDeviceCapabilitiesPagedResponse(ListDeviceCapabilitiesPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListDeviceCapabilitiesFixedSizeCollection.createEmptyCollection());
        }
    }
}

