/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.admanager.v1.stub;

import com.google.ads.admanager.v1.BatchCreateSitesRequest;
import com.google.ads.admanager.v1.BatchCreateSitesResponse;
import com.google.ads.admanager.v1.BatchDeactivateSitesRequest;
import com.google.ads.admanager.v1.BatchDeactivateSitesResponse;
import com.google.ads.admanager.v1.BatchSubmitSitesForApprovalRequest;
import com.google.ads.admanager.v1.BatchSubmitSitesForApprovalResponse;
import com.google.ads.admanager.v1.BatchUpdateSitesRequest;
import com.google.ads.admanager.v1.BatchUpdateSitesResponse;
import com.google.ads.admanager.v1.CreateSiteRequest;
import com.google.ads.admanager.v1.GetSiteRequest;
import com.google.ads.admanager.v1.ListSitesRequest;
import com.google.ads.admanager.v1.ListSitesResponse;
import com.google.ads.admanager.v1.Site;
import com.google.ads.admanager.v1.SiteServiceClient;
import com.google.ads.admanager.v1.UpdateSiteRequest;
import com.google.ads.admanager.v1.stub.HttpJsonSiteServiceCallableFactory;
import com.google.ads.admanager.v1.stub.SiteServiceStub;
import com.google.ads.admanager.v1.stub.SiteServiceStubSettings;
import com.google.api.core.InternalApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.httpjson.ApiMethodDescriptor;
import com.google.api.gax.httpjson.HttpJsonCallSettings;
import com.google.api.gax.httpjson.HttpJsonStubCallableFactory;
import com.google.api.gax.httpjson.HttpRequestFormatter;
import com.google.api.gax.httpjson.HttpResponseParser;
import com.google.api.gax.httpjson.ProtoMessageRequestFormatter;
import com.google.api.gax.httpjson.ProtoMessageResponseParser;
import com.google.api.gax.httpjson.ProtoRestSerializer;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.RequestParamsBuilder;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.protobuf.Message;
import com.google.protobuf.TypeRegistry;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class HttpJsonSiteServiceStub
extends SiteServiceStub {
    private static final TypeRegistry typeRegistry = TypeRegistry.newBuilder().build();
    private static final ApiMethodDescriptor<GetSiteRequest, Site> getSiteMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.ads.admanager.v1.SiteService/GetSite").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{name=networks/*/sites/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Site.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<ListSitesRequest, ListSitesResponse> listSitesMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.ads.admanager.v1.SiteService/ListSites").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{parent=networks/*}/sites", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parent", (Object)request.getParent());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "filter", (Object)request.getFilter());
        serializer.putQueryParam(fields, "orderBy", (Object)request.getOrderBy());
        serializer.putQueryParam(fields, "pageSize", (Object)request.getPageSize());
        serializer.putQueryParam(fields, "pageToken", (Object)request.getPageToken());
        serializer.putQueryParam(fields, "skip", (Object)request.getSkip());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)ListSitesResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<CreateSiteRequest, Site> createSiteMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.ads.admanager.v1.SiteService/CreateSite").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{parent=networks/*}/sites", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parent", (Object)request.getParent());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("site", (Message)request.getSite(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Site.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<BatchCreateSitesRequest, BatchCreateSitesResponse> batchCreateSitesMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.ads.admanager.v1.SiteService/BatchCreateSites").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{parent=networks/*}/sites:batchCreate", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parent", (Object)request.getParent());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("*", (Message)request.toBuilder().clearParent().build(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)BatchCreateSitesResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<UpdateSiteRequest, Site> updateSiteMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.ads.admanager.v1.SiteService/UpdateSite").setHttpMethod("PATCH").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{site.name=networks/*/sites/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "site.name", (Object)request.getSite().getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "updateMask", (Object)request.getUpdateMask());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("site", (Message)request.getSite(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Site.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<BatchUpdateSitesRequest, BatchUpdateSitesResponse> batchUpdateSitesMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.ads.admanager.v1.SiteService/BatchUpdateSites").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{parent=networks/*}/sites:batchUpdate", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parent", (Object)request.getParent());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("*", (Message)request.toBuilder().clearParent().build(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)BatchUpdateSitesResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<BatchDeactivateSitesRequest, BatchDeactivateSitesResponse> batchDeactivateSitesMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.ads.admanager.v1.SiteService/BatchDeactivateSites").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{parent=networks/*}/sites:batchDeactivate", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parent", (Object)request.getParent());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("*", (Message)request.toBuilder().clearParent().build(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)BatchDeactivateSitesResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<BatchSubmitSitesForApprovalRequest, BatchSubmitSitesForApprovalResponse> batchSubmitSitesForApprovalMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.ads.admanager.v1.SiteService/BatchSubmitSitesForApproval").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{parent=networks/*}/sites:batchSubmitForApproval", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parent", (Object)request.getParent());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("*", (Message)request.toBuilder().clearParent().build(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)BatchSubmitSitesForApprovalResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private final UnaryCallable<GetSiteRequest, Site> getSiteCallable;
    private final UnaryCallable<ListSitesRequest, ListSitesResponse> listSitesCallable;
    private final UnaryCallable<ListSitesRequest, SiteServiceClient.ListSitesPagedResponse> listSitesPagedCallable;
    private final UnaryCallable<CreateSiteRequest, Site> createSiteCallable;
    private final UnaryCallable<BatchCreateSitesRequest, BatchCreateSitesResponse> batchCreateSitesCallable;
    private final UnaryCallable<UpdateSiteRequest, Site> updateSiteCallable;
    private final UnaryCallable<BatchUpdateSitesRequest, BatchUpdateSitesResponse> batchUpdateSitesCallable;
    private final UnaryCallable<BatchDeactivateSitesRequest, BatchDeactivateSitesResponse> batchDeactivateSitesCallable;
    private final UnaryCallable<BatchSubmitSitesForApprovalRequest, BatchSubmitSitesForApprovalResponse> batchSubmitSitesForApprovalCallable;
    private final BackgroundResource backgroundResources;
    private final HttpJsonStubCallableFactory callableFactory;

    public static final HttpJsonSiteServiceStub create(SiteServiceStubSettings settings) throws IOException {
        return new HttpJsonSiteServiceStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final HttpJsonSiteServiceStub create(ClientContext clientContext) throws IOException {
        return new HttpJsonSiteServiceStub(SiteServiceStubSettings.newBuilder().build(), clientContext);
    }

    public static final HttpJsonSiteServiceStub create(ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        return new HttpJsonSiteServiceStub(SiteServiceStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected HttpJsonSiteServiceStub(SiteServiceStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new HttpJsonSiteServiceCallableFactory());
    }

    protected HttpJsonSiteServiceStub(SiteServiceStubSettings settings, ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        HttpJsonCallSettings getSiteTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(getSiteMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        HttpJsonCallSettings listSitesTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(listSitesMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        HttpJsonCallSettings createSiteTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(createSiteMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        HttpJsonCallSettings batchCreateSitesTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(batchCreateSitesMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        HttpJsonCallSettings updateSiteTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(updateSiteMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("site.name", String.valueOf(request.getSite().getName()));
            return builder.build();
        }).build();
        HttpJsonCallSettings batchUpdateSitesTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(batchUpdateSitesMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        HttpJsonCallSettings batchDeactivateSitesTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(batchDeactivateSitesMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        HttpJsonCallSettings batchSubmitSitesForApprovalTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(batchSubmitSitesForApprovalMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        this.getSiteCallable = callableFactory.createUnaryCallable(getSiteTransportSettings, settings.getSiteSettings(), clientContext);
        this.listSitesCallable = callableFactory.createUnaryCallable(listSitesTransportSettings, settings.listSitesSettings(), clientContext);
        this.listSitesPagedCallable = callableFactory.createPagedCallable(listSitesTransportSettings, settings.listSitesSettings(), clientContext);
        this.createSiteCallable = callableFactory.createUnaryCallable(createSiteTransportSettings, settings.createSiteSettings(), clientContext);
        this.batchCreateSitesCallable = callableFactory.createUnaryCallable(batchCreateSitesTransportSettings, settings.batchCreateSitesSettings(), clientContext);
        this.updateSiteCallable = callableFactory.createUnaryCallable(updateSiteTransportSettings, settings.updateSiteSettings(), clientContext);
        this.batchUpdateSitesCallable = callableFactory.createUnaryCallable(batchUpdateSitesTransportSettings, settings.batchUpdateSitesSettings(), clientContext);
        this.batchDeactivateSitesCallable = callableFactory.createUnaryCallable(batchDeactivateSitesTransportSettings, settings.batchDeactivateSitesSettings(), clientContext);
        this.batchSubmitSitesForApprovalCallable = callableFactory.createUnaryCallable(batchSubmitSitesForApprovalTransportSettings, settings.batchSubmitSitesForApprovalSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    @InternalApi
    public static List<ApiMethodDescriptor> getMethodDescriptors() {
        ArrayList<ApiMethodDescriptor> methodDescriptors = new ArrayList<ApiMethodDescriptor>();
        methodDescriptors.add(getSiteMethodDescriptor);
        methodDescriptors.add(listSitesMethodDescriptor);
        methodDescriptors.add(createSiteMethodDescriptor);
        methodDescriptors.add(batchCreateSitesMethodDescriptor);
        methodDescriptors.add(updateSiteMethodDescriptor);
        methodDescriptors.add(batchUpdateSitesMethodDescriptor);
        methodDescriptors.add(batchDeactivateSitesMethodDescriptor);
        methodDescriptors.add(batchSubmitSitesForApprovalMethodDescriptor);
        return methodDescriptors;
    }

    @Override
    public UnaryCallable<GetSiteRequest, Site> getSiteCallable() {
        return this.getSiteCallable;
    }

    @Override
    public UnaryCallable<ListSitesRequest, ListSitesResponse> listSitesCallable() {
        return this.listSitesCallable;
    }

    @Override
    public UnaryCallable<ListSitesRequest, SiteServiceClient.ListSitesPagedResponse> listSitesPagedCallable() {
        return this.listSitesPagedCallable;
    }

    @Override
    public UnaryCallable<CreateSiteRequest, Site> createSiteCallable() {
        return this.createSiteCallable;
    }

    @Override
    public UnaryCallable<BatchCreateSitesRequest, BatchCreateSitesResponse> batchCreateSitesCallable() {
        return this.batchCreateSitesCallable;
    }

    @Override
    public UnaryCallable<UpdateSiteRequest, Site> updateSiteCallable() {
        return this.updateSiteCallable;
    }

    @Override
    public UnaryCallable<BatchUpdateSitesRequest, BatchUpdateSitesResponse> batchUpdateSitesCallable() {
        return this.batchUpdateSitesCallable;
    }

    @Override
    public UnaryCallable<BatchDeactivateSitesRequest, BatchDeactivateSitesResponse> batchDeactivateSitesCallable() {
        return this.batchDeactivateSitesCallable;
    }

    @Override
    public UnaryCallable<BatchSubmitSitesForApprovalRequest, BatchSubmitSitesForApprovalResponse> batchSubmitSitesForApprovalCallable() {
        return this.batchSubmitSitesForApprovalCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

