/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.admanager.v1.stub;

import com.google.ads.admanager.v1.Browser;
import com.google.ads.admanager.v1.BrowserServiceClient;
import com.google.ads.admanager.v1.GetBrowserRequest;
import com.google.ads.admanager.v1.ListBrowsersRequest;
import com.google.ads.admanager.v1.ListBrowsersResponse;
import com.google.ads.admanager.v1.stub.BrowserServiceStub;
import com.google.ads.admanager.v1.stub.BrowserServiceStubSettings;
import com.google.ads.admanager.v1.stub.HttpJsonBrowserServiceCallableFactory;
import com.google.api.core.InternalApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.httpjson.ApiMethodDescriptor;
import com.google.api.gax.httpjson.HttpJsonCallSettings;
import com.google.api.gax.httpjson.HttpJsonStubCallableFactory;
import com.google.api.gax.httpjson.HttpRequestFormatter;
import com.google.api.gax.httpjson.HttpResponseParser;
import com.google.api.gax.httpjson.ProtoMessageRequestFormatter;
import com.google.api.gax.httpjson.ProtoMessageResponseParser;
import com.google.api.gax.httpjson.ProtoRestSerializer;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.RequestParamsBuilder;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.protobuf.Message;
import com.google.protobuf.TypeRegistry;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class HttpJsonBrowserServiceStub
extends BrowserServiceStub {
    private static final TypeRegistry typeRegistry = TypeRegistry.newBuilder().build();
    private static final ApiMethodDescriptor<GetBrowserRequest, Browser> getBrowserMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.ads.admanager.v1.BrowserService/GetBrowser").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{name=networks/*/browsers/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Browser.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<ListBrowsersRequest, ListBrowsersResponse> listBrowsersMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.ads.admanager.v1.BrowserService/ListBrowsers").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{parent=networks/*}/browsers", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parent", (Object)request.getParent());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "filter", (Object)request.getFilter());
        serializer.putQueryParam(fields, "orderBy", (Object)request.getOrderBy());
        serializer.putQueryParam(fields, "pageSize", (Object)request.getPageSize());
        serializer.putQueryParam(fields, "pageToken", (Object)request.getPageToken());
        serializer.putQueryParam(fields, "skip", (Object)request.getSkip());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)ListBrowsersResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private final UnaryCallable<GetBrowserRequest, Browser> getBrowserCallable;
    private final UnaryCallable<ListBrowsersRequest, ListBrowsersResponse> listBrowsersCallable;
    private final UnaryCallable<ListBrowsersRequest, BrowserServiceClient.ListBrowsersPagedResponse> listBrowsersPagedCallable;
    private final BackgroundResource backgroundResources;
    private final HttpJsonStubCallableFactory callableFactory;

    public static final HttpJsonBrowserServiceStub create(BrowserServiceStubSettings settings) throws IOException {
        return new HttpJsonBrowserServiceStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final HttpJsonBrowserServiceStub create(ClientContext clientContext) throws IOException {
        return new HttpJsonBrowserServiceStub(BrowserServiceStubSettings.newBuilder().build(), clientContext);
    }

    public static final HttpJsonBrowserServiceStub create(ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        return new HttpJsonBrowserServiceStub(BrowserServiceStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected HttpJsonBrowserServiceStub(BrowserServiceStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new HttpJsonBrowserServiceCallableFactory());
    }

    protected HttpJsonBrowserServiceStub(BrowserServiceStubSettings settings, ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        HttpJsonCallSettings getBrowserTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(getBrowserMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        HttpJsonCallSettings listBrowsersTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(listBrowsersMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        this.getBrowserCallable = callableFactory.createUnaryCallable(getBrowserTransportSettings, settings.getBrowserSettings(), clientContext);
        this.listBrowsersCallable = callableFactory.createUnaryCallable(listBrowsersTransportSettings, settings.listBrowsersSettings(), clientContext);
        this.listBrowsersPagedCallable = callableFactory.createPagedCallable(listBrowsersTransportSettings, settings.listBrowsersSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    @InternalApi
    public static List<ApiMethodDescriptor> getMethodDescriptors() {
        ArrayList<ApiMethodDescriptor> methodDescriptors = new ArrayList<ApiMethodDescriptor>();
        methodDescriptors.add(getBrowserMethodDescriptor);
        methodDescriptors.add(listBrowsersMethodDescriptor);
        return methodDescriptors;
    }

    @Override
    public UnaryCallable<GetBrowserRequest, Browser> getBrowserCallable() {
        return this.getBrowserCallable;
    }

    @Override
    public UnaryCallable<ListBrowsersRequest, ListBrowsersResponse> listBrowsersCallable() {
        return this.listBrowsersCallable;
    }

    @Override
    public UnaryCallable<ListBrowsersRequest, BrowserServiceClient.ListBrowsersPagedResponse> listBrowsersPagedCallable() {
        return this.listBrowsersPagedCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

