/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.admanager.v1.stub;

import com.google.ads.admanager.v1.DeviceCapability;
import com.google.ads.admanager.v1.DeviceCapabilityServiceClient;
import com.google.ads.admanager.v1.GetDeviceCapabilityRequest;
import com.google.ads.admanager.v1.ListDeviceCapabilitiesRequest;
import com.google.ads.admanager.v1.ListDeviceCapabilitiesResponse;
import com.google.ads.admanager.v1.stub.DeviceCapabilityServiceStub;
import com.google.ads.admanager.v1.stub.HttpJsonDeviceCapabilityServiceStub;
import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.ObsoleteApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;

public class DeviceCapabilityServiceStubSettings
extends StubSettings<DeviceCapabilityServiceStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/admanager").build();
    private final UnaryCallSettings<GetDeviceCapabilityRequest, DeviceCapability> getDeviceCapabilitySettings;
    private final PagedCallSettings<ListDeviceCapabilitiesRequest, ListDeviceCapabilitiesResponse, DeviceCapabilityServiceClient.ListDeviceCapabilitiesPagedResponse> listDeviceCapabilitiesSettings;
    private static final PagedListDescriptor<ListDeviceCapabilitiesRequest, ListDeviceCapabilitiesResponse, DeviceCapability> LIST_DEVICE_CAPABILITIES_PAGE_STR_DESC = new PagedListDescriptor<ListDeviceCapabilitiesRequest, ListDeviceCapabilitiesResponse, DeviceCapability>(){

        public String emptyToken() {
            return "";
        }

        public ListDeviceCapabilitiesRequest injectToken(ListDeviceCapabilitiesRequest payload, String token) {
            return ListDeviceCapabilitiesRequest.newBuilder((ListDeviceCapabilitiesRequest)payload).setPageToken(token).build();
        }

        public ListDeviceCapabilitiesRequest injectPageSize(ListDeviceCapabilitiesRequest payload, int pageSize) {
            return ListDeviceCapabilitiesRequest.newBuilder((ListDeviceCapabilitiesRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListDeviceCapabilitiesRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListDeviceCapabilitiesResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<DeviceCapability> extractResources(ListDeviceCapabilitiesResponse payload) {
            return payload.getDeviceCapabilitiesList();
        }
    };
    private static final PagedListResponseFactory<ListDeviceCapabilitiesRequest, ListDeviceCapabilitiesResponse, DeviceCapabilityServiceClient.ListDeviceCapabilitiesPagedResponse> LIST_DEVICE_CAPABILITIES_PAGE_STR_FACT = new PagedListResponseFactory<ListDeviceCapabilitiesRequest, ListDeviceCapabilitiesResponse, DeviceCapabilityServiceClient.ListDeviceCapabilitiesPagedResponse>(){

        public ApiFuture<DeviceCapabilityServiceClient.ListDeviceCapabilitiesPagedResponse> getFuturePagedResponse(UnaryCallable<ListDeviceCapabilitiesRequest, ListDeviceCapabilitiesResponse> callable, ListDeviceCapabilitiesRequest request, ApiCallContext context, ApiFuture<ListDeviceCapabilitiesResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_DEVICE_CAPABILITIES_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return DeviceCapabilityServiceClient.ListDeviceCapabilitiesPagedResponse.createAsync((PageContext<ListDeviceCapabilitiesRequest, ListDeviceCapabilitiesResponse, DeviceCapability>)pageContext, futureResponse);
        }
    };

    public UnaryCallSettings<GetDeviceCapabilityRequest, DeviceCapability> getDeviceCapabilitySettings() {
        return this.getDeviceCapabilitySettings;
    }

    public PagedCallSettings<ListDeviceCapabilitiesRequest, ListDeviceCapabilitiesResponse, DeviceCapabilityServiceClient.ListDeviceCapabilitiesPagedResponse> listDeviceCapabilitiesSettings() {
        return this.listDeviceCapabilitiesSettings;
    }

    public DeviceCapabilityServiceStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonDeviceCapabilityServiceStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public String getServiceName() {
        return "admanager";
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    @ObsoleteApi(value="Use getEndpoint() instead")
    public static String getDefaultEndpoint() {
        return "admanager.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "admanager.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return DeviceCapabilityServiceStubSettings.defaultHttpJsonTransportProviderBuilder().build();
    }

    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(DeviceCapabilityServiceStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected DeviceCapabilityServiceStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.getDeviceCapabilitySettings = settingsBuilder.getDeviceCapabilitySettings().build();
        this.listDeviceCapabilitiesSettings = settingsBuilder.listDeviceCapabilitiesSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<DeviceCapabilityServiceStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final UnaryCallSettings.Builder<GetDeviceCapabilityRequest, DeviceCapability> getDeviceCapabilitySettings;
        private final PagedCallSettings.Builder<ListDeviceCapabilitiesRequest, ListDeviceCapabilitiesResponse, DeviceCapabilityServiceClient.ListDeviceCapabilitiesPagedResponse> listDeviceCapabilitiesSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.getDeviceCapabilitySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listDeviceCapabilitiesSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_DEVICE_CAPABILITIES_PAGE_STR_FACT);
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.getDeviceCapabilitySettings, this.listDeviceCapabilitiesSettings);
            Builder.initDefaults(this);
        }

        protected Builder(DeviceCapabilityServiceStubSettings settings) {
            super((StubSettings)settings);
            this.getDeviceCapabilitySettings = settings.getDeviceCapabilitySettings.toBuilder();
            this.listDeviceCapabilitiesSettings = settings.listDeviceCapabilitiesSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.getDeviceCapabilitySettings, this.listDeviceCapabilitiesSettings);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(DeviceCapabilityServiceStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)DeviceCapabilityServiceStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)DeviceCapabilityServiceStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(DeviceCapabilityServiceStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.getDeviceCapabilitySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.listDeviceCapabilitiesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public UnaryCallSettings.Builder<GetDeviceCapabilityRequest, DeviceCapability> getDeviceCapabilitySettings() {
            return this.getDeviceCapabilitySettings;
        }

        public PagedCallSettings.Builder<ListDeviceCapabilitiesRequest, ListDeviceCapabilitiesResponse, DeviceCapabilityServiceClient.ListDeviceCapabilitiesPagedResponse> listDeviceCapabilitiesSettings() {
            return this.listDeviceCapabilitiesSettings;
        }

        public DeviceCapabilityServiceStubSettings build() throws IOException {
            return new DeviceCapabilityServiceStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"no_retry_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setRpcTimeoutMultiplier(1.0).build();
            definitions.put((Object)"no_retry_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

