/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.admanager.v1;

import com.google.ads.admanager.v1.BatchCreateContactsRequest;
import com.google.ads.admanager.v1.BatchCreateContactsResponse;
import com.google.ads.admanager.v1.BatchUpdateContactsRequest;
import com.google.ads.admanager.v1.BatchUpdateContactsResponse;
import com.google.ads.admanager.v1.Contact;
import com.google.ads.admanager.v1.ContactName;
import com.google.ads.admanager.v1.ContactServiceSettings;
import com.google.ads.admanager.v1.CreateContactRequest;
import com.google.ads.admanager.v1.GetContactRequest;
import com.google.ads.admanager.v1.ListContactsRequest;
import com.google.ads.admanager.v1.ListContactsResponse;
import com.google.ads.admanager.v1.NetworkName;
import com.google.ads.admanager.v1.UpdateContactRequest;
import com.google.ads.admanager.v1.stub.ContactServiceStub;
import com.google.ads.admanager.v1.stub.ContactServiceStubSettings;
import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.protobuf.FieldMask;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class ContactServiceClient
implements BackgroundResource {
    private final ContactServiceSettings settings;
    private final ContactServiceStub stub;

    public static final ContactServiceClient create() throws IOException {
        return ContactServiceClient.create(ContactServiceSettings.newBuilder().build());
    }

    public static final ContactServiceClient create(ContactServiceSettings settings) throws IOException {
        return new ContactServiceClient(settings);
    }

    public static final ContactServiceClient create(ContactServiceStub stub) {
        return new ContactServiceClient(stub);
    }

    protected ContactServiceClient(ContactServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((ContactServiceStubSettings)settings.getStubSettings()).createStub();
    }

    protected ContactServiceClient(ContactServiceStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final ContactServiceSettings getSettings() {
        return this.settings;
    }

    public ContactServiceStub getStub() {
        return this.stub;
    }

    public final Contact getContact(ContactName name) {
        GetContactRequest request = GetContactRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getContact(request);
    }

    public final Contact getContact(String name) {
        GetContactRequest request = GetContactRequest.newBuilder().setName(name).build();
        return this.getContact(request);
    }

    public final Contact getContact(GetContactRequest request) {
        return (Contact)this.getContactCallable().call((Object)request);
    }

    public final UnaryCallable<GetContactRequest, Contact> getContactCallable() {
        return this.stub.getContactCallable();
    }

    public final ListContactsPagedResponse listContacts(NetworkName parent) {
        ListContactsRequest request = ListContactsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listContacts(request);
    }

    public final ListContactsPagedResponse listContacts(String parent) {
        ListContactsRequest request = ListContactsRequest.newBuilder().setParent(parent).build();
        return this.listContacts(request);
    }

    public final ListContactsPagedResponse listContacts(ListContactsRequest request) {
        return (ListContactsPagedResponse)((Object)this.listContactsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListContactsRequest, ListContactsPagedResponse> listContactsPagedCallable() {
        return this.stub.listContactsPagedCallable();
    }

    public final UnaryCallable<ListContactsRequest, ListContactsResponse> listContactsCallable() {
        return this.stub.listContactsCallable();
    }

    public final Contact createContact(NetworkName parent, Contact contact) {
        CreateContactRequest request = CreateContactRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setContact(contact).build();
        return this.createContact(request);
    }

    public final Contact createContact(String parent, Contact contact) {
        CreateContactRequest request = CreateContactRequest.newBuilder().setParent(parent).setContact(contact).build();
        return this.createContact(request);
    }

    public final Contact createContact(CreateContactRequest request) {
        return (Contact)this.createContactCallable().call((Object)request);
    }

    public final UnaryCallable<CreateContactRequest, Contact> createContactCallable() {
        return this.stub.createContactCallable();
    }

    public final BatchCreateContactsResponse batchCreateContacts(NetworkName parent, List<CreateContactRequest> requests) {
        BatchCreateContactsRequest request = BatchCreateContactsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).addAllRequests(requests).build();
        return this.batchCreateContacts(request);
    }

    public final BatchCreateContactsResponse batchCreateContacts(String parent, List<CreateContactRequest> requests) {
        BatchCreateContactsRequest request = BatchCreateContactsRequest.newBuilder().setParent(parent).addAllRequests(requests).build();
        return this.batchCreateContacts(request);
    }

    public final BatchCreateContactsResponse batchCreateContacts(BatchCreateContactsRequest request) {
        return (BatchCreateContactsResponse)this.batchCreateContactsCallable().call((Object)request);
    }

    public final UnaryCallable<BatchCreateContactsRequest, BatchCreateContactsResponse> batchCreateContactsCallable() {
        return this.stub.batchCreateContactsCallable();
    }

    public final Contact updateContact(Contact contact, FieldMask updateMask) {
        UpdateContactRequest request = UpdateContactRequest.newBuilder().setContact(contact).setUpdateMask(updateMask).build();
        return this.updateContact(request);
    }

    public final Contact updateContact(UpdateContactRequest request) {
        return (Contact)this.updateContactCallable().call((Object)request);
    }

    public final UnaryCallable<UpdateContactRequest, Contact> updateContactCallable() {
        return this.stub.updateContactCallable();
    }

    public final BatchUpdateContactsResponse batchUpdateContacts(NetworkName parent, List<UpdateContactRequest> requests) {
        BatchUpdateContactsRequest request = BatchUpdateContactsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).addAllRequests(requests).build();
        return this.batchUpdateContacts(request);
    }

    public final BatchUpdateContactsResponse batchUpdateContacts(String parent, List<UpdateContactRequest> requests) {
        BatchUpdateContactsRequest request = BatchUpdateContactsRequest.newBuilder().setParent(parent).addAllRequests(requests).build();
        return this.batchUpdateContacts(request);
    }

    public final BatchUpdateContactsResponse batchUpdateContacts(BatchUpdateContactsRequest request) {
        return (BatchUpdateContactsResponse)this.batchUpdateContactsCallable().call((Object)request);
    }

    public final UnaryCallable<BatchUpdateContactsRequest, BatchUpdateContactsResponse> batchUpdateContactsCallable() {
        return this.stub.batchUpdateContactsCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListContactsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListContactsRequest, ListContactsResponse, Contact, ListContactsPage, ListContactsFixedSizeCollection> {
        private ListContactsFixedSizeCollection(List<ListContactsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListContactsFixedSizeCollection createEmptyCollection() {
            return new ListContactsFixedSizeCollection(null, 0);
        }

        protected ListContactsFixedSizeCollection createCollection(List<ListContactsPage> pages, int collectionSize) {
            return new ListContactsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListContactsPage
    extends AbstractPage<ListContactsRequest, ListContactsResponse, Contact, ListContactsPage> {
        private ListContactsPage(PageContext<ListContactsRequest, ListContactsResponse, Contact> context, ListContactsResponse response) {
            super(context, (Object)response);
        }

        private static ListContactsPage createEmptyPage() {
            return new ListContactsPage(null, null);
        }

        protected ListContactsPage createPage(PageContext<ListContactsRequest, ListContactsResponse, Contact> context, ListContactsResponse response) {
            return new ListContactsPage(context, response);
        }

        public ApiFuture<ListContactsPage> createPageAsync(PageContext<ListContactsRequest, ListContactsResponse, Contact> context, ApiFuture<ListContactsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListContactsPagedResponse
    extends AbstractPagedListResponse<ListContactsRequest, ListContactsResponse, Contact, ListContactsPage, ListContactsFixedSizeCollection> {
        public static ApiFuture<ListContactsPagedResponse> createAsync(PageContext<ListContactsRequest, ListContactsResponse, Contact> context, ApiFuture<ListContactsResponse> futureResponse) {
            ApiFuture<ListContactsPage> futurePage = ListContactsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListContactsPagedResponse((ListContactsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListContactsPagedResponse(ListContactsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListContactsFixedSizeCollection.createEmptyCollection());
        }
    }
}

