/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.admanager.v1;

import com.google.ads.admanager.v1.BrowserLanguage;
import com.google.ads.admanager.v1.BrowserLanguageName;
import com.google.ads.admanager.v1.BrowserLanguageServiceSettings;
import com.google.ads.admanager.v1.GetBrowserLanguageRequest;
import com.google.ads.admanager.v1.ListBrowserLanguagesRequest;
import com.google.ads.admanager.v1.ListBrowserLanguagesResponse;
import com.google.ads.admanager.v1.NetworkName;
import com.google.ads.admanager.v1.stub.BrowserLanguageServiceStub;
import com.google.ads.admanager.v1.stub.BrowserLanguageServiceStubSettings;
import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.common.util.concurrent.MoreExecutors;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class BrowserLanguageServiceClient
implements BackgroundResource {
    private final BrowserLanguageServiceSettings settings;
    private final BrowserLanguageServiceStub stub;

    public static final BrowserLanguageServiceClient create() throws IOException {
        return BrowserLanguageServiceClient.create(BrowserLanguageServiceSettings.newBuilder().build());
    }

    public static final BrowserLanguageServiceClient create(BrowserLanguageServiceSettings settings) throws IOException {
        return new BrowserLanguageServiceClient(settings);
    }

    public static final BrowserLanguageServiceClient create(BrowserLanguageServiceStub stub) {
        return new BrowserLanguageServiceClient(stub);
    }

    protected BrowserLanguageServiceClient(BrowserLanguageServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((BrowserLanguageServiceStubSettings)settings.getStubSettings()).createStub();
    }

    protected BrowserLanguageServiceClient(BrowserLanguageServiceStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final BrowserLanguageServiceSettings getSettings() {
        return this.settings;
    }

    public BrowserLanguageServiceStub getStub() {
        return this.stub;
    }

    public final BrowserLanguage getBrowserLanguage(BrowserLanguageName name) {
        GetBrowserLanguageRequest request = GetBrowserLanguageRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getBrowserLanguage(request);
    }

    public final BrowserLanguage getBrowserLanguage(String name) {
        GetBrowserLanguageRequest request = GetBrowserLanguageRequest.newBuilder().setName(name).build();
        return this.getBrowserLanguage(request);
    }

    public final BrowserLanguage getBrowserLanguage(GetBrowserLanguageRequest request) {
        return (BrowserLanguage)this.getBrowserLanguageCallable().call((Object)request);
    }

    public final UnaryCallable<GetBrowserLanguageRequest, BrowserLanguage> getBrowserLanguageCallable() {
        return this.stub.getBrowserLanguageCallable();
    }

    public final ListBrowserLanguagesPagedResponse listBrowserLanguages(NetworkName parent) {
        ListBrowserLanguagesRequest request = ListBrowserLanguagesRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listBrowserLanguages(request);
    }

    public final ListBrowserLanguagesPagedResponse listBrowserLanguages(String parent) {
        ListBrowserLanguagesRequest request = ListBrowserLanguagesRequest.newBuilder().setParent(parent).build();
        return this.listBrowserLanguages(request);
    }

    public final ListBrowserLanguagesPagedResponse listBrowserLanguages(ListBrowserLanguagesRequest request) {
        return (ListBrowserLanguagesPagedResponse)((Object)this.listBrowserLanguagesPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListBrowserLanguagesRequest, ListBrowserLanguagesPagedResponse> listBrowserLanguagesPagedCallable() {
        return this.stub.listBrowserLanguagesPagedCallable();
    }

    public final UnaryCallable<ListBrowserLanguagesRequest, ListBrowserLanguagesResponse> listBrowserLanguagesCallable() {
        return this.stub.listBrowserLanguagesCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListBrowserLanguagesFixedSizeCollection
    extends AbstractFixedSizeCollection<ListBrowserLanguagesRequest, ListBrowserLanguagesResponse, BrowserLanguage, ListBrowserLanguagesPage, ListBrowserLanguagesFixedSizeCollection> {
        private ListBrowserLanguagesFixedSizeCollection(List<ListBrowserLanguagesPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListBrowserLanguagesFixedSizeCollection createEmptyCollection() {
            return new ListBrowserLanguagesFixedSizeCollection(null, 0);
        }

        protected ListBrowserLanguagesFixedSizeCollection createCollection(List<ListBrowserLanguagesPage> pages, int collectionSize) {
            return new ListBrowserLanguagesFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListBrowserLanguagesPage
    extends AbstractPage<ListBrowserLanguagesRequest, ListBrowserLanguagesResponse, BrowserLanguage, ListBrowserLanguagesPage> {
        private ListBrowserLanguagesPage(PageContext<ListBrowserLanguagesRequest, ListBrowserLanguagesResponse, BrowserLanguage> context, ListBrowserLanguagesResponse response) {
            super(context, (Object)response);
        }

        private static ListBrowserLanguagesPage createEmptyPage() {
            return new ListBrowserLanguagesPage(null, null);
        }

        protected ListBrowserLanguagesPage createPage(PageContext<ListBrowserLanguagesRequest, ListBrowserLanguagesResponse, BrowserLanguage> context, ListBrowserLanguagesResponse response) {
            return new ListBrowserLanguagesPage(context, response);
        }

        public ApiFuture<ListBrowserLanguagesPage> createPageAsync(PageContext<ListBrowserLanguagesRequest, ListBrowserLanguagesResponse, BrowserLanguage> context, ApiFuture<ListBrowserLanguagesResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListBrowserLanguagesPagedResponse
    extends AbstractPagedListResponse<ListBrowserLanguagesRequest, ListBrowserLanguagesResponse, BrowserLanguage, ListBrowserLanguagesPage, ListBrowserLanguagesFixedSizeCollection> {
        public static ApiFuture<ListBrowserLanguagesPagedResponse> createAsync(PageContext<ListBrowserLanguagesRequest, ListBrowserLanguagesResponse, BrowserLanguage> context, ApiFuture<ListBrowserLanguagesResponse> futureResponse) {
            ApiFuture<ListBrowserLanguagesPage> futurePage = ListBrowserLanguagesPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListBrowserLanguagesPagedResponse((ListBrowserLanguagesPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListBrowserLanguagesPagedResponse(ListBrowserLanguagesPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListBrowserLanguagesFixedSizeCollection.createEmptyCollection());
        }
    }
}

