/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.admanager.v1;

import com.google.ads.admanager.v1.BandwidthGroup;
import com.google.ads.admanager.v1.BandwidthGroupName;
import com.google.ads.admanager.v1.BandwidthGroupServiceSettings;
import com.google.ads.admanager.v1.GetBandwidthGroupRequest;
import com.google.ads.admanager.v1.ListBandwidthGroupsRequest;
import com.google.ads.admanager.v1.ListBandwidthGroupsResponse;
import com.google.ads.admanager.v1.NetworkName;
import com.google.ads.admanager.v1.stub.BandwidthGroupServiceStub;
import com.google.ads.admanager.v1.stub.BandwidthGroupServiceStubSettings;
import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.common.util.concurrent.MoreExecutors;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class BandwidthGroupServiceClient
implements BackgroundResource {
    private final BandwidthGroupServiceSettings settings;
    private final BandwidthGroupServiceStub stub;

    public static final BandwidthGroupServiceClient create() throws IOException {
        return BandwidthGroupServiceClient.create(BandwidthGroupServiceSettings.newBuilder().build());
    }

    public static final BandwidthGroupServiceClient create(BandwidthGroupServiceSettings settings) throws IOException {
        return new BandwidthGroupServiceClient(settings);
    }

    public static final BandwidthGroupServiceClient create(BandwidthGroupServiceStub stub) {
        return new BandwidthGroupServiceClient(stub);
    }

    protected BandwidthGroupServiceClient(BandwidthGroupServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((BandwidthGroupServiceStubSettings)settings.getStubSettings()).createStub();
    }

    protected BandwidthGroupServiceClient(BandwidthGroupServiceStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final BandwidthGroupServiceSettings getSettings() {
        return this.settings;
    }

    public BandwidthGroupServiceStub getStub() {
        return this.stub;
    }

    public final BandwidthGroup getBandwidthGroup(BandwidthGroupName name) {
        GetBandwidthGroupRequest request = GetBandwidthGroupRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getBandwidthGroup(request);
    }

    public final BandwidthGroup getBandwidthGroup(String name) {
        GetBandwidthGroupRequest request = GetBandwidthGroupRequest.newBuilder().setName(name).build();
        return this.getBandwidthGroup(request);
    }

    public final BandwidthGroup getBandwidthGroup(GetBandwidthGroupRequest request) {
        return (BandwidthGroup)this.getBandwidthGroupCallable().call((Object)request);
    }

    public final UnaryCallable<GetBandwidthGroupRequest, BandwidthGroup> getBandwidthGroupCallable() {
        return this.stub.getBandwidthGroupCallable();
    }

    public final ListBandwidthGroupsPagedResponse listBandwidthGroups(NetworkName parent) {
        ListBandwidthGroupsRequest request = ListBandwidthGroupsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listBandwidthGroups(request);
    }

    public final ListBandwidthGroupsPagedResponse listBandwidthGroups(String parent) {
        ListBandwidthGroupsRequest request = ListBandwidthGroupsRequest.newBuilder().setParent(parent).build();
        return this.listBandwidthGroups(request);
    }

    public final ListBandwidthGroupsPagedResponse listBandwidthGroups(ListBandwidthGroupsRequest request) {
        return (ListBandwidthGroupsPagedResponse)((Object)this.listBandwidthGroupsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListBandwidthGroupsRequest, ListBandwidthGroupsPagedResponse> listBandwidthGroupsPagedCallable() {
        return this.stub.listBandwidthGroupsPagedCallable();
    }

    public final UnaryCallable<ListBandwidthGroupsRequest, ListBandwidthGroupsResponse> listBandwidthGroupsCallable() {
        return this.stub.listBandwidthGroupsCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListBandwidthGroupsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListBandwidthGroupsRequest, ListBandwidthGroupsResponse, BandwidthGroup, ListBandwidthGroupsPage, ListBandwidthGroupsFixedSizeCollection> {
        private ListBandwidthGroupsFixedSizeCollection(List<ListBandwidthGroupsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListBandwidthGroupsFixedSizeCollection createEmptyCollection() {
            return new ListBandwidthGroupsFixedSizeCollection(null, 0);
        }

        protected ListBandwidthGroupsFixedSizeCollection createCollection(List<ListBandwidthGroupsPage> pages, int collectionSize) {
            return new ListBandwidthGroupsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListBandwidthGroupsPage
    extends AbstractPage<ListBandwidthGroupsRequest, ListBandwidthGroupsResponse, BandwidthGroup, ListBandwidthGroupsPage> {
        private ListBandwidthGroupsPage(PageContext<ListBandwidthGroupsRequest, ListBandwidthGroupsResponse, BandwidthGroup> context, ListBandwidthGroupsResponse response) {
            super(context, (Object)response);
        }

        private static ListBandwidthGroupsPage createEmptyPage() {
            return new ListBandwidthGroupsPage(null, null);
        }

        protected ListBandwidthGroupsPage createPage(PageContext<ListBandwidthGroupsRequest, ListBandwidthGroupsResponse, BandwidthGroup> context, ListBandwidthGroupsResponse response) {
            return new ListBandwidthGroupsPage(context, response);
        }

        public ApiFuture<ListBandwidthGroupsPage> createPageAsync(PageContext<ListBandwidthGroupsRequest, ListBandwidthGroupsResponse, BandwidthGroup> context, ApiFuture<ListBandwidthGroupsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListBandwidthGroupsPagedResponse
    extends AbstractPagedListResponse<ListBandwidthGroupsRequest, ListBandwidthGroupsResponse, BandwidthGroup, ListBandwidthGroupsPage, ListBandwidthGroupsFixedSizeCollection> {
        public static ApiFuture<ListBandwidthGroupsPagedResponse> createAsync(PageContext<ListBandwidthGroupsRequest, ListBandwidthGroupsResponse, BandwidthGroup> context, ApiFuture<ListBandwidthGroupsResponse> futureResponse) {
            ApiFuture<ListBandwidthGroupsPage> futurePage = ListBandwidthGroupsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListBandwidthGroupsPagedResponse((ListBandwidthGroupsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListBandwidthGroupsPagedResponse(ListBandwidthGroupsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListBandwidthGroupsFixedSizeCollection.createEmptyCollection());
        }
    }
}

