/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.admanager.v1;

import com.google.ads.admanager.v1.AudienceSegment;
import com.google.ads.admanager.v1.AudienceSegmentName;
import com.google.ads.admanager.v1.AudienceSegmentServiceSettings;
import com.google.ads.admanager.v1.GetAudienceSegmentRequest;
import com.google.ads.admanager.v1.ListAudienceSegmentsRequest;
import com.google.ads.admanager.v1.ListAudienceSegmentsResponse;
import com.google.ads.admanager.v1.NetworkName;
import com.google.ads.admanager.v1.stub.AudienceSegmentServiceStub;
import com.google.ads.admanager.v1.stub.AudienceSegmentServiceStubSettings;
import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.common.util.concurrent.MoreExecutors;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class AudienceSegmentServiceClient
implements BackgroundResource {
    private final AudienceSegmentServiceSettings settings;
    private final AudienceSegmentServiceStub stub;

    public static final AudienceSegmentServiceClient create() throws IOException {
        return AudienceSegmentServiceClient.create(AudienceSegmentServiceSettings.newBuilder().build());
    }

    public static final AudienceSegmentServiceClient create(AudienceSegmentServiceSettings settings) throws IOException {
        return new AudienceSegmentServiceClient(settings);
    }

    public static final AudienceSegmentServiceClient create(AudienceSegmentServiceStub stub) {
        return new AudienceSegmentServiceClient(stub);
    }

    protected AudienceSegmentServiceClient(AudienceSegmentServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((AudienceSegmentServiceStubSettings)settings.getStubSettings()).createStub();
    }

    protected AudienceSegmentServiceClient(AudienceSegmentServiceStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final AudienceSegmentServiceSettings getSettings() {
        return this.settings;
    }

    public AudienceSegmentServiceStub getStub() {
        return this.stub;
    }

    public final AudienceSegment getAudienceSegment(AudienceSegmentName name) {
        GetAudienceSegmentRequest request = GetAudienceSegmentRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getAudienceSegment(request);
    }

    public final AudienceSegment getAudienceSegment(String name) {
        GetAudienceSegmentRequest request = GetAudienceSegmentRequest.newBuilder().setName(name).build();
        return this.getAudienceSegment(request);
    }

    public final AudienceSegment getAudienceSegment(GetAudienceSegmentRequest request) {
        return (AudienceSegment)this.getAudienceSegmentCallable().call((Object)request);
    }

    public final UnaryCallable<GetAudienceSegmentRequest, AudienceSegment> getAudienceSegmentCallable() {
        return this.stub.getAudienceSegmentCallable();
    }

    public final ListAudienceSegmentsPagedResponse listAudienceSegments(NetworkName parent) {
        ListAudienceSegmentsRequest request = ListAudienceSegmentsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listAudienceSegments(request);
    }

    public final ListAudienceSegmentsPagedResponse listAudienceSegments(String parent) {
        ListAudienceSegmentsRequest request = ListAudienceSegmentsRequest.newBuilder().setParent(parent).build();
        return this.listAudienceSegments(request);
    }

    public final ListAudienceSegmentsPagedResponse listAudienceSegments(ListAudienceSegmentsRequest request) {
        return (ListAudienceSegmentsPagedResponse)((Object)this.listAudienceSegmentsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListAudienceSegmentsRequest, ListAudienceSegmentsPagedResponse> listAudienceSegmentsPagedCallable() {
        return this.stub.listAudienceSegmentsPagedCallable();
    }

    public final UnaryCallable<ListAudienceSegmentsRequest, ListAudienceSegmentsResponse> listAudienceSegmentsCallable() {
        return this.stub.listAudienceSegmentsCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListAudienceSegmentsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListAudienceSegmentsRequest, ListAudienceSegmentsResponse, AudienceSegment, ListAudienceSegmentsPage, ListAudienceSegmentsFixedSizeCollection> {
        private ListAudienceSegmentsFixedSizeCollection(List<ListAudienceSegmentsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListAudienceSegmentsFixedSizeCollection createEmptyCollection() {
            return new ListAudienceSegmentsFixedSizeCollection(null, 0);
        }

        protected ListAudienceSegmentsFixedSizeCollection createCollection(List<ListAudienceSegmentsPage> pages, int collectionSize) {
            return new ListAudienceSegmentsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListAudienceSegmentsPage
    extends AbstractPage<ListAudienceSegmentsRequest, ListAudienceSegmentsResponse, AudienceSegment, ListAudienceSegmentsPage> {
        private ListAudienceSegmentsPage(PageContext<ListAudienceSegmentsRequest, ListAudienceSegmentsResponse, AudienceSegment> context, ListAudienceSegmentsResponse response) {
            super(context, (Object)response);
        }

        private static ListAudienceSegmentsPage createEmptyPage() {
            return new ListAudienceSegmentsPage(null, null);
        }

        protected ListAudienceSegmentsPage createPage(PageContext<ListAudienceSegmentsRequest, ListAudienceSegmentsResponse, AudienceSegment> context, ListAudienceSegmentsResponse response) {
            return new ListAudienceSegmentsPage(context, response);
        }

        public ApiFuture<ListAudienceSegmentsPage> createPageAsync(PageContext<ListAudienceSegmentsRequest, ListAudienceSegmentsResponse, AudienceSegment> context, ApiFuture<ListAudienceSegmentsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListAudienceSegmentsPagedResponse
    extends AbstractPagedListResponse<ListAudienceSegmentsRequest, ListAudienceSegmentsResponse, AudienceSegment, ListAudienceSegmentsPage, ListAudienceSegmentsFixedSizeCollection> {
        public static ApiFuture<ListAudienceSegmentsPagedResponse> createAsync(PageContext<ListAudienceSegmentsRequest, ListAudienceSegmentsResponse, AudienceSegment> context, ApiFuture<ListAudienceSegmentsResponse> futureResponse) {
            ApiFuture<ListAudienceSegmentsPage> futurePage = ListAudienceSegmentsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListAudienceSegmentsPagedResponse((ListAudienceSegmentsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListAudienceSegmentsPagedResponse(ListAudienceSegmentsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListAudienceSegmentsFixedSizeCollection.createEmptyCollection());
        }
    }
}

