/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.admanager.v1;

import com.google.ads.admanager.v1.BatchActivatePlacementsRequest;
import com.google.ads.admanager.v1.BatchActivatePlacementsResponse;
import com.google.ads.admanager.v1.BatchArchivePlacementsRequest;
import com.google.ads.admanager.v1.BatchArchivePlacementsResponse;
import com.google.ads.admanager.v1.BatchCreatePlacementsRequest;
import com.google.ads.admanager.v1.BatchCreatePlacementsResponse;
import com.google.ads.admanager.v1.BatchDeactivatePlacementsRequest;
import com.google.ads.admanager.v1.BatchDeactivatePlacementsResponse;
import com.google.ads.admanager.v1.BatchUpdatePlacementsRequest;
import com.google.ads.admanager.v1.BatchUpdatePlacementsResponse;
import com.google.ads.admanager.v1.CreatePlacementRequest;
import com.google.ads.admanager.v1.GetPlacementRequest;
import com.google.ads.admanager.v1.ListPlacementsRequest;
import com.google.ads.admanager.v1.ListPlacementsResponse;
import com.google.ads.admanager.v1.NetworkName;
import com.google.ads.admanager.v1.Placement;
import com.google.ads.admanager.v1.PlacementName;
import com.google.ads.admanager.v1.PlacementServiceSettings;
import com.google.ads.admanager.v1.UpdatePlacementRequest;
import com.google.ads.admanager.v1.stub.PlacementServiceStub;
import com.google.ads.admanager.v1.stub.PlacementServiceStubSettings;
import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.protobuf.FieldMask;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class PlacementServiceClient
implements BackgroundResource {
    private final PlacementServiceSettings settings;
    private final PlacementServiceStub stub;

    public static final PlacementServiceClient create() throws IOException {
        return PlacementServiceClient.create(PlacementServiceSettings.newBuilder().build());
    }

    public static final PlacementServiceClient create(PlacementServiceSettings settings) throws IOException {
        return new PlacementServiceClient(settings);
    }

    public static final PlacementServiceClient create(PlacementServiceStub stub) {
        return new PlacementServiceClient(stub);
    }

    protected PlacementServiceClient(PlacementServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((PlacementServiceStubSettings)settings.getStubSettings()).createStub();
    }

    protected PlacementServiceClient(PlacementServiceStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final PlacementServiceSettings getSettings() {
        return this.settings;
    }

    public PlacementServiceStub getStub() {
        return this.stub;
    }

    public final Placement getPlacement(PlacementName name) {
        GetPlacementRequest request = GetPlacementRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getPlacement(request);
    }

    public final Placement getPlacement(String name) {
        GetPlacementRequest request = GetPlacementRequest.newBuilder().setName(name).build();
        return this.getPlacement(request);
    }

    public final Placement getPlacement(GetPlacementRequest request) {
        return (Placement)this.getPlacementCallable().call((Object)request);
    }

    public final UnaryCallable<GetPlacementRequest, Placement> getPlacementCallable() {
        return this.stub.getPlacementCallable();
    }

    public final ListPlacementsPagedResponse listPlacements(NetworkName parent) {
        ListPlacementsRequest request = ListPlacementsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listPlacements(request);
    }

    public final ListPlacementsPagedResponse listPlacements(String parent) {
        ListPlacementsRequest request = ListPlacementsRequest.newBuilder().setParent(parent).build();
        return this.listPlacements(request);
    }

    public final ListPlacementsPagedResponse listPlacements(ListPlacementsRequest request) {
        return (ListPlacementsPagedResponse)((Object)this.listPlacementsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListPlacementsRequest, ListPlacementsPagedResponse> listPlacementsPagedCallable() {
        return this.stub.listPlacementsPagedCallable();
    }

    public final UnaryCallable<ListPlacementsRequest, ListPlacementsResponse> listPlacementsCallable() {
        return this.stub.listPlacementsCallable();
    }

    public final Placement createPlacement(NetworkName parent, Placement placement) {
        CreatePlacementRequest request = CreatePlacementRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setPlacement(placement).build();
        return this.createPlacement(request);
    }

    public final Placement createPlacement(String parent, Placement placement) {
        CreatePlacementRequest request = CreatePlacementRequest.newBuilder().setParent(parent).setPlacement(placement).build();
        return this.createPlacement(request);
    }

    public final Placement createPlacement(CreatePlacementRequest request) {
        return (Placement)this.createPlacementCallable().call((Object)request);
    }

    public final UnaryCallable<CreatePlacementRequest, Placement> createPlacementCallable() {
        return this.stub.createPlacementCallable();
    }

    public final Placement updatePlacement(Placement placement, FieldMask updateMask) {
        UpdatePlacementRequest request = UpdatePlacementRequest.newBuilder().setPlacement(placement).setUpdateMask(updateMask).build();
        return this.updatePlacement(request);
    }

    public final Placement updatePlacement(UpdatePlacementRequest request) {
        return (Placement)this.updatePlacementCallable().call((Object)request);
    }

    public final UnaryCallable<UpdatePlacementRequest, Placement> updatePlacementCallable() {
        return this.stub.updatePlacementCallable();
    }

    public final BatchCreatePlacementsResponse batchCreatePlacements(NetworkName parent, List<CreatePlacementRequest> requests) {
        BatchCreatePlacementsRequest request = BatchCreatePlacementsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).addAllRequests(requests).build();
        return this.batchCreatePlacements(request);
    }

    public final BatchCreatePlacementsResponse batchCreatePlacements(String parent, List<CreatePlacementRequest> requests) {
        BatchCreatePlacementsRequest request = BatchCreatePlacementsRequest.newBuilder().setParent(parent).addAllRequests(requests).build();
        return this.batchCreatePlacements(request);
    }

    public final BatchCreatePlacementsResponse batchCreatePlacements(BatchCreatePlacementsRequest request) {
        return (BatchCreatePlacementsResponse)this.batchCreatePlacementsCallable().call((Object)request);
    }

    public final UnaryCallable<BatchCreatePlacementsRequest, BatchCreatePlacementsResponse> batchCreatePlacementsCallable() {
        return this.stub.batchCreatePlacementsCallable();
    }

    public final BatchUpdatePlacementsResponse batchUpdatePlacements(NetworkName parent, List<UpdatePlacementRequest> requests) {
        BatchUpdatePlacementsRequest request = BatchUpdatePlacementsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).addAllRequests(requests).build();
        return this.batchUpdatePlacements(request);
    }

    public final BatchUpdatePlacementsResponse batchUpdatePlacements(String parent, List<UpdatePlacementRequest> requests) {
        BatchUpdatePlacementsRequest request = BatchUpdatePlacementsRequest.newBuilder().setParent(parent).addAllRequests(requests).build();
        return this.batchUpdatePlacements(request);
    }

    public final BatchUpdatePlacementsResponse batchUpdatePlacements(BatchUpdatePlacementsRequest request) {
        return (BatchUpdatePlacementsResponse)this.batchUpdatePlacementsCallable().call((Object)request);
    }

    public final UnaryCallable<BatchUpdatePlacementsRequest, BatchUpdatePlacementsResponse> batchUpdatePlacementsCallable() {
        return this.stub.batchUpdatePlacementsCallable();
    }

    public final BatchActivatePlacementsResponse batchActivatePlacements(NetworkName parent, List<String> names) {
        BatchActivatePlacementsRequest request = BatchActivatePlacementsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).addAllNames(names).build();
        return this.batchActivatePlacements(request);
    }

    public final BatchActivatePlacementsResponse batchActivatePlacements(String parent, List<String> names) {
        BatchActivatePlacementsRequest request = BatchActivatePlacementsRequest.newBuilder().setParent(parent).addAllNames(names).build();
        return this.batchActivatePlacements(request);
    }

    public final BatchActivatePlacementsResponse batchActivatePlacements(BatchActivatePlacementsRequest request) {
        return (BatchActivatePlacementsResponse)this.batchActivatePlacementsCallable().call((Object)request);
    }

    public final UnaryCallable<BatchActivatePlacementsRequest, BatchActivatePlacementsResponse> batchActivatePlacementsCallable() {
        return this.stub.batchActivatePlacementsCallable();
    }

    public final BatchDeactivatePlacementsResponse batchDeactivatePlacements(NetworkName parent, List<String> names) {
        BatchDeactivatePlacementsRequest request = BatchDeactivatePlacementsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).addAllNames(names).build();
        return this.batchDeactivatePlacements(request);
    }

    public final BatchDeactivatePlacementsResponse batchDeactivatePlacements(String parent, List<String> names) {
        BatchDeactivatePlacementsRequest request = BatchDeactivatePlacementsRequest.newBuilder().setParent(parent).addAllNames(names).build();
        return this.batchDeactivatePlacements(request);
    }

    public final BatchDeactivatePlacementsResponse batchDeactivatePlacements(BatchDeactivatePlacementsRequest request) {
        return (BatchDeactivatePlacementsResponse)this.batchDeactivatePlacementsCallable().call((Object)request);
    }

    public final UnaryCallable<BatchDeactivatePlacementsRequest, BatchDeactivatePlacementsResponse> batchDeactivatePlacementsCallable() {
        return this.stub.batchDeactivatePlacementsCallable();
    }

    public final BatchArchivePlacementsResponse batchArchivePlacements(NetworkName parent, List<String> names) {
        BatchArchivePlacementsRequest request = BatchArchivePlacementsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).addAllNames(names).build();
        return this.batchArchivePlacements(request);
    }

    public final BatchArchivePlacementsResponse batchArchivePlacements(String parent, List<String> names) {
        BatchArchivePlacementsRequest request = BatchArchivePlacementsRequest.newBuilder().setParent(parent).addAllNames(names).build();
        return this.batchArchivePlacements(request);
    }

    public final BatchArchivePlacementsResponse batchArchivePlacements(BatchArchivePlacementsRequest request) {
        return (BatchArchivePlacementsResponse)this.batchArchivePlacementsCallable().call((Object)request);
    }

    public final UnaryCallable<BatchArchivePlacementsRequest, BatchArchivePlacementsResponse> batchArchivePlacementsCallable() {
        return this.stub.batchArchivePlacementsCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListPlacementsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListPlacementsRequest, ListPlacementsResponse, Placement, ListPlacementsPage, ListPlacementsFixedSizeCollection> {
        private ListPlacementsFixedSizeCollection(List<ListPlacementsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListPlacementsFixedSizeCollection createEmptyCollection() {
            return new ListPlacementsFixedSizeCollection(null, 0);
        }

        protected ListPlacementsFixedSizeCollection createCollection(List<ListPlacementsPage> pages, int collectionSize) {
            return new ListPlacementsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListPlacementsPage
    extends AbstractPage<ListPlacementsRequest, ListPlacementsResponse, Placement, ListPlacementsPage> {
        private ListPlacementsPage(PageContext<ListPlacementsRequest, ListPlacementsResponse, Placement> context, ListPlacementsResponse response) {
            super(context, (Object)response);
        }

        private static ListPlacementsPage createEmptyPage() {
            return new ListPlacementsPage(null, null);
        }

        protected ListPlacementsPage createPage(PageContext<ListPlacementsRequest, ListPlacementsResponse, Placement> context, ListPlacementsResponse response) {
            return new ListPlacementsPage(context, response);
        }

        public ApiFuture<ListPlacementsPage> createPageAsync(PageContext<ListPlacementsRequest, ListPlacementsResponse, Placement> context, ApiFuture<ListPlacementsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListPlacementsPagedResponse
    extends AbstractPagedListResponse<ListPlacementsRequest, ListPlacementsResponse, Placement, ListPlacementsPage, ListPlacementsFixedSizeCollection> {
        public static ApiFuture<ListPlacementsPagedResponse> createAsync(PageContext<ListPlacementsRequest, ListPlacementsResponse, Placement> context, ApiFuture<ListPlacementsResponse> futureResponse) {
            ApiFuture<ListPlacementsPage> futurePage = ListPlacementsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListPlacementsPagedResponse((ListPlacementsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListPlacementsPagedResponse(ListPlacementsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListPlacementsFixedSizeCollection.createEmptyCollection());
        }
    }
}

