/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.admanager.v1;

import com.google.ads.admanager.v1.GetMobileCarrierRequest;
import com.google.ads.admanager.v1.ListMobileCarriersRequest;
import com.google.ads.admanager.v1.ListMobileCarriersResponse;
import com.google.ads.admanager.v1.MobileCarrier;
import com.google.ads.admanager.v1.MobileCarrierName;
import com.google.ads.admanager.v1.MobileCarrierServiceSettings;
import com.google.ads.admanager.v1.NetworkName;
import com.google.ads.admanager.v1.stub.MobileCarrierServiceStub;
import com.google.ads.admanager.v1.stub.MobileCarrierServiceStubSettings;
import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.common.util.concurrent.MoreExecutors;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class MobileCarrierServiceClient
implements BackgroundResource {
    private final MobileCarrierServiceSettings settings;
    private final MobileCarrierServiceStub stub;

    public static final MobileCarrierServiceClient create() throws IOException {
        return MobileCarrierServiceClient.create(MobileCarrierServiceSettings.newBuilder().build());
    }

    public static final MobileCarrierServiceClient create(MobileCarrierServiceSettings settings) throws IOException {
        return new MobileCarrierServiceClient(settings);
    }

    public static final MobileCarrierServiceClient create(MobileCarrierServiceStub stub) {
        return new MobileCarrierServiceClient(stub);
    }

    protected MobileCarrierServiceClient(MobileCarrierServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((MobileCarrierServiceStubSettings)settings.getStubSettings()).createStub();
    }

    protected MobileCarrierServiceClient(MobileCarrierServiceStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final MobileCarrierServiceSettings getSettings() {
        return this.settings;
    }

    public MobileCarrierServiceStub getStub() {
        return this.stub;
    }

    public final MobileCarrier getMobileCarrier(MobileCarrierName name) {
        GetMobileCarrierRequest request = GetMobileCarrierRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getMobileCarrier(request);
    }

    public final MobileCarrier getMobileCarrier(String name) {
        GetMobileCarrierRequest request = GetMobileCarrierRequest.newBuilder().setName(name).build();
        return this.getMobileCarrier(request);
    }

    public final MobileCarrier getMobileCarrier(GetMobileCarrierRequest request) {
        return (MobileCarrier)this.getMobileCarrierCallable().call((Object)request);
    }

    public final UnaryCallable<GetMobileCarrierRequest, MobileCarrier> getMobileCarrierCallable() {
        return this.stub.getMobileCarrierCallable();
    }

    public final ListMobileCarriersPagedResponse listMobileCarriers(NetworkName parent) {
        ListMobileCarriersRequest request = ListMobileCarriersRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listMobileCarriers(request);
    }

    public final ListMobileCarriersPagedResponse listMobileCarriers(String parent) {
        ListMobileCarriersRequest request = ListMobileCarriersRequest.newBuilder().setParent(parent).build();
        return this.listMobileCarriers(request);
    }

    public final ListMobileCarriersPagedResponse listMobileCarriers(ListMobileCarriersRequest request) {
        return (ListMobileCarriersPagedResponse)((Object)this.listMobileCarriersPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListMobileCarriersRequest, ListMobileCarriersPagedResponse> listMobileCarriersPagedCallable() {
        return this.stub.listMobileCarriersPagedCallable();
    }

    public final UnaryCallable<ListMobileCarriersRequest, ListMobileCarriersResponse> listMobileCarriersCallable() {
        return this.stub.listMobileCarriersCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListMobileCarriersFixedSizeCollection
    extends AbstractFixedSizeCollection<ListMobileCarriersRequest, ListMobileCarriersResponse, MobileCarrier, ListMobileCarriersPage, ListMobileCarriersFixedSizeCollection> {
        private ListMobileCarriersFixedSizeCollection(List<ListMobileCarriersPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListMobileCarriersFixedSizeCollection createEmptyCollection() {
            return new ListMobileCarriersFixedSizeCollection(null, 0);
        }

        protected ListMobileCarriersFixedSizeCollection createCollection(List<ListMobileCarriersPage> pages, int collectionSize) {
            return new ListMobileCarriersFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListMobileCarriersPage
    extends AbstractPage<ListMobileCarriersRequest, ListMobileCarriersResponse, MobileCarrier, ListMobileCarriersPage> {
        private ListMobileCarriersPage(PageContext<ListMobileCarriersRequest, ListMobileCarriersResponse, MobileCarrier> context, ListMobileCarriersResponse response) {
            super(context, (Object)response);
        }

        private static ListMobileCarriersPage createEmptyPage() {
            return new ListMobileCarriersPage(null, null);
        }

        protected ListMobileCarriersPage createPage(PageContext<ListMobileCarriersRequest, ListMobileCarriersResponse, MobileCarrier> context, ListMobileCarriersResponse response) {
            return new ListMobileCarriersPage(context, response);
        }

        public ApiFuture<ListMobileCarriersPage> createPageAsync(PageContext<ListMobileCarriersRequest, ListMobileCarriersResponse, MobileCarrier> context, ApiFuture<ListMobileCarriersResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListMobileCarriersPagedResponse
    extends AbstractPagedListResponse<ListMobileCarriersRequest, ListMobileCarriersResponse, MobileCarrier, ListMobileCarriersPage, ListMobileCarriersFixedSizeCollection> {
        public static ApiFuture<ListMobileCarriersPagedResponse> createAsync(PageContext<ListMobileCarriersRequest, ListMobileCarriersResponse, MobileCarrier> context, ApiFuture<ListMobileCarriersResponse> futureResponse) {
            ApiFuture<ListMobileCarriersPage> futurePage = ListMobileCarriersPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListMobileCarriersPagedResponse((ListMobileCarriersPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListMobileCarriersPagedResponse(ListMobileCarriersPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListMobileCarriersFixedSizeCollection.createEmptyCollection());
        }
    }
}

