/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.admanager.v1.stub;

import com.google.ads.admanager.v1.CreativeTemplate;
import com.google.ads.admanager.v1.CreativeTemplateServiceClient;
import com.google.ads.admanager.v1.GetCreativeTemplateRequest;
import com.google.ads.admanager.v1.ListCreativeTemplatesRequest;
import com.google.ads.admanager.v1.ListCreativeTemplatesResponse;
import com.google.ads.admanager.v1.stub.CreativeTemplateServiceStub;
import com.google.ads.admanager.v1.stub.HttpJsonCreativeTemplateServiceStub;
import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.ObsoleteApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;

public class CreativeTemplateServiceStubSettings
extends StubSettings<CreativeTemplateServiceStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/admanager").build();
    private final UnaryCallSettings<GetCreativeTemplateRequest, CreativeTemplate> getCreativeTemplateSettings;
    private final PagedCallSettings<ListCreativeTemplatesRequest, ListCreativeTemplatesResponse, CreativeTemplateServiceClient.ListCreativeTemplatesPagedResponse> listCreativeTemplatesSettings;
    private static final PagedListDescriptor<ListCreativeTemplatesRequest, ListCreativeTemplatesResponse, CreativeTemplate> LIST_CREATIVE_TEMPLATES_PAGE_STR_DESC = new PagedListDescriptor<ListCreativeTemplatesRequest, ListCreativeTemplatesResponse, CreativeTemplate>(){

        public String emptyToken() {
            return "";
        }

        public ListCreativeTemplatesRequest injectToken(ListCreativeTemplatesRequest payload, String token) {
            return ListCreativeTemplatesRequest.newBuilder((ListCreativeTemplatesRequest)payload).setPageToken(token).build();
        }

        public ListCreativeTemplatesRequest injectPageSize(ListCreativeTemplatesRequest payload, int pageSize) {
            return ListCreativeTemplatesRequest.newBuilder((ListCreativeTemplatesRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListCreativeTemplatesRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListCreativeTemplatesResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<CreativeTemplate> extractResources(ListCreativeTemplatesResponse payload) {
            return payload.getCreativeTemplatesList();
        }
    };
    private static final PagedListResponseFactory<ListCreativeTemplatesRequest, ListCreativeTemplatesResponse, CreativeTemplateServiceClient.ListCreativeTemplatesPagedResponse> LIST_CREATIVE_TEMPLATES_PAGE_STR_FACT = new PagedListResponseFactory<ListCreativeTemplatesRequest, ListCreativeTemplatesResponse, CreativeTemplateServiceClient.ListCreativeTemplatesPagedResponse>(){

        public ApiFuture<CreativeTemplateServiceClient.ListCreativeTemplatesPagedResponse> getFuturePagedResponse(UnaryCallable<ListCreativeTemplatesRequest, ListCreativeTemplatesResponse> callable, ListCreativeTemplatesRequest request, ApiCallContext context, ApiFuture<ListCreativeTemplatesResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_CREATIVE_TEMPLATES_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return CreativeTemplateServiceClient.ListCreativeTemplatesPagedResponse.createAsync((PageContext<ListCreativeTemplatesRequest, ListCreativeTemplatesResponse, CreativeTemplate>)pageContext, futureResponse);
        }
    };

    public UnaryCallSettings<GetCreativeTemplateRequest, CreativeTemplate> getCreativeTemplateSettings() {
        return this.getCreativeTemplateSettings;
    }

    public PagedCallSettings<ListCreativeTemplatesRequest, ListCreativeTemplatesResponse, CreativeTemplateServiceClient.ListCreativeTemplatesPagedResponse> listCreativeTemplatesSettings() {
        return this.listCreativeTemplatesSettings;
    }

    public CreativeTemplateServiceStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonCreativeTemplateServiceStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public String getServiceName() {
        return "admanager";
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    @ObsoleteApi(value="Use getEndpoint() instead")
    public static String getDefaultEndpoint() {
        return "admanager.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "admanager.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return CreativeTemplateServiceStubSettings.defaultHttpJsonTransportProviderBuilder().build();
    }

    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(CreativeTemplateServiceStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected CreativeTemplateServiceStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.getCreativeTemplateSettings = settingsBuilder.getCreativeTemplateSettings().build();
        this.listCreativeTemplatesSettings = settingsBuilder.listCreativeTemplatesSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<CreativeTemplateServiceStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final UnaryCallSettings.Builder<GetCreativeTemplateRequest, CreativeTemplate> getCreativeTemplateSettings;
        private final PagedCallSettings.Builder<ListCreativeTemplatesRequest, ListCreativeTemplatesResponse, CreativeTemplateServiceClient.ListCreativeTemplatesPagedResponse> listCreativeTemplatesSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.getCreativeTemplateSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listCreativeTemplatesSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_CREATIVE_TEMPLATES_PAGE_STR_FACT);
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.getCreativeTemplateSettings, this.listCreativeTemplatesSettings);
            Builder.initDefaults(this);
        }

        protected Builder(CreativeTemplateServiceStubSettings settings) {
            super((StubSettings)settings);
            this.getCreativeTemplateSettings = settings.getCreativeTemplateSettings.toBuilder();
            this.listCreativeTemplatesSettings = settings.listCreativeTemplatesSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.getCreativeTemplateSettings, this.listCreativeTemplatesSettings);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(CreativeTemplateServiceStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)CreativeTemplateServiceStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)CreativeTemplateServiceStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(CreativeTemplateServiceStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.getCreativeTemplateSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.listCreativeTemplatesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public UnaryCallSettings.Builder<GetCreativeTemplateRequest, CreativeTemplate> getCreativeTemplateSettings() {
            return this.getCreativeTemplateSettings;
        }

        public PagedCallSettings.Builder<ListCreativeTemplatesRequest, ListCreativeTemplatesResponse, CreativeTemplateServiceClient.ListCreativeTemplatesPagedResponse> listCreativeTemplatesSettings() {
            return this.listCreativeTemplatesSettings;
        }

        public CreativeTemplateServiceStubSettings build() throws IOException {
            return new CreativeTemplateServiceStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"no_retry_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setRpcTimeoutMultiplier(1.0).build();
            definitions.put((Object)"no_retry_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

